#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
republika.co.yu
'''

import re
from calibre.web.feeds.news import BasicNewsRecipe

class Republika(BasicNewsRecipe):
    title                 = 'Republika'
    __author__            = 'Darko Miletic'
    description           = 'Glasilo gradjanskog samooslobadjanja. Protiv stihije straha, mrznje i nasilja'
    publisher             = ' Zadruga Res Publica'
    category              = 'news, politics, Serbia'    
    language = 'sr'

    lang                  = 'sr-Latn-RS'
    oldest_article        = 2
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'cp1250'
    use_embedded_content  = False
    INDEX                 = u'http://www.republika.co.yu/'
    extra_css = ' @font-face {font-family: "serif1"; src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} body{font-family: serif1, serif} .article_description{font-family: serif1, serif} .naslov{font-size: x-large; font-weight: bold} .autor{font-size: small; font-weight: bold} '
    
    conversion_options = {
                          'comment'          : description
                        , 'tags'             : category
                        , 'publisher'        : publisher
                        , 'language'         : lang
                        , 'pretty_print'     : True
                        }
     
    preprocess_regexps = [(re.compile(u'\u0110'), lambda match: u'\u00D0')]

    keep_only_tags = [  dict(attrs={'class':'naslov'})
                      , dict(attrs={'class':'text1'})
                     ]

    remove_tags = [dict(name=['object','link','iframe','base','img'])]

    feeds = [(u'Svi clanci', INDEX)]

    def preprocess_html(self, soup):
        attribs = [  'style','font','valign'
                    ,'colspan','width','height'
                    ,'rowspan','summary','align'
                    ,'cellspacing','cellpadding'
                    ,'frames','rules','border'
                  ]
        for item in soup.body.findAll(name=['table','td','tr','th','caption','thead','tfoot','tbody','colgroup','col']):
            item.name = 'div'
            for attrib in attribs:
                if item.has_key(attrib):
                   del item[attrib]
        return soup

    def parse_index(self):
        totalfeeds = []
        lfeeds = self.get_feeds()
        for feedobj in lfeeds:
            feedtitle, feedurl = feedobj
            self.report_progress(0, _('Fetching feed')+' %s...'%(feedtitle if feedtitle else feedurl))
            articles = []
            soup = self.index_to_soup(feedurl)
            for item in soup.findAll('a', attrs={'class':'naslovLink'}):
                url         = item['href']
                title       = self.tag_to_string(item)
                articles.append({
                                      'title'      :title
                                     ,'date'       :''
                                     ,'url'        :url
                                     ,'description':''
                                    })
            totalfeeds.append((feedtitle, articles))
        return totalfeeds
        
