/*
 * Decompiled with CFR 0.152.
 */
package mso.generator.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.CRC32;
import mso.generator.utils.Choice;
import mso.generator.utils.FixedChoice;
import mso.generator.utils.Limitation;
import mso.generator.utils.Struct;
import mso.generator.utils.TypeRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Member {
    public final TypeRegistry registry;
    public final String name;
    private final String typeName;
    public final String count;
    public final String size;
    public final String condition;
    public final boolean isArray;
    public final boolean isOptional;
    public final boolean isInteger;
    public final boolean isSimple;
    public final boolean isStruct;
    public final boolean isChoice;
    public final Limitation[] limitations;
    private static final String HEXINDEX = "0123456789abcdef          ABCDEF";

    private static byte[] hexToByte(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(n2++);
            int n3 = HEXINDEX.indexOf(c);
            int n4 = (n3 & 0xF) << 4;
            c = string.charAt(n2++);
            n3 = HEXINDEX.indexOf(c);
            byArray[i] = (byte)(n4 += n3 & 0xF);
        }
        return byArray;
    }

    Member(TypeRegistry typeRegistry, Element element) throws IOException {
        Iterator iterator;
        Object object;
        Object object2;
        ArrayList<Object> arrayList;
        this.registry = typeRegistry;
        this.name = element.getAttribute("name");
        this.condition = element.hasAttribute("condition") ? element.getAttribute("condition") : null;
        this.count = element.hasAttribute("count") ? element.getAttribute("count") : null;
        this.size = element.hasAttribute("size") ? element.getAttribute("size") : null;
        this.isOptional = element.hasAttribute("optional");
        boolean bl = this.isArray = this.count != null || element.hasAttribute("array");
        if (this.isOptional && this.isArray) {
            throw new IOException("Member " + this.name + " is optional and array, which is not allowed.");
        }
        if (element.hasAttribute("type")) {
            this.typeName = element.getAttribute("type");
            this.isInteger = false;
            this.isSimple = false;
            this.isChoice = false;
            this.isStruct = true;
        } else if (element.getNodeName().equals("choice")) {
            arrayList = element.getElementsByTagName("type");
            object2 = "";
            object = new ArrayList();
            iterator = (Element)element.getParentNode().getParentNode();
            for (int i = 0; i < arrayList.getLength(); ++i) {
                String string = ((Element)arrayList.item(i)).getAttribute("type");
                Element element2 = Member.getStructElement((Element)((Object)iterator), string);
                object2 = (String)object2 + string;
                TypeRegistry.Type type = this.registry.getType(element2.getAttribute("name"));
                if (type instanceof Struct) {
                    object.add((Struct)type);
                    continue;
                }
                object.add(new Struct(this.registry, element2));
            }
            Object object3 = new CRC32();
            object3.update(((String)object2).getBytes());
            this.typeName = object2 = "choice" + ((CRC32)object3).getValue();
            if (this.registry.getType(this.typeName) == null) {
                new Choice(this.registry, (String)object2, (List<Struct>)object, this.isOptional);
            }
            this.isInteger = false;
            this.isSimple = false;
            this.isChoice = true;
            this.isStruct = false;
        } else if (element.getNodeName().equals("fixedchoice")) {
            int n;
            arrayList = new TreeSet();
            object2 = element.getElementsByTagName("text");
            for (n = 0; n < object2.getLength(); ++n) {
                iterator = ((Element)object2.item(n)).getTextContent();
                arrayList.add(new ByteArray(((String)((Object)iterator)).getBytes("UTF8")));
            }
            object2 = element.getElementsByTagName("hex");
            for (n = 0; n < object2.getLength(); ++n) {
                iterator = ((Element)object2.item(n)).getTextContent();
                arrayList.add(new ByteArray(Member.hexToByte(iterator)));
            }
            object = new CRC32();
            for (Object object3 : arrayList) {
                object.update(((ByteArray)object3).data);
            }
            this.typeName = "fixedchoice" + ((CRC32)object).getValue();
            if (this.registry.getType(this.typeName) == null) {
                new FixedChoice(this.registry, this.typeName, (SortedSet<ByteArray>)((Object)arrayList), this.isOptional);
            }
            this.isInteger = false;
            this.isSimple = true;
            this.isChoice = true;
            this.isStruct = false;
        } else {
            this.typeName = element.getNodeName();
            this.isInteger = this.typeName.startsWith("int") || this.typeName.startsWith("uint");
            this.isSimple = true;
            this.isChoice = false;
            this.isStruct = false;
        }
        arrayList = new ArrayList<Object>();
        object2 = element.getChildNodes();
        for (int i = 0; i < object2.getLength(); ++i) {
            if (!(object2.item(i) instanceof Element)) continue;
            arrayList.add(new Limitation((Element)object2.item(i)));
        }
        this.limitations = arrayList.toArray(new Limitation[0]);
    }

    public TypeRegistry.Type type() {
        return this.registry.getType(this.typeName);
    }

    private static Element getStructElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName("struct");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("name").equals(string)) continue;
            return element2;
        }
        return null;
    }

    class ByteArray
    implements Comparable<ByteArray> {
        final byte[] data;

        ByteArray(byte[] byArray) {
            this.data = byArray;
        }

        @Override
        public int compareTo(ByteArray byteArray) {
            byte[] byArray = byteArray.data;
            for (int i = 0; i < this.data.length && i < byArray.length; ++i) {
                if (byArray[i] == this.data[i]) continue;
                return this.data[i] - byArray[i];
            }
            return this.data.length - byArray.length;
        }
    }
}

