/* This file is part of the KDE project
 * Copyright 2007 Marijn Kruisselbrink <mkruisselbrink@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "RemoveBarAction.h"

#include "../core/Staff.h"
#include "../core/Part.h"
#include "../core/Sheet.h"

#include "../commands/RemoveBarCommand.h"

#include "../SimpleEntryTool.h"
#include "../MusicShape.h"

#include <klocalizedstring.h>

using namespace MusicCore;

RemoveBarAction::RemoveBarAction(SimpleEntryTool* tool)
    : AbstractMusicAction(i18n("Remove bar"), tool)
{
    setCheckable(false);
}

void RemoveBarAction::mousePress(Staff* staff, int barIdx, const QPointF& pos)
{
    Q_UNUSED( staff );
    Q_UNUSED( pos );
    
    m_tool->addCommand(new RemoveBarCommand(m_tool->shape(), barIdx));
}

