/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: defaultlanguage.h,v 1.49.2.1 2004/01/21 11:57:28 vida Exp $
 */

#ifndef __DEFAULTLANGUAGE_H
#define __DEFAULTLANGUAGE_H

//
// Messages / Default language
//

string default_msg (int m, array arg)
{
  switch(m) {
  case M_LOGIN:
    return "Login:";
  case M_PASSWORD:
    return "Password:";
  case M_IMAPSERVER:
    return "IMAP server:";
  case M_PORT:
    return "Port:";
  case M_NOLOGIN:
    return sprintf ("<b>Could not log in:</b> %s", @arg);
  case M_LOGINERROR:
    return "Wrong login or password. Try again. ";
  case M_IMAPERROR:
    return "There was a problem talking to the mail (IMAP) server. "
           "Please contact the administrator.";
  case M_SMTPERROR:
    return sprintf("There was a problem talking to the outgoing mail (SMTP) server, "
           "and the mail was not sent to %s. The recipient of the mail might not exist.", @arg);
  case M_SMTPOK:
    return sprintf ("The mail \"%s\" was sent to: %s", @arg);
  case M_SAVEDUSERINTERFACE:
    return "From preferences";
  case M_USERINTERFACE:
    return "User interface:";
  case M_LOGIN_OK:
    return "OK";
  case M_ADDRBOOKERRROR:
    return "There was a problem talking to the address book server (LDAP)";

  case M_NEWMAIL:
    return "Compose";
  case M_MAILBOX:
    return sprintf("Mailbox: %s",@arg);
  case M_MAILBOXES:
    return "Mailboxes";
  case M_FILES:
    return "Files";
  case M_PREFS:
    return "Preferences";
  case M_LOGOUT:
    return "Logout";
  case M_LOGOUTCLOSE:
    return "Close this browser window to make sure no one can read your mail.";
  case M_LOGOUTRELOAD:
    return "Reload this page to login.";
  case M_CURRMAILBOX:
    return "Current Mailbox";
  case M_CHECKACTIVEMAILBOXES:
    return "Check inboxes";

  case M_FROM:
    return "From";
  case M_TO:
    return "To";
  case M_CC:
    return "Cc";
  case M_BCC:
    return "Bcc";
  case M_SUBJECT:
    return "Subject";
  case M_ATTACHMENTS:
    return "Attachments";
  case M_TIME:
    return "Time";
  case M_DATE:
    return "Date";
  case M_DELAY:
    return "Delay";
  case M_RECEIVED:
    return "Received";

  case  M_MARKFLAG:
    return "M";
  case M_NEWFLAG:
    return "N";
  case M_ANSWEREDFLAG:
    return "A";


  case M_SEND:
    return "Send";
  case M_CANCELSEND:
    return "Cancel";
  case M_SENDMOREFILES:
    return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
  case M_COMPOSEMAIL:
    return "Compose mail";
  case M_SPELLCHECK:
    return "Spell check";
  case M_DONTSAVEMAIL:
    return "Do not save this mail.";
  case M_ADDFILEASATTACHMENT:
    return "Add file as attachment";
  case M_NOATTACHMENTS:
    return "No attachments";
  case M_ADDATTACHMENT:
    return "Add attachment";
  case M_REMOVEMARKEDATTACHMENTS:
    return "Remove marked attachments";
  case M_UPLOADATTACHMENT:
    return "Upload attachment";
  case M_ADDMARKEDTOATTACHMENTS:
    return "Add marked to attachments";
  case M_UPLOADTOATTACHMENTS:
    return "Upload to attachments";
  case M_BACKTOCOMPOSE:
    return "Back to compose";
  case M_NOATTACHFILES:
    return "No files";
  case M_ATTACHMENTSHEADER:
    return "Attachments";
  case M_SENDSAVEFAILED:
    return "Mail was sent successfully, but save in folder failed.";
  case M_SENDNORECV:
    return "You must specify a recipient of the mail.";
  case M_DSN_DELAY:
    return("Report delayed delivery.");
  case M_DSN_SUCCESS:
    return("Report successful delivery.");
  case M_MDN:
    return("Report delivery.");
  case M_SAVEDRAFT:
    return("Save draft");
  case M_SENDBROKENADDR:
    return(sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0]));
  case M_SAVEMAILCOPY:
    return("Save a copy");
  case M_SENDBLIND:
    return ("Recipients don't see each other");
  case M_PSENDBLIND:
    return ("Recipients don't see each other button");
  case M_SEARCHREPLACE:
    return ("Search and replace");
  case M_CHECKBCC:
    return ("Send blind copy to administrator");

  case M_DELETEMARKED:
    return "Delete marked";
  case M_MOVEMARKED:
    return "Move marked to";
  case M_ARCHIVE:
    return "Archive";
  case M_SELECTMBOX:
    return "(Select a mailbox)";
  case M_CHECKNEWMAIL:
    return "Check for new mail";
  case M_MAILSHOWN:
    return sprintf("Mail %d-%d of %d", @arg);
  case M_BACKN:
    return sprintf("[<< Prev %d]", @arg);
  case M_EBACKN:
    return "Prev";
  case M_FORWARDN:
    return sprintf("[Next %d >>]", @arg);
  case M_EFORWARDN:
    return "Next";
  case M_SENDMARKEDDRAFTS:
    return "Send marked drafts";
  case M_SENDMARKEDDRAFTSMOVE:
    return "Send marked drafts and move";
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    return sprintf("Are you sure you want to delete the %d marked message(s)?", @arg);
  case M_DELETEMARKEDNONE:
    return "Please mark some messages first.";
  case M_CHANGESORTORDER:
    return "Change sort order";
  case M_MOVETOTRASH:
    return "Move marked to trash";
  case M_DELETEALLTRASH:
    return "Delete ALL trash";
  case M_NOMAILS:
    return "[No mail]";
  case M_MARKALL:
    return "Mark all";
  case M_HISTFLAG:
    return "History";
  case M_HISTSEARCH:
    return "Search in history";
  case M_THREADSHOW:
    return "Thread";

  case M_MBOXNAME:
    return "Mailbox (m/r/u/s)";
  case M_DELETEMARKEDMBOX:
    return "Delete marked";
  case M_CREATEMBOX:
    return "Create a new mailbox";
  case M_NEWMBOXNAME:
    return "(Name)";
  case M_MBOXREMOVEP:
    return "Are you sure you want to delete the following mailboxes?";
  case M_MBOXMARKONE:
    return "Mark at least one mailbox.";
  case M_NEWMBOXNONAME:
    return "Type in a name first.";
  case M_CREATEMBOXERROR:
    return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
  case M_NOMBOXERROR:
    return "You must select a mailbox to rename and supply a new name.";
  case M_INBOX:
    return "Inbox";
  case M_PREVIOUS_LEVEL:
    return "[Previous level]";
  case M_FOLDER_PATH:
    return "Path:";
  case M_BOXTRASH:
    return "Trash";
  case M_SHARED_BOXTRASH:
    return "Trash";
  case M_BOXSENTMAIL:
    return "Sent";
  case M_SHARED_BOXSENTMAIL:
    return "Sent";
  case M_BOXDRAFTS:
    return "Drafts";
  case M_SHARED_BOXDRAFTS:
    return "Drafts";
  case M_BOXANSWERED:
    return "Answered";
  case M_SHARED_BOXANSWERED:
    return "Answered";
  case M_RENAMEMBOX:
    return "Rename a mailbox";
  case M_RENAMEMBOXERROR:
    return "Failed to rename mailbox. The name may be illegal or the mailbox may exist.";

  case M_FILENAME:
    return "Filename";
  case M_SIZE:
    return "Size";
  case M_MIMETYPE:
    return "Type";
  case M_DELETEMARKEDFILES:
    return "Delete marked";
  case M_UPLOAD:
    return "Upload";
  case M_AVAILSPACE:
    return sprintf("You have %d Kb available for upload.",@arg);
  case M_WINDOWSBUG :
    return "Windows users: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
  case M_NOFILES:
    return "You have no uploaded files.";

  case M_PNAME:
    return "Name";
  case M_PMAILADDRESS:
    return "Mail address";
  case M_PMAILPATH:
    return "Mail searchpath";
  case M_PINCLUDEMAIL:
    return "Include mail when replying";
	case M_PREPLYONTOP:
		return "Reply on top of the message";
  case M_PQUOTEPREFIX :
    return "Prefix";
  case M_PSIGNATURE:
    return "Signature";
  case M_PINACTIVELOGOUT:
    return "Inactive logout (minutes)";
  case M_PSAVEANDUSE:
    return "Save and use";
  case M_PVISIBLEMESSAGES:
    return "Messages shown in mailbox";
  case M_PSORTORDER:
    return "Mail sort order";
  case M_PSORTORDERS:
return ([ "forward": "forward", "backward":"backward"])[arg[0]];
  case M_PTRASHFOLDER:
    return "Trash folder";
  case M_PANSWEREDFOLDER:
    return "Answered mail folder";
  case M_PSENTFOLDER:
    return "Sent mail folder";
  case M_PDRAFTSFOLDER:
    return "Drafts folder";
  case M_PDEFAULTBCC:
    return "Default Bcc address";
  case M_PSAVEATTACHMENTS:
    return "Include attachments";
  case M_PLANGUAGE:
    return "Language";
  case M_PUSERINTERFACE:
    return "User interface";
  case M_PHEADER:
    return "Extra headers";
  case M_PHEADERDESC:
    return "(Lines with headers in this format: header:value )";
  case M_PSORTCOLUMN:
    return "Sort on column";
  case M_PSHOWHTML:
    return "Show HTML messages";
  case M_PSHOWTEXT:
    return "Show text messages";
  case M_PSHOWHIDDENHEADERS:
    return "Enable <i>\"Show full headers\"</i>-button";
  case M_PAUTOFILTER:
    return "With this option a rule is automatically build when you move a mail to a specified mailbox. When the same sender come back,  his mail is moved to the mailbox you already specified";
  case M_PADDRESSBOOK:
    return "Default addressbook (not extended)";
  case M_PPOSTLOGINSCREEN:
    return "Default screen after successful login";
  case M_PENABLEDISABLECACHEFEEDER:
    return "Enable or disable the background IMAP client started after your login. If the background IMAP client is enable, some features like fast search or faster mailboxes browsing are avaible. However the interface will be slower for a few minutes after you logged in.";

  case M_SPELLDONE:
    return "Done";
  case M_SPELLPREV:
    return "Previous";
  case M_SPELLNEXT:
    return "Next";
  case M_SPELLCHANGETO:
    return "Change to";
  case M_SPELLSUGGESTIONS:
    return "Suggestions";
  case M_NOSPELLINGERRORS:
    return "No spelling errors found.";
  case M_MANUALCORRECTION:
    return "Manual correction";

  case M_LOGOUTMSG:
    return "You have been logged out.";
  case M_LOGGEDOUT:
    return "Logged out";

  case M_QUESTION:
    return "Question";
  case M_INFO:
    return "Info";

  case M_REPLY:
    return "Reply";
  case M_REPLYMARKED:
    return "Reply selected mails";
  case M_REPLYMOVEMARKED:
    return "Reply and move selected mails";
  case M_READPREV:
    return "Read previous";
  case M_READNEXT:
    return "Read next";
  case M_ATTACHMENTLINK:
    return sprintf("%sattachment of type %s",@arg);
  case M_MAILMISSING:
    return "<b>Error:</b> Failed to fetch mail. The mail might have a faulty format.<br />";
  case M_MAILMISSINGBACK:
    return "Back";
  case M_DELETE:
    return "Delete";
  case M_FORWARD:
    return "Forward";
  case M_FORWARDMOVE:
    return "Forward and move";
  case M_CONTINUECOMPOSE:
    return "Continue";
  case M_CONTINUECOMPOSEMOVE:
    return "Continue and move";
  case M_BACKTOMAILINDEX:
    return "Back to mail list";
  case M_NOTIFYTO:
    return sprintf ("%s requested a receipt to be returned. Do you wish to send one ?", @arg);
  case M_MAIL:
    return "Mail";
  case M_SHOWFULLHEADERS:
    return "Show full headers";
  case M_HIDEFULLHEADERS:
    return "Hide full headers";
  case M_MAILTOOBIG:
    return "Mail is too big to be shown. Click here to download it.";
  case M_REPLYTOALL:
    return "Reply to all";
  case M_REPLYMOVE:
    return "Reply and move";
  case M_REPLYTOALLMOVE:
    return "Reply to all and move";
  case M_MOVETHISTOTRASH:
    return "Move to trash";
  case M_CHARSETWARNING:
    return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);

  case M_ADDRESSBOOKTITLE:
    return("Address Book");
  case M_ADDRESSBOOK:
    return("Address book");
  case M_INDEXNAMERECIPIENT:
    return("Index name (click to add as recipient)");
  case M_INDEXNAMEEDIT:
    return("Index name (click to edit)");
  case M_ADDRESS:
    return("Address");
  case M_NOADDRESSES:
    return("No addresses");
  case M_NEWADDRESS:
    return("New address");
  case M_EDITADDRESS:
    return("Edit address");
  case M_ADDADDRESS:
    return("Add to address book");
  case M_INDEXNAME:
    return("Index name");
  case M_ADDRESSFORMAT:
    return("Address(es), comma separated");
  case M_SAVEADDRESS:
    return("Save and use");
  case M_DELETEADDRESS:
    return("Delete address");
  case M_DELETEALLADDRESS:
    return("Delete all addressbook");
  case M_CANCELADDRESS:
    return("Cancel");
  case M_CANNOTIMPORT:
    return("Cannot import this addressbook, since its\nformat is not recognized.");
  case M_MUSTSELECTFIELD:
    return("You must specify at least the field(s)");
  case M_IMPORTADDRESSBOOKTITLE:
    return("Import address book");
  case M_UPLOADADDRESSBOOK:
    return("Upload a Pine, an exported Netscape (.ldif) or Outlook (.csv) address book");
  case M_PINELOCATION:
    return("The Pine address book is often in ~/.addressbook");
  case M_UPLOADANDIMPORT:
    return("Upload and import");
  case M_IMPORTADDRESSBOOK:
    return("Import address book");
  case M_GLOBALADDRESSES:
    return("Common addresses:");
  case M_SELECT:
    return("Select");
  case M_EMAILADDRESS:
    return("Email address");
  case M_SURNAME:
    return("Surname");
  case M_NICKNAME:
    return("Nickname");
  case M_HOMEPHONE:
    return("Home phone");
  case M_WORKPHONE:
    return("Work phone");
  case M_WORKSTATE:
    return("Work state");
  case M_TITLE:
    return("Title");
  case M_COMPANY:
    return("Company");
  case M_DEPARTMENT:
    return("Department");
  case M_HOMEPOSTALADDRESS:
    return ("Home postal address");
  case M_WORKPOSTALADDRESS:
    return("Work postal address");
  case M_WORKCITY:
    return("Work city");
  case M_WORKCOUNTRY:
    return("Work country");
  case M_PAGER:
    return("Pager");
  case M_MOBILE:
    return("Mobile");
  case M_URI:
    return("URI");
  case M_DESCRIPTION:
    return("Description");
  case M_POSTALCODE:
    return("Postal code");
  case M_DESTINATIONIMPORT:
    return("Destination to import to");
  case M_SELECTMATCHINGFIELDS:
    return("Select matching fields");
  case M_IMPORTEDFIELDS:
    return("Imported fields");
  case M_AVAILABLEFIELDS:
    return ("Available fields");
  case M_ADDRESSBOOKWRITEPROBLEM:
    return("Problem while writing to address book");

  case M_LDAPTITLE:
    return("LDAP addresses");
  case M_LDAP:
    return("LDAP search");
  case M_SEARCHLDAP:
    return("Search LDAP");
  case M_NAMECONT:
    return("Search name containing:");
  case M_OU:
    return("OU");

  case M_MAILNOTIFYWINDOW:
    return("Mail notification");
  case M_GETNEWMAIL:
    return("Get new mail");

  case M_SEARCHMAILTITLE:
    return("Search mail");
  case M_SEARCHMAIL:
    return("Search");
  case M_SEARCHANYWHERE:
    return("anywhere");
  case M_SEARCHFROMFIELD:
    return("in 'from' field");
  case M_SEARCHTOFIELD:
    return("in 'to' field");
  case M_SEARCHSUBJECT:
    return("in subject");
  case M_SEARCHHEADERS:
    return("in all headers"); 
  case M_SEARCHBODY:
    return("in mail body");
  case M_SEARCHAND:
    return("AND");
  case M_SEARCHSHOWINGMAIL:
    return("Showing mail with ");
  case M_NOSEARCHRESULTS:
    return("No answers matching you query");
  case M_NOSEARCHREMEMBER:
    return "Don't remember the previous search";
  case M_SEARCHALLMBOX:
    return "Search in all mailboxes";
  case M_SHOWALLAFTERSEARCH:
    return "Show all";
  case M_STICKYFILTER:
    return "Sticky Filter";
  case M_SEARCHCACHENOTFEEDED:
    return "You can't search multiple mailboxes for now, please wait a few "
    "moments if you want this feature";
  case M_YES:
    return "Yes";
  case M_NO:
    return "No";
  case M_DIALOGOK:
    return "OK";
  case M_DIALOGCANCEL:
    return "Cancel";

  case M_PADDRESSBOOKFILTER:
    return "Default filterbook (not extended)";
  case M_FILTERBOOKTITLE:
    return("Mail Filter");
  case M_EMPTYADDRESSFILTER:
    return "You must specify non-empty index folder and filter(s).";
  case M_NOADDRESSESFILTER:
    return("No filter");
  case M_INDEXNAMEEDITFILTER:
    return("Index filter (click to edit)");
  case M_ADDRESSFILTER:
    return("Folder");
  case M_INDEXNAMERECIPIENTFILTER:
    return("Index name (click to add as recipient)");
  case M_INDEXNAMEFIELDFILTER:
    return("Index field (click to select a field)");
  case M_INDEXNAMEEDITFIELDFILTER:
    return("Index field");
  case M_NEWADDRESSFILTER:
    return("New filter");
  case M_SAVEADDRESSFILTER:
    return("Save and use");
  case M_DELETEADDRESSFILTER:
    return("Delete filter");
  case M_CANCELADDRESSFILTER:
    return("Cancel");
  case M_ADDADDRESSFILTER:
    return("Add to filter book");
  case M_INDEXNAMEFILTER:
    return("Index filter");
  case M_INDEXFIELDFILTER:
    return("Index field");
  case M_FILTERFOLDER:
    return("Index folder");
  case M_EDITADDRESSFILTER:
    return("Edit filter");
  case M_SELECTFIELD:
    return "(Select a field)";

  case M_ADDRECIPIENTS:
    return "Add recipients";
  case M_PORGANIZATION:
    return "Organization";

  case M_TOTALSIZE:
    return "Total size";
  case M_OF:
    return "of";
  case M_USED:
    return "used";
  case M_FOLDER:
    return "Folder";
  case M_MESSAGES:
    return "Messages";
  case M_UNSEEN:
    return "Unseen";
  case M_NEW:
    return "New";
  case M_QUOTA:
    return "Quota";

  case M_MDNMESSAGE:
    return sprintf("This is a Return Receipt for the mail that you sent to %s. "
                   "Note: this Return Receipt only acknowledges that the message was "
                   "displayed on the recipient's machine. There is no guarantee that the "
                   "content has been read or understood.", @arg);

  case M_MDNHEADER:
    return "Return Receipt (displayed) - ";

  case M_TODAY:
    return "Today";
  case M_MONDAY:
    return "Monday";
  case M_TUESDAY:
    return "Tuesday";
  case M_WEDNESDAY:
    return "Wednesday";
  case M_THURSDAY:
    return "Thursday";
  case M_FRIDAY:
    return "Friday";
  case M_SATURDAY:
    return "Saturday";
  case M_SUNDAY:
    return "Sunday";

  case M_ENDSESSION:
    return "End the CAMAS session ?";

  case M_FWD_SEP:
    return "------ Forwarded message ------";
  case M_FWD_CC:
    return "Cc: ";
  case M_FWD_DATE:
    return "Date: ";
  case M_FWD_FROM:
    return "From: ";
  case M_FWD_REPLYTO:
    return "Reply-To: ";
  case M_FWD_SUBJECT:
    return "Fwd: ";
  case M_FWD_TO:
    return "To: ";
  case M_FWD_REP_SEP:
    return "-------------";
  }
  return " ** MISSING MESSAGE ** ";
}

string msg (object sessobj, int m, array arg)
{
  string s;
  if (sessobj) {
    object lang_prog = lang_progs[sessobj->language];
    if (lang_prog) {
      s = lang_prog->msg (sessobj, m, arg);
      if (s && lang_charsets[sessobj->language])
        s = Locale.Charset.decoder (lang_charsets[sessobj->language])->feed (s)->drain ();
      if (s)
      {
#if constant(String.Elite) 
        if(QUERY(leetp))
          s = String.Elite.elite_string(s, QUERY(leetp));
#endif
        return s;
      }
    }
  }
  s = default_msg(m, arg);
#if constant(String.Elite)  
  if(QUERY(leetp)) 
    s = String.Elite.elite_string(s, QUERY(leetp));
#endif 
  return s;
}

#endif // __DEFAULTLANGUAGE_H

/*                                                                             
 * If you visit a file that doesn't contain these lines at its end, please     
 * cut and paste everything from here to that file.                            
 */                                                                            
                                                                               
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
