// Dear Emacs, please note this is a -*-text-*- file. Thank you.
//
// Caudium - An extensible World Wide Web server
// Copyright  2000-2004 The Caudium Group
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: language.fr,v 1.56.2.1 2004/01/21 11:57:29 vida Exp $
//

//
// The language template file format
// ---------------------------------
//
// Message definitions are formatted as follows:
//
// #define<TAB>NAME[<TAB>ID]<TAB>MESSAGE
//
// There MUST be only ONE tab character between the definition fields.
// Never enclose the message in double quotes! Below are few escape sequences
// you can use in the message text:
//
// \s - space (needed at the start and the end of message since the parser strips
//             both leading and trailing whitespace)
// \t - TAB (as above)
// \# - # sign (only needed at the start of message if you need it to start with #).
//      # used at the start of message makes this message a function invocation, and
//      not a string. It means that it won't be enclosed in the quotation marks in the
//      output.
//
// Comments starting with //! are "attached" to the message definition that follows them
// and output in the target file as an attachment of that same kind.
//
// The target file contains also another kind of entry market with the //#DIRECTIVE 
// comment. The following directives are defined:
//
//  ORIG - the line contains the original version of the string for change testing when
//         the translation and the template are combined.
//  FLAG - followed by several flags marks the state of this entry:
//           <changed>  - the entry has been changed in the original (default) file
//                        and the translation needs to be updated.
//           <new>      - new entry merged from the default file
//
//  Neither the attachment comment nor the directive comment should be edited by hand!!
//


// For the translation system internal usage. Not used by CAMAS.

//! Maintainer of this particular file
//#ORIG Xavier Beaudouin <kiwi@isdnet.net>
#define	TS_MAINTAINER	11111	David Gourdelier <vida@caudium.net>

//! This file version
//#ORIG 1.0.0-dev
#define	TS_VERSION	11112	1.1.7-DEV

//! Output in camas_XX.pike as default message (translate it to your language)
//#ORIG \s** MISSING MESSAGE **\s
#define	TS_NOMSGFOUND	11113	\s** MESSAGE MANQUANT **\s

//! Native language name
//#ORIG English
#define	TS_LANGNAME	11114	Franais

//! Language charset
//#ORIG iso-8859-1
#define	TS_CHARSET	11115	iso-8859-1

//! Character encodable in the above charset
//#ORIG ?
#define	TS_ENCCHAR	11116	?

//! CVS version of the file (leave set to $Id: language.fr,v 1.56.2.1 2004/01/21 11:57:29 vida Exp $ if you don't use CVS)
//#ORIG $Id: language.fr,v 1.56.2.1 2004/01/21 11:57:29 vida Exp $
#define	TS_CVSVER	11117	$Id: language.fr,v 1.56.2.1 2004/01/21 11:57:29 vida Exp $

//! The copyright string put in the target .pike file
//#ORIG 2000 The Caudium Group
#define	TS_COPYRIGHT	11118	2000 The Caudium Group


// CAMAS Messages

//#ORIG Reply on top of the message
#define	M_PREPLYONTOP	Rpondre au-dessus du message

//#ORIG Add marked to attachments
#define	M_ADDMARKEDTOATTACHMENTS	Joindre fichier(s) slectionn(s)

//#ORIG (Name)
#define	M_NEWMBOXNAME	\#""

//#ORIG Default addressbook (not extended)
#define	M_PADDRESSBOOK	Carnet d'adresses

//#ORIG AND
#define	M_SEARCHAND	ET

//#ORIG Organization
#define	M_PORGANIZATION	Socit

//#ORIG Mail address
#define	M_PMAILADDRESS	Adresse lectronique

//#ORIG OK
#define	M_LOGIN_OK	OK

//#ORIG Attachments
#define	M_ATTACHMENTSHEADER	Joindre fichier(s)

//#ORIG <strong>Error:</strong> Failed to fetch mail. The mail might have a faulty format.<br />
#define	M_MAILMISSING	<strong>Erreur:</strong> Impossible de rcuprer le courrier. Essayez encore. <br />

//#ORIG Name
#define	M_PNAME	Nom

//#ORIG Home phone
#define	M_HOMEPHONE	Tlphone personnel

//#ORIG \#sprintf("[<< Prev %d]", @arg)
#define	M_BACKN	Prcdent

//#ORIG From
#define	M_FROM	Expditeur

//#ORIG Create a new mailbox
#define	M_CREATEMBOX	Crer un nouveau dossier

//#ORIG Address book
#define	M_ADDRESSBOOK	Carnet d'adresses

//#ORIG Include mail when replying
#define	M_PINCLUDEMAIL	Inclure le message d'origine en rpondant  l'expditeur

//#ORIG Postal code
#define	M_POSTALCODE	Code postal

//#ORIG You can't search multiple mailboxes for now, please wait a few moments if you want this feature
#define	M_SEARCHCACHENOTFEEDED	La recherche multi-boites n'est pas implmente actuellement.

//#ORIG used
#define	M_USED	utilis

//#ORIG Index filter
#define	M_INDEXNAMEFILTER	Valeur du filtre

//#ORIG End this CAMAS session ?
#define	M_ENDSESSION	Terminer cette session CAMAS ?

//#ORIG Work postal address
#define	M_WORKPOSTALADDRESS	Adresse postale professionnelle

//#ORIG Sunday
#define	M_SUNDAY	Dimanche

//#ORIG Sort on column
#define	M_PSORTCOLUMN	Trier sur la colonne

//#ORIG Move marked to
#define	M_MOVEMARKED	Dplacer les lments slectionns vers

//#ORIG No filter
#define	M_NOADDRESSESFILTER	Pas de filtres

//#ORIG Read next
#define	M_READNEXT	Lire suivant

//#ORIG Windows users: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.
#define	M_WINDOWSBUG	Utilisateurs de Windows: Vous pouvez rencontrer des problmes selon le navigateur utilis, les noms de fichiers peuvent tre altrs. Afin d'y remdier, remplacer le dernier \ par \\ avant d'ajouter le fichier joint au message.

//#ORIG Select files to send. Press 'Ctrl' to toggle-select multiple files.
#define	M_SENDMOREFILES	Choisir fichier  envoyer. Appuyer sur 'Ctrl' pour choix multiple.

//#ORIG Available fields
#define	M_AVAILABLEFIELDS	Champs disponibles

//#ORIG Change to
#define	M_SPELLCHANGETO	Remplacer par

//#ORIG Send marked drafts
#define	M_SENDMARKEDDRAFTS	Envoyer les drafts marqus

//#ORIG Continue
#define	M_CONTINUECOMPOSE	Continuer

//#ORIG Mailbox (m/r/u/s)
#define	M_MBOXNAME	Dossiers (m/r/u/s)

//#ORIG Check inboxes
#define	M_CHECKACTIVEMAILBOXES	Vrifier les botes

//#ORIG in the mail body
#define	M_SEARCHBODY	dans le corps du message

//#ORIG Add recipients
#define	M_ADDRECIPIENTS	Ajouter les destinataires

//#ORIG User interface:
#define	M_USERINTERFACE	Interface utilisateur :

//#ORIG (Lines with headers in this format: header:value)
#define	M_PHEADERDESC	(Lignes avec champs dans le format: champ:valeur)

//#ORIG Total size
#define	M_TOTALSIZE	Taille totale

//#ORIG (Select a field)
#define	M_SELECTFIELD	(Slectionnez un champ)

//#ORIG \#sprintf("You have %d Kb available for upload.",@arg)
#define	M_AVAILSPACE	\#sprintf("Vous avez %d Kb de disponible pour charger des fichiers.",@arg)

//#ORIG Change sort order
#define	M_CHANGESORTORDER	Changer l'ordre de tri

//#ORIG Cancel
#define	M_CANCELSEND	Annuler

//#ORIG Answered
#define	M_SHARED_BOXANSWERED	Rpondus

//#ORIG Nickname
#define	M_NICKNAME	Surnom

//#ORIG Description
#define	M_DESCRIPTION	Description

//#ORIG Reply selected mails
#define	M_REPLYMARKED	Rpondre aux messages slectionns

//#ORIG of
#define	M_OF	de

//#ORIG No answers matching you query
#define	M_NOSEARCHRESULTS	Aucune rponse ne correspond  votre requte

//#ORIG Search in all mailboxes
#define	M_SEARCHALLMBOX	Chercher dans toutes les botes

//#ORIG Thread
#define	M_THREADSHOW	Fil

//#ORIG Index field
#define	M_INDEXNAMEEDITFIELDFILTER	Champ

//#ORIG Saturday
#define	M_SATURDAY	Samedi

//#ORIG Delete marked
#define	M_DELETEMARKED	Supprimer les lments slectionns

//#ORIG Mail was sent successfully, but save in folder failed.
#define	M_SENDSAVEFAILED	Message envoy, mais la sauvegarde dans le dossier a chou.

//#ORIG IMAP server
#define	M_IMAPSERVER	Serveur IMAP

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOK	Importer carnet d'adresse depuis un fichier

//#ORIG Read previous
#define	M_READPREV	Lire prcedent

//#ORIG Next
#define	M_SPELLNEXT	Mot Suivant

//#ORIG Reply to all and move
#define	M_REPLYTOALLMOVE	Rpondre  tous et dplacer

//#ORIG A
#define	M_ANSWEREDFLAG	R

//#ORIG Index field
#define	M_INDEXFIELDFILTER	Champ  filtrer

//#ORIG Search in history
#define	M_HISTSEARCH	Historique

//#ORIG Attachment list too big
#define	M_ATTACHTOOBIG	Liste des pices jointes trop longue

//#ORIG Drafts
#define	M_BOXDRAFTS	Brouillons

//#ORIG \#sprintf(There was a problem talking to the outgoing mail (SMTP) server, and the mail was not sent to %s. The recipient of the mail might not exist.", @arg)
#define	M_SMTPERROR	\#sprintf("Il y a eu un problme avec le serveur de mail sortant (SMTP), et le message n'a pas t envoy  %s. Peut-tre que le destinataire n'existe pas.", @arg)

//#ORIG Extra headers
#define	M_PHEADER	Champs supplmentaires

//#ORIG Compose mail
#define	M_COMPOSEMAIL	Rdaction de message

//#ORIG Upload
#define	M_UPLOAD	Charger fichier

//#ORIG Thursday
#define	M_THURSDAY	Jeudi

//#ORIG Imported fields
#define	M_IMPORTEDFIELDS	Champs  importer

//#ORIG Surname
#define	M_SURNAME	Nom de famille

//#ORIG Save draft
#define	M_SAVEDRAFT	Enregistrer un brouillon.

//#ORIG \#sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg)
#define	M_CHARSETWARNING	\#sprintf("Attention! Impossible de dcoder le message encod en \"%s\". Le message sera prsent non dcod.",@arg)

//#ORIG Previous
#define	M_SPELLPREV	Mot Prcdent

//#ORIG Archive
#define	M_ARCHIVE	Archiver

//#ORIG URI
#define	M_URI	URI

//#ORIG Answered mail folder
#define	M_PANSWEREDFOLDER	Dossiers des messages rpondus

//#ORIG in subject
#define	M_SEARCHSUBJECT	dans l'objet

//#ORIG Edit the filter
#define	M_EDITFILTER	Editer le filtre

//#ORIG Friday
#define	M_FRIDAY	Vendredi

//#ORIG You must select a mailbox to rename and supply a new name.
#define	M_NOMBOXERROR	Vous devez slectionner un dossier  renommer et fournir le nouveau nom.

//#ORIG There was a problem talking to the mail (IMAP) server.<br>Please contact the administrator.
#define	M_IMAPERROR	Problme avec le serveur IMAP.\nContactez l'administrateur systme.

//#ORIG Send blind copy to administrator
#define	M_CHECKBCC	Envoyer une copie cache  l'administrateur

//#ORIG Index folder
#define	M_FILTERFOLDER	Dossier destination

//#ORIG Reply
#define	M_REPLY	Rpondre

//#ORIG Enable <em>\"Show full headers\"</em>-button
#define	M_PSHOWHIDDENHEADERS	Afficher le bouton Montrer l'en-tte lors de la lecture d'un message

//#ORIG Sent
#define	M_SHARED_BOXSENTMAIL	Envoy

//#ORIG N
#define	M_NEWFLAG	N

//#ORIG Remove marked attachments
#define	M_REMOVEMARKEDATTACHMENTS	Annuler fichier(s) joint(s) slectionn(s)

//#ORIG Delete all addressbook
#define	M_DELETEALLADDRESS	Supprimer tout le Carnet d'adresses

//#ORIG in all headers
#define	M_SEARCHHEADERS	dans tous les en-ttes

//#ORIG History
#define	M_HISTFLAG	Historique

//#ORIG Index field (click to select a field)
#define	M_INDEXNAMEFIELDFILTER	Champs

//#ORIG Wrong login or password. Try again.
#define	M_LOGINERROR	Mauvais mot de passe ou login incorrect. Recommencez.

//#ORIG Recipients don't see each other
#define	M_SENDBLIND	Les destinataires ne se voient pas

//#ORIG Rename a mailbox
#define	M_RENAMEMBOX	Renommer une bote

//#ORIG Enable or disable the background IMAP client started after your login. If the background IMAP client is enable, some features like fast search or faster mailboxes browsing are avaible. However the interface will be slower for a few minutes after you logged in.
#define	M_PENABLEDISABLECACHEFEEDER	Active ou Dsactive le client IMAP en tche de fond aprs votre connection. Si le client IMAP en tche de fond est activ, des fonctionnalits comme la recherche rapide ou la navigation rapide entre les botes sont disponibles. Cependant l'interface sera plus lente quelques minutes aprs que vous vous soyez connect

//#ORIG Type
#define	M_MIMETYPE	Type

//#ORIG Upload a Pine, an exported Netscape (.ldif) or Outlook (.csv) address book
#define	M_UPLOADADDRESSBOOK	Importer un fichier Pine, Netscape (.ldif) ou Outlook (.csv)

//#ORIG Send
#define	M_SEND	Envoyer

//#ORIG Wednesday
#define	M_WEDNESDAY	Mercredi

//#ORIG Email address
#define	M_EMAILADDRESS	Adresse email

//#ORIG Save a copy
#define	M_SAVEMAILCOPY	Garder une copie

//#ORIG Done
#define	M_SPELLDONE	Correction termine

//#ORIG Mobile
#define	M_MOBILE	Mobile

//#ORIG in the 'to' field
#define	M_SEARCHTOFIELD	dans le champ 'Destinataire'

//#ORIG Cancel
#define	M_CANCELADDRESSFILTER	Annuler

//#ORIG \#sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0])
#define	M_SENDBROKENADDR	\#sprintf("L'adresse \"%s\" n'est pas une adresse email correcte. Veuillez la corriger et ressayer.", arg[0])

//#ORIG Language
#define	M_PLANGUAGE	Langue

//#ORIG Report delivery
#define	M_MDN	Accus de rception utilisateur.

//#ORIG \#sprintf ("<b>Could not log in:</b> %s", @arg)
#define	M_NOLOGIN	\#sprintf ("<b>Accs impossible :</b> %s", @arg)

//#ORIG Common addresses:
#define	M_GLOBALADDRESSES	Carnet d'adresse commun:

//#ORIG Current Mailbox
#define	M_CURRMAILBOX	Bote en cours

//#ORIG Info
#define	M_INFO	Information

//#ORIG Move to trash
#define	M_MOVETHISTOTRASH	Supprimer ce message

//#ORIG Folder
#define	M_ADDRESSFILTER	Dossier

//#ORIG -------------
#define	M_FWD_REP_SEP	-------------

//#ORIG M
#define	M_MARKFLAG	S

//#ORIG Manual correction
#define	M_MANUALCORRECTION	Correction manuelle

//#ORIG Delay
#define	M_DELAY	Dlais

//#ORIG Default Bcc address
#define	M_PDEFAULTBCC	Destinataire de copie cache par dfaut

//#ORIG Answered
#define	M_BOXANSWERED	Messages rpondus

//#ORIG Password:
#define	M_PASSWORD	Mot de passe :

//#ORIG Size
#define	M_SIZE	Taille

//#ORIG Tuesday
#define	M_TUESDAY	Mardi

//#ORIG Trash
#define	M_SHARED_BOXTRASH	Corbeille

//#ORIG Select
#define	M_SELECT	Slectionnez une bote

//#ORIG Report successful delivery.
#define	M_DSN_SUCCESS	Accus de rception du serveur de mail.

//#ORIG \#sprintf ("%s requested a receipt to be returned. Do you wish to send one ?", @arg)
#define	M_NOTIFYTO	\#sprintf ("%s a demand un accus de rception. Voulez-vous en envoyer un ?", @arg);

//#ORIG Filters
#define	M_FILTERBOOK	Filtres

//#ORIG Pager
#define	M_PAGER	Pager

//#ORIG Search
#define	M_SEARCHMAIL	Rechercher

//#ORIG in the 'from' field
#define	M_SEARCHFROMFIELD	dans l'expditeur

//#ORIG Sent mail folder
#define	M_PSENTFOLDER	Dossier des messages envoys

//#ORIG Back to mail index
#define	M_BACKTOMAILINDEX	Retour aux mails

//#ORIG Question
#define	M_QUESTION	Question

//#ORIG Logout
#define	M_LOGOUT	Se dconnecter

//#ORIG The Pine address book is often in ~/.addressbook
#define	M_PINELOCATION	Le fichier de carnet d'adresses Pine est souvent ~/.addressbook

//#ORIG Search and replace
#define	M_SEARCHREPLACE	Rechercher et remplacer

//#ORIG To:
#define	M_FWD_TO	:

//#ORIG Received
#define	M_RECEIVED	Reu

//#ORIG Show full headers
#define	M_SHOWFULLHEADERS	Montrer l'en-tte

//#ORIG Address(es), comma separated
#define	M_ADDRESSFORMAT	Adresse(s) lectronique(s), virgule pour sparer

//#ORIG Delete filter
#define	M_DELETEADDRESSFILTER	Supprimer

//#ORIG Mark all
#define	M_MARKALL	Slectionner tous les messages

//! Label on the login screen
//#ORIG Login:
#define	M_LOGIN	Utilisateur :

//#ORIG Sent
#define	M_BOXSENTMAIL	Messages envoys

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENTFILTER	Nom (cliquez pour ajouter aux destinataires)

//#ORIG Filename
#define	M_FILENAME	Nom du fichier

//#ORIG Monday
#define	M_MONDAY	Lundi

//#ORIG No spelling errors found.
#define	M_NOSPELLINGERRORS	Aucune erreurs trouves.

//#ORIG Cannot import this addressbook, since its\nformat is not recognized.
#define	M_CANNOTIMPORT	Impossible d'importer ce fichier, format non reconnu.

//#ORIG Report delayed delivery.
#define	M_DSN_DELAY	Rapport d'envoi de mail diffr.

//#ORIG Select matching fields
#define	M_SELECTMATCHINGFIELDS	Slectionnez les champs correspondants

//#ORIG Delete marked
#define	M_DELETEMARKEDMBOX	Effacer lment(s) slectionn(s)

//#ORIG Work country
#define	M_WORKCOUNTRY	Pays de travail

//#ORIG Get new mail
#define	M_GETNEWMAIL	Retirer courier

//#ORIG Index name
#define	M_INDEXNAME	Nom

//#ORIG From preferences
#define	M_SAVEDUSERINTERFACE	Depuis les prfrences

//#ORIG Please mark some messages first.
#define	M_DELETEMARKEDNONE	Selectionnez d'abord un message.

//#ORIG Trash folder
#define	M_PTRASHFOLDER	Corbeille

//#ORIG User interface
#define	M_PUSERINTERFACE	Interface utilisateur

//#ORIG Preferences
#define	M_PREFS	Prfrences

//#ORIG Logged out
#define	M_LOGGEDOUT	Se dconnecter

//#ORIG Cancel
#define	M_CANCELADDRESS	Annuler

//#ORIG You must specify a recipient of the mail.
#define	M_SENDNORECV	Vous devez spcifier le destinataire du message !

//#ORIG Fwd:
#define	M_FWD_SUBJECT	Rexp:

//#ORIG Add file as an attachment
#define	M_ADDFILEASATTACHMENT	Joindre un fichier

//#ORIG Date
#define	M_DATE	Date

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENT	Nom

//#ORIG [No mail]
#define	M_NOMAILS	Pas de nouveau(x) message(s)

//#ORIG Edit filter
#define	M_EDITADDRESSFILTER	Edition filtres

//#ORIG Default screen after successful login
#define	M_PPOSTLOGINSCREEN	Ecran par dfaut aprs la connection

//#ORIG \#([ "forward": "forward", "backward":"backward"])[arg[0]]
#define	M_PSORTORDERS	\#([ "forward": "croissant", "backward":"dcroissant"])[arg[0]]

//#ORIG Trash
#define	M_BOXTRASH	Corbeille

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOKTITLE	Importer carnet d'adresse depuis un fichier

//#ORIG Quota
#define	M_QUOTA	Quota

//#ORIG Don't remember the previous search
#define	M_NOSEARCHREMEMBER	Ne pas se souvenir de la recherche prcdente

//#ORIG Today
#define	M_TODAY	Aujourd'hui

//#ORIG Work city
#define	M_WORKCITY	Ville de travail

//#ORIG Back
#define	M_MAILMISSINGBACK	Retour

//#ORIG Save and use
#define	M_SAVEADDRESS	Enregistrer

//#ORIG Save and use
#define	M_SAVEADDRESSFILTER	Enregistrer

//#ORIG Move marked to trash
#define	M_MOVETOTRASH	Supprimer

//#ORIG Search LDAP
#define	M_SEARCHLDAP	Lancer la recherche

//#ORIG Index filter (click to edit)
#define	M_INDEXNAMEEDITFILTER	Expression

//#ORIG Files
#define	M_FILES	Fichiers

//#ORIG Return Receipt (displayed) -\s
#define	M_MDNHEADER	Accus de Rception (affich) -\s

//#ORIG Delete address
#define	M_DELETEADDRESS	Supprimer le contact

//#ORIG Reply to all
#define	M_REPLYTOALL	Rpondre  tous

//#ORIG Reply-To:
#define	M_FWD_REPLYTO	Rponse-:

//#ORIG Attachments
#define	M_ATTACHMENTS	Fichiers joints

//#ORIG Messages shown in a mailbox
#define	M_PVISIBLEMESSAGES	Nombre de messages  afficher dans la bote de rception

//#ORIG Add to address book
#define	M_ADDADDRESS	Ajouter au carnet d'adresses

//#ORIG Company
#define	M_COMPANY	Entreprise

//#ORIG \#sprintf("Are you sure you want to delete the %d marked message(s)?", @arg)
#define	M_DELETEMARKEDP	\#sprintf("Etes vous sr de vouloir effacer le(s) %d message(s) selectionn(s) ?",@arg)

//#ORIG Suggestions
#define	M_SPELLSUGGESTIONS	Suggestions

//#ORIG Path
#define	M_FOLDER_PATH	Chemin :

//#ORIG Mail sort order
#define	M_PSORTORDER	Ordre de tri des messages

//#ORIG Reload this page to login.
#define	M_LOGOUTRELOAD	Rechargez cette page pour vous reconnecter

//#ORIG New
#define	M_NEW	Nouveaux

//#ORIG \#sprintf("This is a Return Receipt for the mail that you sent to %s.Note: this Return Receipt only acknowledges that the message was displayed on the recipient's machine. There is no guarantee that the content has been read or understood.", @arg)
#define	M_MDNMESSAGE	\#sprintf("Ceci est un accus de rception pour le message que vous avez envoy  %s. Note: cet accus de rception atteste que le message a t affich sur la machine du destinataire. Il n'y a pas de garantie que le contenu du message ait t lu ou compris.", @arg)

//#ORIG No files
#define	M_NOATTACHFILES	Pas de fichier joint

//#ORIG Subject
#define	M_SUBJECT	Objet

//#ORIG Department
#define	M_DEPARTMENT	Service

//#ORIG Empty the trash folder
#define	M_DELETEALLTRASH	Effacer toute la corbeille

//#ORIG Search name containing:
#define	M_NAMECONT	Rechercher le nom comportant :

//#ORIG anywhere
#define	M_SEARCHANYWHERE	n'importe o

//#ORIG Drafts
#define	M_SHARED_BOXDRAFTS	Drafts

//#ORIG New filter
#define	M_NEWADDRESSFILTER	Nouveau filtre

//#ORIG Upload to attachments
#define	M_UPLOADTOATTACHMENTS	Ajouter fichier slectionn au message

//#ORIG LDAP search
#define	M_LDAP	Annuaire

//#ORIG New address
#define	M_NEWADDRESS	Nouveau contact

//#ORIG Mailboxes
#define	M_MAILBOXES	Dossier(s)

//#ORIG Close this browser window to make sure no one can read your mail.
#define	M_LOGOUTCLOSE	Fermez votre navigateur pour vous assurer que personne d'autre ne lise vos messages.

//#ORIG Cancel
#define	M_DIALOGCANCEL	Annuler

//#ORIG Mail is too big to be shown. Click here to download it.
#define	M_MAILTOOBIG	Message trop grand pour tre affich. Cliquez ici pour le sauvegarder

//#ORIG From:
#define	M_FWD_FROM	De:

//#ORIG \#sprintf("%sattachment of type %s",@arg)
#define	M_ATTACHMENTLINK	\#sprintf("%sfichier joint de type %s",@arg)

//#ORIG Home postal address
#define	M_HOMEPOSTALADDRESS	Adresse postale personnelle

//#ORIG Edit address
#define	M_EDITADDRESS	Modifier le contact

//#ORIG Add attachment
#define	M_ADDATTACHMENT	Joindre un fichier

//#ORIG #
#define	M_NUMBER	#

//#ORIG Title
#define	M_TITLE	Fonction

//#ORIG Save and use
#define	M_PSAVEANDUSE	Enregistrer les modifications

//#ORIG Inbox
#define	M_INBOX	Messages reus

//#ORIG Mail Filter
#define	M_FILTERBOOKTITLE	Filtres

//#ORIG Unseen
#define	M_UNSEEN	Non vus

//#ORIG You have been logged out.
#define	M_LOGOUTMSG	Vous tes  prsent dconnect, merci d'avoir utilis la messagerie.

//#ORIG Default filterbook (not extended)
#define	M_PADDRESSBOOKFILTER	Filtres par dfaut

//#ORIG OK
#define	M_DIALOGOK	OK

//#ORIG Mail
#define	M_MAIL	Mail

//#ORIG Hide full headers
#define	M_HIDEFULLHEADERS	Masquer l'en-tte

//#ORIG Destination to import to
#define	M_DESTINATIONIMPORT	Importer vers

//#ORIG Back to compose
#define	M_BACKTOCOMPOSE	Retour aux messages

//#ORIG Bcc
#define	M_BCC	Copie cache 

//#ORIG Send market drafts and move
#define	M_SENDMARKEDDRAFTSMOVE	Envoi les bauches slectionnes et dplace

//#ORIG Continue and move
#define	M_CONTINUECOMPOSEMOVE	Continuer et ranger

//#ORIG Problem while writing to address book
#define	M_ADDRESSBOOKWRITEPROBLEM	Problme lors de l'criture dans le carnet d'adresses

//#ORIG LDAP addresses
#define	M_LDAPTITLE	Adresses LDAP

//#ORIG Type in a name first.
#define	M_NEWMBOXNONAME	Veuillez d'abord entrer un nom.

//#ORIG Address
#define	M_ADDRESS	Adresse lectronique

//#ORIG [Previous level]
#define	M_PREVIOUS_LEVEL	[Dossier prcedent]

//#ORIG \#sprintf("Mailbox: %s",@arg)
#define	M_MAILBOX	\#sprintf("Dossier : %s",@arg)

//#ORIG Recipients don't see each other button
#define	M_PSENDBLIND	Les destinataires ne se voient pas

//#ORIG Include attachments
#define	M_PSAVEATTACHMENTS	Inclure fichier(s) joint(s)

//#ORIG No
#define	M_NO	Non

//#ORIG Date:
#define	M_FWD_DATE	Date:

//#ORIG Delete marked
#define	M_DELETEMARKEDFILES	Effacer fichier(s) slectionn(s)

//#ORIG Search mail
#define	M_SEARCHMAILTITLE	Chercher

//#ORIG No attachments
#define	M_NOATTACHMENTS	Pas de fichier joint

//#ORIG Failed to rename mailbox. The name may be illegal or the mailbox may exist.
#define	M_RENAMEMBOXERROR	Impossible de renommer le dossier. Le nom est illgal ou le nouveau dossier peut dj exister.

//#ORIG Work state
#define	M_WORKSTATE	Etat de travail

//#ORIG Next
#define	M_EFORWARDN	Suiv

//#ORIG To
#define	M_TO	Destinataire

//#ORIG Mark at least one mailbox.
#define	M_MBOXMARKONE	Slectionnez au moins un dossier.

//#ORIG Signature
#define	M_PSIGNATURE	Signature

//#ORIG Messages
#define	M_MESSAGES	Messages

//#ORIG You must specify at least the field(s)
#define	M_MUSTSELECTFIELD	Vous devez indiquer au moins le(s) champ(s)

//#ORIG Compose
#define	M_NEWMAIL	Ecrire un message

//#ORIG Showing mail with\s
#define	M_SEARCHSHOWINGMAIL	Affichage des messages avec\s

//#ORIG Forward and move
#define	M_FORWARDMOVE	Faire suivre et ranger

//#ORIG Add to filter book
#define	M_ADDADDRESSFILTER	Ajouter aux filtres

//#ORIG Cc
#define	M_CC	Copie 

//#ORIG Port
#define	M_PORT	Port

//#ORIG \#sprintf("Mail %d-%d of %d", @arg)
#define	M_MAILSHOWN	\#sprintf("Message %d-%d sur %d", @arg)

//#ORIG Delete
#define	M_DELETE	Effacer

//#ORIG Upload and import
#define	M_UPLOADANDIMPORT	Valider

//#ORIG Do not save this mail
#define	M_DONTSAVEMAIL	Ne pas sauvegarder ce message.

//#ORIG \#sprintf("[Next %d >>]", @arg)
#define	M_FORWARDN	Suivant

//#ORIG OU
#define	M_OU	Filire

//#ORIG Are you sure you want to delete the following mailboxes?
#define	M_MBOXREMOVEP	Etes vous sr de vouloir effacer le(s) dossier(s) suivant(s) ?

//#ORIG No addresses
#define	M_NOADDRESSES	Pas de carte dfinie

//#ORIG Show all
#define	M_SHOWALLAFTERSEARCH	Afficher tous les messages

//#ORIG Drafts folder
#define	M_PDRAFTSFOLDER	Dossier des brouillons

//#ORIG You must specify non-empty index folder and filter(s).
#define	M_EMPTYADDRESSFILTER	Vous devez slectionner un champ et une bote aux lettres.

//#ORIG Yes
#define	M_YES	Oui

//#ORIG Forward
#define	M_FORWARD	Faire suivre

//#ORIG Mail searchpath
#define	M_PMAILPATH	Chemin de la bote

//#ORIG Cc:
#define	M_FWD_CC	Cc:

//#ORIG Reply and move selected mails
#define	M_REPLYMOVEMARKED	Rpondre et ranger les message slectionns

//#ORIG With this option a rule is automatically build when you move a mail to a specified mailbox. When the same sender come back,  his mail is moved to th mailbox you already specified
#define	M_PAUTOFILTER	Avec cette option une rgle est automatiquement construite quand vous dplacez un mail. Quand vous recevez un mail du mme expditeur, celui-ci est dirig vers la bote que vous avez dj utilis

//#ORIG Check for new mail
#define	M_CHECKNEWMAIL	Vrifier courier

//#ORIG There was a problem talking to the addressbook server (LDAP)
#define	M_ADDRBOOKERRROR	Problme avec le serveur de carnet d'adresse (LDAP)

//#ORIG Inactive logout (minutes)
#define	M_PINACTIVELOGOUT	Dconnexion automatique (minutes)

//#ORIG Time
#define	M_TIME	Date

//#ORIG Work phone
#define	M_WORKPHONE	Tlphone professionnel

//#ORIG Prefix
#define	M_PQUOTEPREFIX	Prfixe

//#ORIG Failed to create mailbox. The name may be illegal or the mailbox may exist.
#define	M_CREATEMBOXERROR	La cration a choue. Le nom est illgal ou dj utilis.

//#ORIG Index name (click to edit)
#define	M_INDEXNAMEEDIT	Nom

//#ORIG Folder
#define	M_FOLDER	Dossier

//#ORIG Upload attachment
#define	M_UPLOADATTACHMENT	Joindre un fichier

//#ORIG Show text messages
#define	M_PSHOWTEXT	Afficher les messages texte

//#ORIG Sticky Filter
#define	M_STICKYFILTER	Filtre 'Collant'

//#ORIG Address Book
#define	M_ADDRESSBOOKTITLE	Carnet d'adresses

//#ORIG ------ Forwarded message ------
#define	M_FWD_SEP	------ Message Transfr ------

//#ORIG Show HTML messages
#define	M_PSHOWHTML	Afficher les messages HTML

//#ORIG Select a mailbox
#define	M_SELECTMBOX	Choisir un dossier

//#ORIG \#sprintf ("The mail \"%s\" was sent to: %s", @arg)
#define	M_SMTPOK	\#sprintf ("Le message \"%s\" a t envoy : %s", @arg)

//#ORIG Spell check
#define	M_SPELLCHECK	Orthographe

//#ORIG Reply and move
#define	M_REPLYMOVE	Rpondre et dplacer

//#ORIG Mail notification
#define	M_MAILNOTIFYWINDOW	Notification de courrier

//#ORIG You have no uploaded files
#define	M_NOFILES	Vous n'avez charg aucun fichier.

//#ORIG Prev
#define	M_EBACKN	Pre

