/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

//
//! module: CAMAS: Log interface
//!  This module gets all camas_logger provider modules and makes them log
//! cvs_version: $Id: Log.pmod,v 1.8 2004/01/13 11:01:37 vida Exp $
//

//! method: void log (object conf, string event, mapping data)
//!  Sends a log
//! arg: object conf
//!  Current Caudium configuration
//! arg: string event
//!  The type of event to log
//! arg: mapping data
//!  Extra information
//
void log (object conf, string event, mapping data) {
  array (object) loggers = conf->get_providers ("camas_logger");

  if (loggers && sizeof (loggers))
    foreach (loggers, object logger)
    if (objectp (logger) && logger->log)
      logger->log (event, data);
}

//! method: void user_log (object conf, string event, object sessobj)
//!  Sends a user log (updates the number of sent messages, ...)
//! arg: object conf
//!  Current Caudium configuration
//! arg: string event
//!  The type of event to log
//! arg: mapping data
//!  Extra information
//! arg: object sessobj
//!  The session object
//
void user_log (object conf, string event, mapping data, object sessobj) {
  array (object) loggers = conf->get_providers ("camas_logger");

  if (loggers && sizeof (loggers)) {
    foreach (loggers, object logger)
    if (objectp (logger) && logger->user_log)
      logger->user_log (event, data, sessobj);
  }
}
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

