/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: ScreenTools.pmod,v 1.9 2004/01/13 11:01:37 vida Exp $
 */

//! file: ScreenTools.pmod
//!  Screen tools for CAMAS
//! cvs_version: $Id: ScreenTools.pmod,v 1.9 2004/01/13 11:01:37 vida Exp $

#include <camas/screens.h>
#include <camas/compat.h>

inherit "caudiumlib";

constant stoptkn = " \n\r\"()[]{}<>'`;";

//! method: int screen_name_to_id(string screenname)
//!  Translates some screen name to corresponding screen id
//! arg: string screen_name
//!  The screen name to get the id for
//! returns:
//!  int containing the screen id
//!  -1 if screen name not found
int screen_name_to_id(string screen_name)
{
  foreach(indices(screennames), int _id)
  {
    if(has_value(screennames[_id], screen_name))
      return _id;
  }
  return -1;
}

//! method: string screen_id_to_name(int screen_id)
//!  Translates some screen id to corresponding screen name
//! arg: int screen_id
//!  The screen id to get the name for
//! returns:
//!  string containing the screen name
string screen_id_to_name(int screen_id)
{
  return screennames[screen_id][0];
}

//! method: string make_links ()
//!  Helper function for the Read Mail screen, which adds &lt;a&gt;nchors for http, ftp, ... links
//! returns:
//!  The string passed with html code for following the links or composing mails
//! window
//! arg: string mail
//!  The mail
//! arg: int new_window
//!  Open the link in a new window
//! arg: void|array compose
//!  If present, following an email address will lead to the compose screen
//!  The array must contain these two elements: ({ uptarget, nextuptarget })
string make_links (string mail, int new_window, void|array compose) {
  // oliv3 TODO re-add the option to handle a maxlength for the search
  /*
   * FIXME: 10000 ?
   * string instr=text[0..(10000<sizeof(text)?10000:sizeof(text)-1)];
   */
  if (compose && (sizeof (compose) != 2))
    return "Bad arguments to make_links.";

  string newstr = "";

  array (string) keys = ({ "http://", "ftp://", "telnet://", "gopher://", "wais://", "https://" });
  if (compose)
    keys += ({ "@" });

  int length = sizeof (mail);
  int ready = 0;
  int position = 0;
  int position2 = 0;

  while (!ready) {
    int minpos = -1;
    int index;
    int foo, tmp;

    for (foo = 0; foo < sizeof (keys); foo++) {
      tmp = search (mail, keys[foo], position);
      if ((tmp != -1) && ((minpos == -1) || (tmp < minpos))) {
        minpos = tmp;
        index = foo;
      }
    }

    if (minpos != -1) {
      if (keys[index] != "@") {
        if (minpos > position)
          newstr += mail[position..minpos-1];
        newstr += "<a target=\"" + ((new_window) ? "_blank" : "_top") + "\" href=\"";
        position = minpos;
        int amp = 0;
        while ((position < length) && (amp || (!has_value (stoptkn, mail[position..position])))) {
          if (amp && mail[position] == ';')
            amp = 0;
          if (mail[position] == '&')
            amp = 1;
          position++;
        }
        newstr += replace (mail[minpos..position-1], "&amp;", "&") + "\">";
        newstr += mail[minpos..position-1] + "</a>";
      }
      else
        if (compose) {
          position2 = minpos;
          while ((position2 >= 0) && ((!has_value (stoptkn, mail[position2..position2]))))
            position2--;
          newstr += mail[position..position2];
          position = minpos;
          while ((position < length) && ((!has_value (stoptkn + "&", mail[position..position]))))
            position++;
          if ((position2 < (minpos - 1)) && (position > (minpos + 2))) {
            //	    newstr += "<a target=\"" + id->misc->imho->uptarget + "\" href=\"";
            newstr += "<a target=\"" + compose[0] + "\" href=\"";
            //	    newstr += id->misc->imho->nextuptarget + "?actioncompose=1&to=";
            newstr += compose[1] + "?actioncompose=1&to=";
	    newstr += HTTP_ENCODE_URL (mail[position2+1..position-1]) + "\">";
            newstr += mail[position2+1..position-1] + "</a>";
          }
          else
            newstr += mail[position2+1..position-1];
        }
    }
    ready = (minpos == -1);
  }
  newstr += mail[position..];
  /*
   * //FIXME: 10000 ?
   * if (sizeof(text) > 10001)
   * newstr += text[10001..sizeof(text)-1];
   */
  return newstr;
}
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

