#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
// COMPOSE screen container handler
// ============================================================================

string screen(mapping args, string contents, object id)
{
  string out = "";
  CSESSION->screen = "compose";	// Admin screen name

  mapping tags =
  	([
	    "camas_send"            : tag_compose,
 	   	"camas_cancelsend"      : tag_compose,
 	   	"camas_savedraft"       : tag_compose,
 	   	"camas_fromfield"       : tag_compose_fields,
 	   	"camas_tofield"         : tag_compose_fields,              // To: field
    	"camas_sendblind"       : tag_compose_fields,        // the blind sending mode
    	"camas_addrbookto"      : tag_compose_fields,
    	"camas_ccfield"         : tag_compose_fields,              // CC: field
    	"camas_addrbookcc"      : tag_compose_fields,
    	"camas_bccfield"        : tag_compose_fields,              // BCC: field
    	"camas_addrbookbcc"     : tag_compose_fields,
    	"camas_addrbook"        : tag_compose_fields,
    	"camas_subjectfield"    : tag_compose_fields,              // Subject: field
    	"camas_mailmessage"     : tag_camas_mailmessage,           // Textarea for typing message
    	"camas_attachmentlist"  : tag_camas_attachments,           // List of attachments
    	"camas_input_goattachscreen" : tag_compose,                     // Button for adding attachments
			"camas_input_attachfilepath" : tag_compose,
			"camas_input_attachthisfile" : tag_compose,
    	"camas_removemarkedattachments" : tag_camas_attachments,   // Button for removing attachments
    	"camas_removemarkedattachments2" : tag_camas_attachments,  // Button for removing attachments
    	"camas_mdn"             : tag_compose,                     // MDN
    	"camas_bcc2admin"       : tag_compose,                     // BCC for administrator
    	"camas_spellbutton"     : tag_camas_compose_spellcheck,    // Button for getting spellcheck
    	"camas_spelldict"       : tag_camas_compose_spellcheck,    // List for available languages
    	"camas_searchfield"     : tag_compose_fields,
    	"camas_replacefield"    : tag_compose_fields,
    	"camas_searchnreplace"  : tag_compose,
  	]);

  mapping containers =
  	([
    	"camas_attachments" : container_camas_attachments
  	]);
 
  contents = parser->run(contents, tags, containers, CSESSION->layout, __FILE__ + 
    CAMAS.Tools.get_hash(contents), id);

  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  args->method  = "post";
  args->name    = "camascomposeform";
	args->enctype = "multipart/form-data";

  args = CAMAS.Tools.set_target(id, args);
  
  out += CAMAS.Tools.make_container("form", args, contents);

  return out;
}

string tag_compose_fields(string tag_name, int pos, mapping args, object id)
{
  string out = "";
  object features = id->conf->get_provider("camas_features");
  array addressbooks = id->conf->get_providers("camas_addressbook");

  switch(tag_name)
  {
  string action;
    
  case "camas_fromfield":
    //! tag: camas_fromfield
    //!  Shows the current name and email address of the user
    //! note: screen: compose
    //! warning : setting it don't set the from field in the mail sent
    string from = 
      HTML_ENCODE_STRING (CSESSION->name+" <"+CSESSION->address+">");
    if(args->addronly)
      sscanf(from, "%*s<%s>", from);
    m_delete(args, "addronly");
    
    args->name = "from";
    args->value = from;
    if(features->QUERY (userfrom))
      out = CAMAS.Tools.make_tag("input",args);
    else
      out = from;
    break;

  case "camas_tofield":
    //! tag: camas_tofield
    //!  To input field
    //! attribute: HTML attributes applicable to &lt;input&gt;
    //! note: screen: compose
    //! args : addronly
    //!  Only display the real address, not the user first and last name
    string to = CSESSION->to;
    if(args->addronly)
      sscanf(to, "%*s<%s>", to);
    m_delete(args, "addronly");
    
    args->name  = "to";
    args->value = to;
    out = CAMAS.Tools.make_tag("input",args);
    break;

  case "camas_sendblind":
    //! tag: camas_sendblind
    //!  This checkbox allow you to have multiple To: recipients that don't see each other
    //! note: screen: compose
    if(features->QUERY(userblindsend) && (int)CSESSION->blindsend)
    {
      args->type  = "checkbox";
      args->name  = "blindsend";
      args->value = "1";
      out = CAMAS.Tools.make_tag("input",args);
    }
    else
      out = "<!-- You must enable this feature in your setup and in CAMAS: Features to get it -->\n";
    break;

  case "camas_addrbookto":
    //! tag: camas_addrbookto
    //!  Button for adding addresses from addressbook to To field
    //! note: screen: compose
    if(sizeof(addressbooks) > 0)
      out = CAMAS.Tools.formdrawbutton(id,"m_addressbook","actionaddressbookto",MSG(M_ADDRESSBOOK)+"...", args);
    else
      out = "<!-- You must load at least one addressbook module to get this screen -->";
    break;

  case "camas_ccfield":
    //! tag: camas_ccfield
    //! Cc input field
    //! attribute: HTML attributes applicable to &lt;input&gt;
    //! note: screen: compose
    args->name  = "cc";
    args->value = CSESSION->cc;
    out = CAMAS.Tools.make_tag("input",args);
    break;

  case "camas_addrbookcc":
    //! tag: camas_addrbookcc
    //!  Button for adding addresses from addressbook to Cc field
    //! note: screen: compose
    action = "actionaddressbookcc";
    if(sizeof(addressbooks) > 0)
      out = CAMAS.Tools.formdrawbutton(id,"m_addressbook",action,MSG(M_ADDRESSBOOK)+"...", args);
    else
      out = "<!-- You must load at least one addressbook module to get this screen -->";
    break;

  case "camas_bccfield":
    //! tag: camas_bccfield
    //!  Bcc input field
    //! attribute: HTML attributes applicable to &lt;input&gt;
    //! note: screen: compose
    args->name  = "bcc";
    args->value = HTML_ENCODE_STRING(CSESSION->bcc);
    out = CAMAS.Tools.make_tag("input",args);
    break;

  case "camas_addrbookbcc":
    //! tag: camas_addrbookbcc
    //!  Button for adding addresses from addressbook to Bcc field
    //! note: screen: compose
    action = "actionaddressbookbcc";
    if(sizeof(addressbooks) > 0)
      out = CAMAS.Tools.formdrawbutton(id,"m_addressbook",action,MSG(M_ADDRESSBOOK)+"...", args);
    else
      out = "<!-- You must load at least one addressbook module to get this screen -->";
    break;

  case "camas_subjectfield":
    //! tag: camas_subjectfield
    //!  Subject input field
    //! attribute: HTML attributes applicable to &lt;input&gt;
    //! note: screen: compose
    args->name  = "subject";
    args->value = HTML_ENCODE_STRING(CSESSION->subject);
    out = CAMAS.Tools.make_tag("input",args);
    break;

  case "camas_addrbook":
    //! tag: camas_addrbook
    //! Button to add address from addressbook for (To, Cc, and Bcc)
    //! note: screen: compose
    if(sizeof(addressbooks) > 0)
      out = CAMAS.Tools.formdrawbutton(id,"m_addressbook","actionaddressbooktoccbcc",MSG(M_ADDRESSBOOK)+"...", args);
    else
      out = "<!-- You must load at least one addressbook module to get this screen -->";
    break;

  case "camas_searchfield":
    //! tag: camas_searchfield
    //!  Text to search input field
    //! attribute: HTML attributes applicable to &lt;input&gt;
    //! note: screen: compose
    if(id->supports->javascript)
    {
      args->name = "tosearch";
      out = CAMAS.Tools.make_tag("input",args);
    }
    break;

  case "camas_replacefield":
    //! tag: camas_replacefield
    //!  Text to replace with
    // attribute: HTML attributes applicable to &lt;input&gt;
    //! note: screen: compose
    if(id->supports->javascript)
    {
      args->name = "toreplace";
      out = CAMAS.Tools.make_tag("input",args);
    }
    break;

  default:
    out = "<!-- "+tag_name+" is not supported yet -->";
    CDEBUG(tag_name+" not supported");
  }
  return out;
}

string tag_compose(string tag_name, int pos, mapping args, object id)
{
  object camas_features = id->conf->get_provider("camas_features");
  if (!objectp(camas_features)){
    CDEBUG("module camas_features is not present");
    return "foobar";
  }

  string out = "";

  switch(tag_name)
  {
    string action;
  case "camas_send":
    //! tag: camas_send
    //!  Button for sending mail
    //! note: screen: compose
    action = "actionsend";
    out = CAMAS.Tools.formdrawbutton(id,"m_send",action,MSG(M_SEND),args);
    break;

  case "camas_cancelsend":
    //! tag: camas_cancelsend
    //!  Button for canceling writing of current mail.
    //! note : Current mail will be lost.
    //! note: screen: compose
    action = "actionindex";
    out = CAMAS.Tools.formdrawbutton(id,"m_cancelsend",action,MSG(M_CANCELSEND), args);
    break;

  case "camas_savedraft":
    //! tag: camas_savedraft
    //!  Button for saving current mail as draft
    //! attribute: inbox
    //!  Forces the draft to be saved into the inbox drafts folders if the current namespace isn't under INBOX
    //!  eg the draft message will be saved in INBOX.Drafts instead of shared.some.mailbox.Drafts
    //! attribute: noshared
    //!  Don't provide the functionnality if the user is in the shared hierarchy.
    //! note: screen: compose
    //! screen : compose
    if(!(args->noshared && !CAMASFOLDERTOOLS.is_in_shared(CSESSION->mailbox, CSESSION)))
    {
      action = "actionsavedraft";
      if(args->inbox)
        action += "ininbox";
      
			m_delete(args, "noshared");
      out = CAMAS.Tools.formdrawbutton(id,"m_savedraft",action,MSG(M_SAVEDRAFT), args);
    }
    else
      CDEBUG("camas_savedraft: saving drafts in shared hierarchy is disabled");
    break;

  case "camas_mdn":
    //! tag: camas_mdn
    //!  Checkbox for requesting mdn
    //! note: screen: compose
    args->type  = "checkbox";
    args->name  = "mdn";
    args->value = "1";
    out += CAMAS.Tools.make_tag("input",args);
    break;

  case "camas_bcc2admin":
    //! tag: camas_bcc2admin
    //!  Checkbox for sending bcc to administrator
    //! note: screen: compose
    if(sizeof(CSESSION->bcc2admin))
    {
      args->type  = "checkbox";
      args->name  = "bcc2admin";
      args->value = CSESSION->bcc2admin;
      out += CAMAS.Tools.make_tag("input",args);
    }
    break;

	case "camas_input_attachfilepath":
		//! tag: camas_input_attachfilepath
		//!  Input type file for choosing the file to upload
		if(camas_features->QUERY(attachments))
		{
			args->type = "file";
			args->name = "file";

			out += CAMAS.Tools.make_tag("input", args);
		}
		break;

	case "camas_input_attachthisfile":
		//! tag: camas_input_attachthisfile
		//!  Button for uploading file to attach
		if(camas_features->QUERY(attachments))
		{
			out += CAMAS.Tools.formdrawbutton(id, "m_uploadtoattachments", "actionuploadattachment", MSG(M_UPLOADTOATTACHMENTS), args);
		}
		break;

  case "camas_input_goattachscreen":
    //! tag: camas_input_goattachscreen
    //!  Button for going attachment screen 
    //! note: screen: compose
    if(camas_features->QUERY(attachments))
    {
      out = CAMAS.Tools.formdrawbutton(id,"m_addattachment", "actiongotoaddattachment", MSG(M_ADDATTACHMENT)+"...", args);
    }
    else
    {
      out = "<!-- Attachments sending is not allowed -->";
      CDEBUG("Attachments sending is not allowed");
    }
    break;

  case "camas_searchnreplace":
    //! tag: camas_searchnreplace
    //!  Button for doing search and replace
    //! note: screen: compose
    if(id->supports->javascript)
    {
      string jscode = "function searchNReplace(tosearch,toreplace){\n";
      jscode += "  oldString = document.camascomposeform.message.value;\n";
      jscode += "  newString = oldString.split(tosearch).join(toreplace);\n";
      jscode += "  eval('document.camascomposeform.message.value = newString');\n";
      jscode += "  return false;\n";
      jscode += "}";
      out += CAMAS.Tools.make_container("script",([ "language":"javascript" ]), jscode); 
      
      mapping buttonargs = ([ ]);
      buttonargs->onclick = "return searchNReplace(document.camascomposeform.tosearch.value,document.camascomposeform.toreplace.value)";
      out += CAMAS.Tools.formdrawbutton(id,"m_searchnreplace", "", MSG(M_SEARCHREPLACE), buttonargs);
    }
    break;

  default:
    out = "<!-- "+tag_name+" is not supported yet -->";
    CDEBUG(tag_name+" not supported");
  }

  return out;
}

string tag_camas_compose_spellcheck(string tag_name, int pos, mapping args, object id)
{
  object features = id->conf->get_provider ("camas_main");
  if (!objectp(features)){
    CDEBUG("module camas_main is not present");
    return "foobar";
  }

  string out="";

  if(features->QUERY(ispell) && features->QUERY(ispelldict))
  {
    switch(tag_name)
    {
      string action;
    case "camas_spelldict":
      //! tag: camas_spelldict
      //!  Returns list of available languages
      //! note: requires &lt;camas_spellbutton&gt;
      string contentselect = "";
      foreach (features->QUERY(ispelldict) / ",", string dict)
      {
        mapping argsoption = ([ "value":dict ]);
	int separator = search(dict, ":");
	if(separator > 0)
	  dict = dict[separator+1..];
        contentselect += CAMAS.Tools.make_container("option", argsoption, HTML_ENCODE_STRING(dict));
      }

      args->name = "ispelldict";
      out += CAMAS.Tools.make_container("select", args, contentselect);
      break;

    case "camas_spellbutton":
      //! tag: camas_spellbutton
      //!  Button for spellchecking
      //! note: requires &lt;camas_spelldict&gt;
      out += CAMAS.Tools.formdrawbutton(id,"m_spellcheck","actionspellcheck",MSG(M_SPELLCHECK), args);
      break;
    default:
      out += "<!-- "+tag_name+" is not supported yet -->";
      CDEBUG(tag_name+" not supported");
    }
  }
  else{
    CDEBUG("ispell or its dictionnary path may not be set");
  }
  return out;
}

//! tag: camas_mailmessage
//!  Textarea for writing mail
//! attribute: All HTML attributes applicable to &lt;textarea&gt;&lt;/textarea&gt;
string tag_camas_mailmessage(string tag_name, int pos, mapping args, object id)
{
  string out="";

  args->name="message";

  args->rows = args->rows ? args->rows : "25";
  args->cols = args->cols ? args->cols : "72";
  args->wrap = args->wrap ? args->wrap : "physical";

  out += CAMAS.Tools.make_container("textarea", args, CSESSION->message);

  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
