#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  SETUP screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "";
  
  CSESSION->screen = "setup";	// Screen name
  
  contents = CAMAS.Parse.parse_html(contents,
                        ([
			                    "camas_saveprefs"   : tag_camas_saveprefs,
                         ]),
                        ([
			                    "camas_prefslist"   : container_camas_prefslist,
                         ]),
                        id);

  if(!id->misc->_xml_parser)
    if(QUERY(ent_parse))
      contents = parse_scopes(contents,cb_scopes,id);

  // id->variables->newuser set if user don't have prefs set (thus is a new user)
  if (!CSESSION->prefsloaded)
    id->variables->newuser=1;
  else
    id->variables->newuser=0;

  args->method = "post";
  args->name = "camassetupform";

  args = CAMAS.Tools.set_target(id, args);

  out += CAMAS.Tools.make_container("form",args,contents);

  return out;
}

//! tag: camas_saveprefs
//!  Button for saving preferences
//! note: screen: setup
string tag_camas_saveprefs(string tag_name, mapping args, object id)
{
  string out="";

  out = CAMAS.Tools.formdrawbutton(id,"m_psaveanduse", "actionsavesetup", MSG(M_PSAVEANDUSE), args);

  return out;
}

//! container: camas_prefslist
//!  List of preferences possible to change
//! note: screen: setup
string container_camas_prefslist(string tag_name, mapping args, string contents, object id)
{
  object features = id->conf->get_provider("camas_features"); // CAMAS features
  string out = "";

  /* arrays for storing labels and corresponding setups */
  array(string) labels = ({ });
  array(string) setups = ({ });

  /* temporary string for manipulating setups before putting them into the setups array  */
  string setup = "";

  /* building the list of user-modifiable items */

  // TODO: order the labels and setup arrays in order to play with order of options?

  mapping optionargs = ([ ]);  // mapping for storing args in <option></> container

  /* If user can change name */
  if(features->feature(FEAT_USERCANCHANGENAME))
  {
    args = ([ ]);

    labels += ({ MSG(M_PNAME) });
    args -> name = "name";
    args -> value= CAMAS.Tools.fixstring (CSESSION->name);
    setups += ({ CAMAS.Tools.make_tag("input", args) });
  }

  /* If user can specify user address */
  if (features->feature(FEAT_USERADDRESS))
  {
    args = ([ ]);

    labels += ({ MSG(M_PMAILADDRESS) });
    args -> name = "address";
    args -> value= CAMAS.Tools.fixstring (CSESSION->address);
    setups += ({ CAMAS.Tools.make_tag("input", args) });
  }

  /* If user can specify mail path */
  if (features->feature(FEAT_USERMAILPATH))
  {
    args = ([ ]);
    
    labels += ({ MSG(M_PMAILPATH) });
    args -> name = "mailpath";
    args -> value= CAMAS.Tools.fixstring (CSESSION->mailpath);
    setups += ({ CAMAS.Tools.make_tag("input", args) });
  }

  /* If user can choose language */
  if ((sizeof(CAMAS_LANGUAGE->lang_progs) > 1) && features->feature(FEAT_USERLANGUAGE))
  {
    args = ([ ]);

    labels += ({ MSG(M_PLANGUAGE) });
    setup = "";
    foreach (sort(indices(CAMAS_LANGUAGE->lang_progs)), string opt)
    {
      optionargs = ([ ]);
      optionargs->value = opt;
      if (CSESSION->language == opt)
        optionargs->selected = "selected";
      
      setup += CAMAS.Tools.make_container("option", optionargs, upper_case (opt[0..0]) + opt[1..]);
    }
    args->name = "language";
    setup = CAMAS.Tools.make_container("select", args, setup);
    setups += ({ setup });
  }

  /* If user can choose layout */
  if(features->QUERY(userlayouts))
  {
    args = ([ ]);
    array (string) layouts = id->conf->get_provider ("camas_layout_manager")->list_layouts ();
    if (sizeof (layouts) > 1)
    {
      labels += ({ MSG(M_PUSERINTERFACE) });
      setup = "";
      foreach (layouts, string lay)
      {
        optionargs = ([ ]);
	optionargs->value = lay;
	
        if (CSESSION->layout == lay)
	  optionargs->selected = "selected";      
	
	setup += CAMAS.Tools.make_container("option", optionargs, lay);
      }
      args->name = "layout";
      setup = CAMAS.Tools.make_container("select",args, setup);

      setups += ({ setup });
    }
  }

  /* if user can change post login screen */ 
  if(features->feature(FEAT_USERDEFAULTPOSTLOGINSCREEN))
  {
    args = ([ ]);
    string setup = "";
    labels += ({ MSG(M_PPOSTLOGINSCREEN) });
    foreach(({ "mailindex", "compose", "folderlist", "setup", "files", "searchmail" }), string screen)
    {
      optionargs = ([ ]);
      optionargs->value = screen;
      string screenname;
      foreach(values(screennames), array arr)
      {
        if(arr[0] == screen)
          screenname = MSG(arr[1]); 
      }
      if(CSESSION->defaultpostloginscreen == screen)
        optionargs->selected = "selected";
      setup += CAMAS.Tools.make_container("option", optionargs, screenname);
    }
    args->name = "defaultpostloginscreen";
    setup = CAMAS.Tools.make_container("select", args, setup);
    setups += ({ setup });
  }
  
  /* If the user want to include original email in his answer */ 
  args = ([ ]);
  optionargs = ([ ]);

  labels += ({ MSG(M_PINCLUDEMAIL) });

  optionargs->value = "1";
  if (CSESSION->replyincludemsg == "1")
    optionargs->selected = "selected";
  setup = CAMAS.Tools.make_container("option", optionargs, MSG(M_YES));

  optionargs = ([ ]);

  optionargs->value = "0";
  if (CSESSION->replyincludemsg == "0")
    optionargs->selected = "selected";
  setup += CAMAS.Tools.make_container("option", optionargs, MSG(M_NO));

  args->name = "replyincludemsg";

  setup = CAMAS.Tools.make_container("select", args, setup);
  setups += ({ setup });

	/* If the user is allowed to reply on top */
	if(features->feature(FEAT_USERCANREPLYONTOP))
	{
		args = ([ ]);
		optionargs = ([ ]);

		labels += ({ MSG(M_PREPLYONTOP) });
		
		optionargs->value = "0";
		if(CSESSION->replyontop == "0")
			optionargs->selected = "selected";
		setup = CAMAS.Tools.make_container("option", optionargs, MSG(M_NO));
		
		optionargs = ([ ]);
		
		optionargs->value = "1";
		if(CSESSION->replyontop == "1")
			optionargs->selected = "selected";
		setup += CAMAS.Tools.make_container("option", optionargs, MSG(M_YES));

		args->name = "replyontop";
	
		setup = CAMAS.Tools.make_container("select", args, setup);
		setups += ({ setup });
	}

  /* If user can change reply prefix */
  if(features->QUERY(chgreplymsgprefix))
  {
    args = ([ ]);

    labels += ({ MSG(M_PQUOTEPREFIX) });
    args->name = "replymsgprefix";
    args->size = "5";
    args->value= CAMAS.Tools.fixstring (CSESSION->replymsgprefix);
    setup = CAMAS.Tools.make_tag("input",args);
    setups += ({ setup });
  }

  /* Signature field */
  args = ([ ]);

  labels += ({ MSG(M_PSIGNATURE) });
  args->name = "signature";
  args->rows = "4";
  args->cols = (string)features->QUERY(usersignaturecols);
  setup = CAMAS.Tools.make_container("textarea", args, HTML_ENCODE_STRING (CSESSION->signature));
  setups += ({ setup });

  /* If user can setup own headers */
  if (features->feature(FEAT_USERHEADERS))
  {
    args = ([ ]);

    labels += ({ MSG(M_PHEADER) });
    args->name = "extraheader";
    args->rows = "2";
    args->cols = "70";  
    setup = CAMAS.Tools.make_container("textarea",args, HTML_ENCODE_STRING (CSESSION->extraheader))+"<br />";
    setup += MSG(M_PHEADERDESC);
    setups += ({ setup });

  }

  /* idle time for being deconnected */
  args = ([ ]);

  labels += ({ MSG(M_PINACTIVELOGOUT) });
  setup = "";
  foreach (({ /* "1", */ "5", "10", "20", "60", "120", "480" }), string opt)
  {
    optionargs = ([ ]);
    optionargs->value = opt;
    if (CSESSION->autologout == opt)
      optionargs->selected = "selected";      
    setup += CAMAS.Tools.make_container("option", optionargs, opt);
  }
  args->name = "autologout";
  setup = CAMAS.Tools.make_container("select",args, setup);
  setups += ({ setup });


  /* Number of messages to display in a page */
  args = ([ ]);

  labels += ({ MSG(M_PVISIBLEMESSAGES) });
  setup = "";
  foreach (({ "10", "15", "20", "30", "40", "60", "100" }), string opt)
  {
    optionargs = ([ ]);
    optionargs->value = opt;

    if (CSESSION->visiblemail == opt)
      optionargs->selected = "selected";      
    
    setup += CAMAS.Tools.make_container("option", optionargs, opt);
  }
  args->name = "visiblemail";
  setup = CAMAS.Tools.make_container("select",args, setup);
  setups += ({ setup });


  /* Sort order of the messages */
  args = ([ ]);
  labels += ({ MSG(M_PSORTORDER) });
  setup = "";
  foreach (({ "forward", "backward" }), string opt)
  {
    optionargs = ([ ]);
    optionargs->value = opt;

    if (CSESSION->sortorder == opt)
      optionargs->selected = "selected";      
    
    string sortord = MSGA(M_PSORTORDERS, ({ opt }) );
    setup += CAMAS.Tools.make_container("option", optionargs, upper_case (sortord[0..0]) + sortord[1..]);
  }
  args->name = "sortorder";
  setup = CAMAS.Tools.make_container("select",args, setup);
  setups += ({ setup });


  /* The column on which to sort */
  args = ([ ]);

  labels += ({ MSG(M_PSORTCOLUMN) });
  setup = "";
  array columns = ({ "num", "date", "received", "from", "to", "subject", "size" });
  foreach (columns, string col) {
    optionargs = ([ ]);
    optionargs->value = col;

    if (CSESSION->sortcolumn == col)
      optionargs -> selected = "selected";      
    
    string coli; 
    
    switch (col)
    {
	    case "num":
	      coli = MSG(M_NUMBER);
	      break;
	    case "date":
	      coli = MSG(M_DATE);
	      break;
	    case "received":
	      coli = MSG(M_RECEIVED);
	      break;
	    case "from":
	      coli = MSG(M_FROM);
	      break;
	    case "to":
	      coli = MSG(M_TO);
	      break;
	    case "subject":
	      coli = MSG(M_SUBJECT);
	      break;
	    case "size":
	      coli = MSG(M_SIZE);
	      break;
    }
    setup += CAMAS.Tools.make_container("option", optionargs, coli);
  }
  args->name = "sortcolumn";
  setup = CAMAS.Tools.make_container("select", args ,setup);
  setups += ({ setup });

 
  /* If user can read HTML parts of mails */
  if (features->feature(FEAT_SHOWHTML))
  {
    args = ([ ]);
    labels += ({ MSG(M_PSHOWHTML) });
    
    optionargs = ([ ]);
    optionargs->value = "1";
    if (CSESSION->showhtml == "1")
      optionargs->selected = "selected";
    setup = CAMAS.Tools.make_container("option", optionargs ,MSG(M_YES));
    
    optionargs = ([ ]);
    optionargs->value = "0";
    if (CSESSION->showhtml == "0")
      optionargs->selected = "selected";
    setup += CAMAS.Tools.make_container("option", optionargs ,MSG(M_NO));
    
    args->name = "showhtml";
    
    setup = CAMAS.Tools.make_container("select",args, setup);
    setups += ({ setup });
  }


  /* If user can readh text parts of mails */
  if (features->feature(FEAT_SHOWTEXT))
  {
    args = ([ ]);
    optionargs = ([ ]);

    labels += ({ MSG(M_PSHOWTEXT) });
    optionargs->value = "1";
    if (CSESSION->showtext == "1")
      optionargs->selected = "selected";
    setup = CAMAS.Tools.make_container("option", optionargs ,MSG(M_YES));
    
    optionargs = ([ ]);
    optionargs->value = "0";
    if (CSESSION->showtext == "0")
      optionargs->selected = "selected";
    setup += CAMAS.Tools.make_container("option", optionargs ,MSG(M_NO));
    
    args->name = "showtext";
    
    setup = CAMAS.Tools.make_container("select", args, setup);
    setups += ({ setup });
  }

  /* If user can use the blind send feature */
  if(features->QUERY(userblindsend))
  {
    args = ([ ]);
    optionargs = ([ ]);

    labels += ({ MSG(M_PSENDBLIND) });
    optionargs->value = "1";
    if (CSESSION->blindsend == "1")
      optionargs->selected = "selected";
    setup = CAMAS.Tools.make_container("option", optionargs ,MSG(M_YES));
    
    optionargs = ([ ]);
    optionargs->value = "0";
    if (CSESSION->blindsend == "0")
      optionargs->selected = "selected";
    setup += CAMAS.Tools.make_container("option", optionargs ,MSG(M_NO));
    
    args->name = "blindsend";
    setup = CAMAS.Tools.make_container("select", args, setup);
    setups += ({ setup });
  }

  /* If user can access mailboxes */
  if (features->feature(FEAT_MAILBOXES))
  {
    /* If user can specify his own trash folder */
    if ((<"both", "move to trash">)[features->QUERY(deletemethod)])
      if (features->feature(FEAT_USERTRASHFOLDER))
      {
        args = ([ ]);
        labels += ({ MSG(M_PTRASHFOLDER) });
        args->name = "trashfolder";
	args->value= CAMAS.Tools.fixstring (CSESSION->trashfolder);
	setups += ({ CAMAS.Tools.make_tag("input", args) });
      }
   
    /* If user can specify his own drafts folder */
    if (features->feature(FEAT_USERDRAFTSFOLDER))
    {
      args = ([ ]);
      labels += ({ MSG(M_PDRAFTSFOLDER) });
      args->name = "draftsfolder";
      args->value= CAMAS.Tools.fixstring (CSESSION->draftsfolder);
      setups += ({ CAMAS.Tools.make_tag("input", args) });
    }
    
    /* If user can specify his own answered folder */
    if (features->feature (FEAT_USERANSWEREDFOLDER))
    {
      args = ([ ]);
      labels += ({ MSG(M_PANSWEREDFOLDER) });
      args->name = "answeredfolder";
      args->value= CAMAS.Tools.fixstring (CSESSION->answeredfolder);
      setups += ({ CAMAS.Tools.make_tag("input", args) });
    }


    /* If user can specify his own sent folder */
    if (features->feature(FEAT_USERSENTFOLDER))
    {
      args = ([ ]);
      labels += ({ MSG(M_PSENTFOLDER) });
      args->name = "sentfolder";
      args->value= CAMAS.Tools.fixstring (CSESSION->sentfolder);
      setups += ({ CAMAS.Tools.make_tag("input", args) });


      /* If attachment are kept in sent folder */
      if (features->feature(FEAT_USERSENTSAVEATTACHMENTS)) 
      {
        args = ([ ]);
        labels += ({ MSG(M_PSAVEATTACHMENTS) });

        optionargs = ([ ]);
	optionargs->value = "1";
	if (CSESSION->saveattachments == "1")
	  optionargs->selected = "selected";
	setup = CAMAS.Tools.make_container("option", optionargs ,MSG(M_YES));
	
	optionargs = ([ ]);
	optionargs->value = "0";
	if (CSESSION->saveattachments == "0")
	  optionargs->selected = "selected";
	setup += CAMAS.Tools.make_container("option", optionargs ,MSG(M_NO));
	
	args->name = "saveattachments";
	
	setup = CAMAS.Tools.make_container("select", args, setup);
	setups += ({ setup });
      }
    }
  }


  /* If user can use BCC */
  if (features->feature(FEAT_USERBCCCOPY) && CSESSION->autobcc && CSESSION->autobcc != "0")
  {
    args = ([ ]);
    labels += ({ MSG(M_PDEFAULTBCC) });
    args->name = "autobcc";
    args->value= CAMAS.Tools.fixstring (CSESSION->autobcc);
    setups += ({ CAMAS.Tools.make_tag("input", args) });
  }

  /* If user can use filterbook */
  if(features->QUERY(filterbook) && features->QUERY(userautofilter) &&
     features->QUERY(autofilter))
  {
    args = ([ ]);
    optionargs = ([ ]);

    labels += ({ MSG(M_PAUTOFILTER) });

    optionargs->value = "1";
    if (CSESSION->autofilter == "1")
      optionargs->selected = "selected";
    setup = CAMAS.Tools.make_container("option", optionargs ,MSG(M_YES));
   
    optionargs = ([ ]);
   
    optionargs->value = "0";
    if (CSESSION->autofilter == "0")
      optionargs->selected = "selected";
    setup += CAMAS.Tools.make_container("option", optionargs ,MSG(M_NO));
    
    args->name = "autofilter";
    
    setup = CAMAS.Tools.make_container("select",args, setup);
    setups += ({ setup });
  }

  /* If user can see hidden headers */
  if (features->feature(FEAT_USERSETUPSHOWHIDDENHEADERS))
  {
    args = ([ ]);
    optionargs = ([ ]);

    labels += ({ MSG(M_PSHOWHIDDENHEADERS) });

    optionargs->value = "1";
    if (CSESSION->showhiddenheaders == "1")
      optionargs->selected = "selected";
    setup = CAMAS.Tools.make_container("option", optionargs ,MSG(M_YES));
   
    optionargs = ([ ]);
   
    optionargs->value = "0";
    if (CSESSION->showhiddenheaders == "0")
      optionargs->selected = "selected";
    setup += CAMAS.Tools.make_container("option", optionargs ,MSG(M_NO));
    
    args->name = "showhiddenheaders";
    
    setup = CAMAS.Tools.make_container("select", args, setup);
    setups += ({ setup });
  }

  /* Is user can specify an organization */
  if (features->feature(FEAT_ORGANIZATION))
  {
    args = ([ ]);

    labels += ({ MSG(M_PORGANIZATION) });
    args->name = "organization";
    args->value= CAMAS.Tools.fixstring (CSESSION->organization);
    setups += ({ CAMAS.Tools.make_tag("input", args) });
  }

  /* If user can enable/disable background imap cache feeder */
  if (features->feature(FEAT_USERCANDISABLEIMAPCACHEFEEDER))
  {
    args = ([ ]);
    optionargs = ([ ]);
    labels += ({ MSG(M_PENABLEDISABLECACHEFEEDER) });

    optionargs->value = "1";
    if (CSESSION->feedimapcache == "1")
      optionargs->selected = "selected";
    setup = CAMAS.Tools.make_container("option", optionargs ,MSG(M_YES));
    
    optionargs = ([ ]);
    
    optionargs->value = "0";
    if (CSESSION->feedimapcache == "0")
      optionargs->selected = "selected";
    setup += CAMAS.Tools.make_container("option", optionargs ,MSG(M_NO));
     
    args->name = "feedimapcache";
    setup = CAMAS.Tools.make_container("select", args, setup);
    setups += ({ setup });
  }

  /* replacing labels and corresponding setups */

  for(int _count=0; _count<sizeof(setups); _count++)
  {
    array outlet = ({
                      ([
                       "labels"    : labels[_count],
                       "setups"    : setups[_count],
                       ])
                    });

    out += do_output_tag(args, outlet, contents, id);
  }
 
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
