(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Maxence's plug-in. *)

open Cam_plug

type file = {
    name : string ;
    mutable create : bool ;
  } 

let filenames p = [
  p^"messages.ml" ;
  p^"global.ml" ;
  p^"global.mli" ;
  p^"types.ml" ;
  p^"types.mli";
  p^"args.ml" ;
  p^"args.mli" ;
  p^"gui_base.zog" ;
  p^"gui.ml" ;
  p^"misc.ml" ;
  p^"misc.mli" ;
  p^"main.ml" ;
  "Makefile.in" ;
  "Makefile" ;
  "configure.in" ;
  "README" ;
  "LICENSE" ;
  "INSTALL" ;
  ".depend";
] 

(** Make the user give a prefix and offer to create some files
   according to the given prefix, in the selected directory. 
   @command add_base_files
*)
let add_base_files args =
  match Cam_plug.selected_dir () with
    None ->
      GToolbox.message_box "Error" "Please select a directory."
  | Some dir ->
      match GToolbox.input_string ~title: dir
	  "Enter the prefix for files : "
      with
	None -> ()
      | Some prefix ->
	  let f acc file =
	    if Sys.file_exists (Filename.concat dir file) then
	      acc
	    else
	      { name = file ; create = false ; } :: acc
	  in
	  let files_pre = List.fold_left f [] (filenames prefix) in
	  let files = List.rev files_pre in
	  let module C = Configwin in
	  let param f =
	    C.bool ~f: (fun b -> f.create <- b) 
	      f.name
	      f.create
	  in
	  let params = List.map param files in
	  match C.simple_get "Add base files" params with
	    C.Return_cancel | C.Return_apply -> ()
	  | C.Return_ok ->
	      let to_create = 
		List.map (fun f -> "\""^f.name^"\"") 
		  (List.filter (fun f -> f.create) files)
	      in
	      let args = String.concat " " to_create in
	      Cam_plug.eval ("new_file "^args) ()

let _ = Cam_plug.add_command "add_base_files"
    "Offer to create base files in the selected directory."
    add_base_files
