(* $Id: cam_docbrowser.ml,v 1.2 2005/06/09 09:52:11 zoggy Exp $ *)

(** Main module for the standalone documentation browser. *)

ignore (GMain.Main.init ());;

let doc_files = ref ([] : string list)

let options_list = [
] ;;

Arg.parse options_list
    (fun s -> doc_files := !doc_files @ [s])
    Cam_messages.usage_browser;;


Cam_doc.default_doc_modules := Cam_doc.load_doc_files !doc_files;;


Cam_doc_gui.create_or_update_list_window Cam_doc.default_doc_modules;;

let _ =
  match !Cam_doc_gui.modules_window with
    None -> ()
  | Some (w,_,_,_) ->
      ignore (w#connect#destroy GMain.Main.quit);
      Cam_rc.load_core ();
      Cam_rc.load_gui ();
      Cam_doc.init_keymaps ();
      GMain.Main.main ()
