(* $Id: cam_new_project.ml,v 1.2 2005/06/10 15:08:38 zoggy Exp $ *)

type project_kind = [
    `Library
  | `Tool
  | `Tool_and_library
  ]

let mod_args = "args"
let mod_config = "config"
let mod_constant = "constant"
let mod_main = "main"
let mod_messages = "messages"
let mod_misc = "misc"
let mod_types = "types"

let default_ocaml_modules =
  [
    (* filename postfix, description, templates for mli, templates for ml *)
    (mod_args, "Command line arguments", [], []);
    (mod_config, "Configuration values", [], []);
    (mod_constant, "Constants", [], []);
    (mod_main, "Main module", [], []);
    (mod_messages, "Messages", [], []);
    (mod_misc, "Misc functions", [], []);
    (mod_types, "Basic types", [], []);
  ]

type newp_options = {
    mutable n_name : string ;
    mutable n_file_prefix : string ;
    mutable ocaml_modules : (string * string * string list * string list) list;
  }
let new_project args = ()

let _ = Cam_commands.register
    {
      Cam_commands.com_name = Cam_constant.com_new_project ;
      Cam_commands.com_args = [| |] ;
      Cam_commands.com_more_args = None ;
      Cam_commands.com_f = new_project ;
    }
