/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef ACTIONSTATE_H
#define ACTIONSTATE_H

// Qt stuff
#include <QTime>
#include <QState>
#include <QVector>
#include <QTextStream>

//CamiTK stuff
#include <Action.h>

// Local stuff
#include "ActionStateWidget.h"
#include "ActionTransition.h"

using namespace camitk;

class ActionState : public QState {

public:
	/**
	 */
	ActionState(QState * parent, QString name, QString description, QTextStream * logStream = NULL);

	void setAction(Action * action, 
				   QMap<QString, QVariant> parameters,
				   QMap<QString, QString> inputComponentNames, 
				   QMap<QString, QString> outputComponentNames);

	/// Returns the name of the action state (may be different from the name of the actual action)
	QString getName();
	/// Returns the description of the action state (may be different from the description of the actual action)
	QString getDescription();

	/// May change its description according to the previous action result
	void setAleternativeDesc(QString altDescText, QVector<Action::ApplyStatus> statusList);


	virtual Action::ApplyStatus applyAction();

	/// Adds a possible transition from this action
	ActionTransition * addActionTransition(QString buttonText, QAbstractState * nextState, 
		
	bool applyAction = true, QVector<Action::ApplyStatus> disableConditions = QVector<Action::ApplyStatus>());

	ActionStateWidget * getWidget();

	void setPreviousActionStatus(Action::ApplyStatus status);
	void setFinal();

	


protected:
	/// Reimplemented from QState 
	/// @{
	virtual void 	onEntry ( QEvent * event );

	virtual void 	onExit ( QEvent * event );
	///@}

	/// Name of the state action (may not be the same as the action's name)
	QString name;
	/// Description of the state action 
	/// may not be the same as the action's description but complementary
	QString description;

	/// Actual CamiTK action
	Action * myAction;

	QMap<QString, QString> inputComponentNames;
	QMap<QString, QString> outputComponentNames;

	/// Buttons that should be disabled if the previous aciton state did not happen correctly
	QMap<Action::ApplyStatus, QVector<QPushButton * > > conditionalButtons;

	//// Descriptions that should be displaied if the previous action state did not happen correctly
	QMap<Action::ApplyStatus, QString> conditionalDescriptions;

	/** 
	 * Widget containing:
	 *  - the name of the state action
	 *  - the description of the action
	 *  - the action's widget
	 *  - the buttons linking to the transitions
	 */
	ActionStateWidget * myStateWidget;

	/// Log stream to write report on logFile
	QTextStream * logStream;

	/// Keep track of time...
	QTime * startTime;


};
#endif // ACTIONSTATE_H