/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef EXTENSIONGENERATOR_H
#define EXTENSIONGENERATOR_H

#if defined(_WIN32) && !defined(__MINGW32__) // MSVC only
#pragma warning( disable : 4290 )
#endif // MSVC only


// includes from Qt
#include <QString>
#include <QFileInfo>
#include <QDir>

// Includes from coreschema
#include <Extension.hxx>

using namespace coreschema;



class ExtensionGenerator {

public :
    enum ExtensionType {
        ACTION,
        APPLICATION,
        COMPONENT,
        VIEWER,
        UNKNOWN
    };

    static bool generateExtensionFiles(QString xmlFileName, QString devDirectoryName);


protected:
    ExtensionGenerator(QString xmlFileName, QString devDirectoryName) throw (QString);

    void setXmlFileName(QString xmlFileName)            throw (QString);
    void setDevDirectoryName(QString devDirectoryName)  throw (QString);
	void createTestDataFiles()  throw (QString);

    void generateCMakeLists()                           throw (QString);
    void generateExtensionFiles()                       throw (QString); 
    void generateInternFilesList()                      throw (QString);
    void generateInternFiles()                          throw (QString);

    void generateActionExtensionFiles()                 throw (QString);
    void generateActionsList()                          throw (QString);
    void generateActionFiles()                          throw (QString);

    void generateComponentExtensionFiles()              throw (QString);
    void generateComponentsList()                       throw (QString);
    void generateComponentFiles()                       throw (QString);

	void showReport();
    void writeReport();



    QFileInfo xmlFileName;
    QDir devDirectoryName;
	QDir srcDir;

    std::auto_ptr<Extension> theExtension;
    
    ExtensionType type;

    std::vector<QFileInfo> elementsList;
    std::vector<QString> generatedClassList;


};

#endif
