# Ctest script for packaging nightly CamiTK
# To configure a Nightly packaging, create a cron job using this script "ctest -S this-script.cmake -V"
#
# What this script does ?
# * INFORMATION STEP
# 	Configure SITE and BUILD information to be correctly display on dashboard
# 	Loads information from the CTestConfig.cmake file.
# * UPDATE STEP
#	use svn to udpdate source code to the latest revision BEFORE Nightly start time, which is defined in the CTestConfig.cmake file.
# * CONFIGURE STEP
#	configure the whole CamiTK project and create a new build directory 
# * BUILD STEP 
#	build each subproject of CamiTK
# For each step a report is sent to the dashboard. This allows any developer to be informed (mailing list) of any problem, even BEFORE the script ends !

# Need to be defined, for the build to run.
set(CTEST_SOURCE_DIRECTORY "/home/saubatn/dev/camitk/trunk/camitk")
set(CTEST_BINARY_DIRECTORY "/home/saubatn/dev/camitk/package_nightly_tmp")

# Script configuration, depending of the build, computer running the script
# Update to feat each computer which runs this script
set( CTEST_SITE "MERISE")
set( CTEST_BUILD_NAME "Ubu12-32-Release")
set( CTEST_CMAKE_GENERATOR  "Unix Makefiles")
set( CTEST_BUILD_CONFIGURATION "Release")

# Update source code and send reports
# set( CTEST_UPDATE_COMMAND "svn")
find_program(CTEST_SVN_COMMAND svn)
set( CTEST_UPDATE_COMMAND ${CTEST_SVN_COMMAND})

# CMake configuration (put here all the configure flags)
set( CTEST_CONFIGURE_COMMAND "${CMAKE_COMMAND} -G \"${CTEST_CMAKE_GENERATOR}\"")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCMAKE_BUILD_TYPE:STRING=${CTEST_BUILD_CONFIGURATION}")
# Packaging installation location 
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCAMITK_INSTALL_ROOT:PATH=/usr")
# CPack packaging target
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_DEB:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_RPM:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_STGZ:BOOL=FALSE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_TGZ:BOOL=FALSE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_TZ:BOOL=FALSE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_TBZ2:BOOL=FALSE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_TGZ:BOOL=FALSE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCPACK_BINARY_TZ:BOOL=FALSE")
# ACTIONS preferences
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_APPLICATION:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_ARBITRARYSLICE:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_BASICMESH:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_BASICTOPOLOGY:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_IMAGELUT:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_ITKFILTERS:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_ITKSEGMENTATION:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_MESHPROCESSING:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_MML:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_RECONSTRUCTION:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DACTION_VOLUMERENDERING:BOOL=TRUE")
# COMPONENTS preferences
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_DICOM:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_ITKIMAGE:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_MML:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_MSH:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_OBJ:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_PHYSICALMODEL:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_VRML:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_VTKIMAGE:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCOMPONENT_VTKMESH:BOOL=TRUE")
# TOOL preferences
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DTOOL_CORESCHEMA:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DTOOL_LML:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DTOOL_PML:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DTOOL_MML:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DMML_GENERATE_XSD_LIB:BOOL=TRUE")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DMML_GENERATE_GUI:BOOL=ON")
# Source files
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} ${CTEST_SOURCE_DIRECTORY}")

# to get CDash server configuration :
include("${CTEST_SOURCE_DIRECTORY}/../CTestConfig.cmake")

# The type of build that this script will make 
# For this script we use Nightly build has it is designed to be run once a day
ctest_start(Nightly)

# Update source code
ctest_update(SOURCE ${CTEST_SOURCE_DIRECTORY})
ctest_submit(PARTS Update Notes)

# Configure whole project
ctest_empty_binary_directory(${CTEST_BINARY_DIRECTORY})
ctest_configure()
ctest_submit(PARTS Configure)

# to get subprojects listing (automatically created at confituration step)
include("${CTEST_BINARY_DIRECTORY}/Subprojects.cmake")

# Update CDash configuration to the server
# Project.xml file is automatically generated. If someone added an extension to CamiTK, CDash will automatically be updated according to it.
# To do this, send this file to the server
ctest_submit(FILES "${CTEST_BINARY_DIRECTORY}/Project.xml") 

# Build each subprojects
foreach(subproject ${CAMITK_SUBPROJECTS})
	# tag sub project
	set_property(GLOBAL PROPERTY SubProject ${subproject})
	set_property(GLOBAL PROPERTY Label ${subproject})

	# build each sub project
	set(CTEST_BUILD_TARGET ${subproject})
	ctest_build()
	ctest_submit(PARTS Build)

	# TODO : mais plus tard ...
	# runs only tests that have a LABELS property matching “${subproject}” (si c'est pas la classe)
	# ctest_test(BUILD “${CTEST_BINARY_DIRECTORY}” INCLUDE_LABEL “${subproject}”)
	# ctest_submit(PARTS Test)
endforeach() 

# Packaging
# tag the corresponding subproject to match corresponding CDash's one.
set_property(GLOBAL PROPERTY SubProject package)
set_property(GLOBAL PROPERTY Label package)
# Package CamiTK and send the report.
set(CTEST_BUILD_TARGET camitk_package)
ctest_build()
ctest_submit(PARTS Build)

