/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef INTERFACEPROPERTY_H
#define INTERFACEPROPERTY_H

#include "CamiTKAPI.h"

#include <QObject>

namespace camitk
{

/** This class describe what are the methods to implement in order to manage dynamic properties.
 */
class InterfaceProperty : public QObject {
    Q_OBJECT
public:
    /// empty virtual destructor, to avoid memory leak
    virtual ~InterfaceProperty() {};

    /// Get the inheritance hierachy of this Component instance as a list of QString
    virtual QStringList getHierarchy() = 0;

    /// Assert that a Component instance really inherits from a given className
    virtual bool isInstanceOf(QString className) = 0;

    /** get the property widget to display.
     * (always return NULL, overwrite this method if you want to give here you own widget)
     * @see PropertyExplorer
     */
    virtual QWidget * getPropertyWidget(QWidget* parent = 0) = 0;

    /** get the property object that could be understood by PropertyEditor.
     *  Returns this as any Component instance can manage its list of dynamic properties (and Component inherits
     *  from InterfaceProperty aka QObject).
     *  You can also have a separate class to manage your Component properties. In this case, just overide this
     *  method and return the corresponding instance.
     *  @see PropertyExplorer ObjectController
     */
    virtual QObject * getPropertyObject() = 0;

    /** update property: if you override this method, do not forget to call the superclass method
     *  for the property not managed locally in order to properly manage all inherited dynamic properties.
     * This method is called when a dynamic property has to be udpated
     * @param name the name of the dynamic property
     * @param value the new value to take into account
     */
    virtual void updateProperty(QString name, QVariant value) = 0;
};

}

#endif // INTERFACEPROPERTY_H
