/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include <iostream>
#include <string>
using namespace std;

#include <PhysicalModel.h>
#include <Atom.h>
#include <StructuralComponent.h>

#include "AbortException.h"

int main ( int argc, char ** argv ) {

    if ( argc!=2 ) {
        cout << "Usage:" << endl;
        cout << "\t" << argv[0] << " file.pml" << endl;
        cout << "PML " << PhysicalModel::VERSION << endl;
        return EXIT_SUCCESS;
    }

    try {
        string filename ( argv[1] );

        PhysicalModel pm ( filename.c_str() );
        cout << "name= " << pm.getName() << endl;
        cout << "nr of atoms= " << pm.getNumberOfAtoms() << endl;
        cout << "nr of cells= " << pm.getNumberOfCells() << endl;
        double bary[3];
        for ( int i=0;i<3;i++ )
            bary[i] = 0.0;
        double pos[3];
        for (unsigned int i=0;i<pm.getNumberOfAtoms();i++ ) {
	    dynamic_cast<Atom*>(pm.getAtoms()->getStructure( i ))->getPosition ( pos );
            for ( int j=0;j<3;j++ )
                bary[j] += pos[j];
        }
        for ( int i=0;i<3;i++ )
            bary[i] /= pm.getNumberOfAtoms();

        cout << "barycenters of atoms= (" << bary[0] << "," << bary[1] << "," << bary[2] << ")" << endl;
        
        unsigned int pLast = filename.rfind ( "." );
        if ( pLast != string::npos ) {
            filename.erase ( pLast );
            filename += "-output-pmltest.pml";
        } else
            filename="output-pmltest.pml";

        cout << "-> saved as " << filename << endl;

        ofstream outputFile ( filename.c_str() );
        pm.xmlPrint ( outputFile );

        return EXIT_SUCCESS;
    } catch ( AbortException ae ) {
        cout << "AbortException: Physical model aborted:" << endl ;
        cout << ae.what() << endl;
    }

    return EXIT_FAILURE;

}
