/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "BasicSCProperties.h"

BasicSCProperties::BasicSCProperties(PhysicalModel * p, xmlNodePtr node) : Properties(p) {
    alloc();

    //search the name attribute
    xmlChar *pname = xmlGetProp(node, (const xmlChar*) "name");

    if (pname)
        setName(std::string((char*)pname));

    xmlFree(pname);

    //get the pointer on color
    xmlNodePtr SCchild = node->xmlChildrenNode;

    while (SCchild && xmlStrcmp(SCchild->name, (const xmlChar*)"color"))
        SCchild = SCchild->next;

    if (SCchild) {
        //search the color attributes
        xmlChar *pr = xmlGetProp(SCchild, (const xmlChar*) "r");
        xmlChar *pg = xmlGetProp(SCchild, (const xmlChar*) "g");
        xmlChar *pb = xmlGetProp(SCchild, (const xmlChar*) "b");
        xmlChar *pa = xmlGetProp(SCchild, (const xmlChar*) "a");

        if (pr && pg && pb) {
            setRGB(atof((char*)pr), atof((char*)pg), atof((char*)pb));

            if (pa)
                setAlpha(atof((char*)pa));
            else
                setAlpha(1.0);
        }
        else
            setColor(DEFAULT);

        xmlFree(pr);
        xmlFree(pg);
        xmlFree(pb);
        xmlFree(pa);
    }
    else
        setColor(DEFAULT);

    //search the renderingmode attribute
    xmlChar *pmode = xmlGetProp(node, (const xmlChar*) "mode");

    if (pmode) {
        if (!xmlStrcmp(pmode, (const xmlChar*)"NONE"))
            setMode(RenderingMode::NONE);

        if (!xmlStrcmp(pmode, (const xmlChar*)"POINTS"))
            setMode(RenderingMode::POINTS);

        if (!xmlStrcmp(pmode, (const xmlChar*)"POINTS_AND_SURFACE"))
            setMode(RenderingMode::POINTS_AND_SURFACE);

        if (!xmlStrcmp(pmode, (const xmlChar*)"SURFACE"))
            setMode(RenderingMode::SURFACE);

        if (!xmlStrcmp(pmode, (const xmlChar*)"WIREFRAME_AND_SURFACE"))
            setMode(RenderingMode::WIREFRAME_AND_SURFACE);

        if (!xmlStrcmp(pmode, (const xmlChar*)"WIREFRAME_AND_POINTS"))
            setMode(RenderingMode::WIREFRAME_AND_POINTS);

        if (!xmlStrcmp(pmode, (const xmlChar*)"WIREFRAME"))
            setMode(RenderingMode::WIREFRAME);

        if (!xmlStrcmp(pmode, (const xmlChar*)"WIREFRAME_AND_SURFACE_AND_POINTS"))
            setMode(RenderingMode::WIREFRAME_AND_SURFACE_AND_POINTS);

        xmlFree(pmode);
    }
    else
        setMode(RenderingMode::NONE);


    //search the unknown attributes to fill the property fields map
    xmlAttr * attrs = node->properties;

    xmlNodePtr unknownAttrs = xmlNewNode(NULL, (xmlChar*)("unknownAttrs"));;

    while (attrs) {
        const xmlChar * pname = attrs->name;
        xmlChar * pval = attrs->children->content;

        if (pname && xmlStrcmp(pname, (xmlChar*)"name") &&
                xmlStrcmp(pname, (xmlChar*)"index") &&
                xmlStrcmp(pname, (xmlChar*)"mode")) {
            xmlSetProp(unknownAttrs, pname, pval);
        }

        attrs = attrs->next;
    }

    //transform the unknown attributes to a property field map
    domToFields(unknownAttrs);

    xmlFree(unknownAttrs);
}

