#------------------------------------------
# To generate CamiTK the api documentation
#-------------------------------------------
set(APIDOC_SDK FALSE CACHE BOOL "Generate API documentation for CamiTK SDK")
if(APIDOC_SDK)
    include(FindDoxygen)
    if (DOXYGEN)
        # ---------------------------------
        # Cmake modules needed
        # ---------------------------------
        find_package(HTMLHelp)

        if (HTML_HELP_COMPILER)
        set(DOXYGEN_HTMLHELP YES)
        else (HTML_HELP_COMPILER)
        set(DOXYGEN_HTMLHELP NO)
        endif (HTML_HELP_COMPILER)

        if (DOT)
        set(HAVE_DOT YES)
        else (DOT)
        set(HAVE_DOT NO)
        endif (DOT)

        set(DOXYGEN_LANGUAGE "English" CACHE STRING "Language used by doxygen")
        mark_as_advanced(DOXYGEN_LANGUAGE)

        # define where to put the apidoc at build time
        set(CAMITK_APIDOC_DIR ${CMAKE_BINARY_DIR}/share/${CAMITK_SHORT_VERSION_STRING}/apidoc)

        set(DOXYGEN_OUTPUT_DIR ${CAMITK_APIDOC_DIR})

        message(STATUS "Generating build target 'apidoc' for CamiTK SDK documentation in ${CAMITK_APIDOC_DIR}")

        # which directories to use
        set(DOXYGEN_SUBDIRS)
#         set(DOXYGEN_SUBDIRS ${DOXYGEN_SUBDIRS} ${CMAKE_CURRENT_SOURCE_DIR}/actions)
#         set(DOXYGEN_SUBDIRS ${DOXYGEN_SUBDIRS} ${CMAKE_CURRENT_SOURCE_DIR}/applications)
        set(DOXYGEN_SUBDIRS ${DOXYGEN_SUBDIRS} ${CMAKE_CURRENT_SOURCE_DIR}/cmake)
#         set(DOXYGEN_SUBDIRS ${DOXYGEN_SUBDIRS} ${CMAKE_CURRENT_SOURCE_DIR}/components)
        set(DOXYGEN_SUBDIRS ${DOXYGEN_SUBDIRS} ${CMAKE_CURRENT_SOURCE_DIR}/libraries/core)

        string(REGEX REPLACE ";" " " DOXYGEN_INPUT_LIST "${DOXYGEN_SUBDIRS}")

        set(PROJECT_LOGO ${CMAKE_CURRENT_SOURCE_DIR}/libraries/core/resources/camitk-small.png)

        # Configure doxyfile, doxygen project configuration file.
        configure_file(${CMAKE_CURRENT_SOURCE_DIR}/cmake/modules/doxygen.conf.in ${CMAKE_CURRENT_BINARY_DIR}/Doxyfile @ONLY)

        # Configure CamiTKVersion.h.in to generate index.html page for API documentation
        configure_file(${CMAKE_CURRENT_SOURCE_DIR}/libraries/core/CamiTKVersion.h.in ${CMAKE_CURRENT_BINARY_DIR}/core/CamiTKVersion.h @ONLY)

        add_custom_target(apidoc
                          COMMAND ${DOXYGEN_EXECUTABLE} ${CMAKE_CURRENT_BINARY_DIR}/Doxyfile
                          COMMENT "Generating CamiTK SDK API documentation using Doxygen"
                          VERBATIM
        )

        # create directory if it does not exist
        if (NOT EXISTS ${CAMITK_APIDOC_DIR})
            message(STATUS "Creating api-doc directory: ${CAMITK_APIDOC_DIR}")
            file(MAKE_DIRECTORY ${CAMITK_APIDOC_DIR})
        endif()

        # doc installation
        install(DIRECTORY ${CAMITK_APIDOC_DIR}
                DESTINATION share/${CAMITK_SHORT_VERSION_STRING}
                COMPONENT apidoc
        )
    else()
        message(WARNING "Doxygen not found - CamiTK SDK API documentation and reference manual will not be created")
    endif()
endif()
