/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef ATOMPROPERTIES_H
#define ATOMPROPERTIES_H

#include "BasicAtomProperties.h"

/**
  * This is an automatically generated class for custom Atom properties.
  * It was generated by the <tt>customPhysicalProperties</tt> stylesheet from 
  * the following xml document:
  <pre>
  
        
         
  
  </pre>
  * This class inherits BasicAtomProperties.
  * Here is all the specific attributes of Atom properties (custom physical properties)
  *
  */
class AtomProperties : public BasicAtomProperties {
public:
    /** Constructors (do not change) */
    AtomProperties(PhysicalModel *p) :  BasicAtomProperties(p) { init(); };
	AtomProperties(PhysicalModel *p, xmlNodePtr node) :  BasicAtomProperties(p, node) { init(); };
    AtomProperties(PhysicalModel *p, const unsigned int ind) : BasicAtomProperties(p, ind) { init(); };
    AtomProperties(PhysicalModel *p, const double pos[3]) : BasicAtomProperties(p, pos) { init(); };
    AtomProperties(PhysicalModel *p, const unsigned int ind, const double pos[3]) : BasicAtomProperties(p, ind, pos) { init(); };
    virtual ~AtomProperties();     
           
    /** Print the properties in xml */
    void xmlPrint(std::ostream &);

    /** Set and get method for all the properties */
    void setMyCustomProperty1(const int);
    int getMyCustomProperty1() const;
            
    void setMyCustomProperty2(const std::string);
    std::string getMyCustomProperty2() const;
            
    
protected:
                
    virtual void init();
    int myCustomProperty1;
    std::string myCustomProperty2;
    
};                

// inlines
inline void AtomProperties::setMyCustomProperty1(const int value) { myCustomProperty1 = value; }
inline int AtomProperties::getMyCustomProperty1() const { return myCustomProperty1; }
inline void AtomProperties::setMyCustomProperty2(const std::string value) { myCustomProperty2 = value; }
inline std::string AtomProperties::getMyCustomProperty2() const { return myCustomProperty2; }

#endif

