/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef PLANE_WIDGET_H
#define PLANE_WIDGET_H

#include <Action.h>

// VTK stuff
#include <vtkSmartPointer.h>
#include <vtkImplicitPlaneWidget.h>
#include <vtkCommand.h>

using namespace camitk;


///This class implements a VTK implicit plane in the CamiTK application
class PlaneWidget : public vtkCommand {

public:

    /// the constructor
    PlaneWidget();

    /// the constructor
    PlaneWidget(Action *a);

    /// the destructor
    virtual ~PlaneWidget();

    /// The widget to see the real information => the high resolution region
    vtkSmartPointer<vtkImplicitPlaneWidget> planeWidget;

    /** Allows one to get the current 3D widget configuration.
     *  This is a VTK "callback" (inherited from vtkCommand).
     */
    virtual void Execute(vtkObject *caller, unsigned long, void *);

private:
    camitk::Action *action;
};

#endif // PLANE_WIDGET_H
