/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "ParametersWriter.h"

#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>
#include "MultiComponent.h"

// -------------------- constructor --------------------
ParametersWriter::ParametersWriter(MonitoringManager* monitoringManager): AnsysBatchWriter(monitoringManager) {}

// -------------------- destructor --------------------
ParametersWriter::~ParametersWriter() {}

// -------------------- write --------------------
std::string ParametersWriter::write() {
    std::ostringstream os;
    //iterate over the fields of the exclusive components and add them as parameters in batch file
    Properties* prop=monitoringManager->getPml()->getExclusiveComponents()->getProperties();
    if (prop) {
        for(unsigned int i=0; i<prop->numberOfFields(); i++) {
            std::string field=prop->getField(i);
            os << field << "=" << prop->getString(field) << std::endl;
        }
        return os.str();
    }

}