/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "Component.h"
#include "MultiComponent.h"

// -------------------- constructor --------------------
Component::Component(PhysicalModel *p, std::string n) {
    this->properties = new Properties(p,n);
    exclusive = true;
}

// -------------------- destructor --------------------
Component::~Component() {
    deleteProperties();
    removeFromParents();
}

// -------------------- deleteProperties --------------------
void Component::deleteProperties() {
    delete properties;
    properties = NULL;
}

// -------------------- removeFromParents --------------------
void Component::removeFromParents() {
    // tell all the parents that I am disappearing from memory
    // (copy the list as removeSubComponent modify my list)
    std::vector <MultiComponent *> parentMultiComponentsCopy;
    parentMultiComponentsCopy.reserve(parentMultiComponentList.size());
    //std::copy(parentMultiComponentList.begin(), parentMultiComponentList.end(), parentMultiComponentsCopy.begin());
    for (unsigned int i=0 ; i<parentMultiComponentList.size(); i++)
        parentMultiComponentsCopy.push_back(parentMultiComponentList[i]);


    for (unsigned int i=0; i<parentMultiComponentsCopy.size(); i++)
        parentMultiComponentsCopy[i]->removeSubComponent(this);

    // here assert parentMultiComponentList.size()==0
}
