/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef MOVEFRAME_H
#define MOVEFRAME_H

#include "Action.h"
#include "Component.h"

#include <QVector3D>

#include <vtkTransform.h>
#include <vtkTransformFilter.h>
#include <vtkSmartPointer.h>

#include "ui_MoveFrame.h"


/** This action allows you to apply a linear transformation
 * (translation,rotation around axes) on the top level selected Frame
 */
class MoveFrame : public camitk::Action {
    Q_OBJECT

public:
    /// the constructor
    MoveFrame(camitk::ActionExtension*);

    /// Destructor
    virtual ~MoveFrame();

    /// this method creates and returns the widget containing the user interface for the action
    virtual QWidget * getWidget();

public slots:
    /// method called when the action is applied
    virtual ApplyStatus apply();

    virtual void translate();
    virtual void setTranslation();
    virtual void rotate();
    virtual void setRotation();
    virtual void save();
    virtual void changeParent();

private slots:

    /// slot called when reset is ckicked, reset the transformation to Identity
    void reset();

private:
    /// initialize the dialog
    void init();

    /// current transformation
    vtkTransform * transformation;

    /// initial transformation
    QVector3D initialPosition;
    QVector3D initialOrientation;

    /// current transform filters (one per selected object)
//    QList< vtkSmartPointer<vtkTransformFilter> > filterList;

    /// the Qt Gui
    Ui::MoveFrame ui;

    /// the dialog
    QDialog *dialog;

    camitk::Component * inputFrame;

};

#endif // MOVEFRAME_H
