/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// Include .h file
#include "ActionExtensionDependenciesState.h"
#include "DorothyMainWindow.h"
#include "ActionExtensionCreationState.h"
#include "DependenciesWidget.h"

// includes from coreschema
#include <ActionExtension.hxx>
#include <Actions.hxx>
#include <Action.hxx>

/**  Constructor */
ActionExtensionDependenciesState::ActionExtensionDependenciesState(QString name, DependenciesWidget * widget, DorothyMainWindow * mainWindow,  cepcoreschema::Cep * domCep, ActionExtensionCreationState * parent)
    : DependenciesState(name, widget, mainWindow, domCep, parent) {
    this->domActionExtension = NULL;
    widget->setElement("Action Extension");
}

/**  Destructor */
ActionExtensionDependenciesState::~ActionExtensionDependenciesState() {}

void ActionExtensionDependenciesState::resetDomActionExtension(cepcoreschema::ActionExtension * domActionExtension) {
    this->domActionExtension = domActionExtension;
    DependenciesWidget * dependenciesWidget = dynamic_cast<DependenciesWidget *> (widget);
    if (dependenciesWidget != NULL) {
        dependenciesWidget->setToDefault();
    }
}

void ActionExtensionDependenciesState::onEntry(QEvent *event) {
    DependenciesState::onEntry(event);
    DependenciesWidget * dependenciesWidget = dynamic_cast<DependenciesWidget *> (widget);
    if (dependenciesWidget != NULL) {
        // Look for itk dependencies
        if (isItkDependant(domActionExtension)) {
            dependenciesWidget->setItkDependency(true);
        }
    }
}


void ActionExtensionDependenciesState::onExit( QEvent * event ) {
    DependenciesState::onExit(event);
    cepcoreschema::Dependencies * domDeps = getDependencies();
    if (domDeps != NULL) {
        if (domDeps->dependency().size() > 0) {
            domActionExtension->dependencies((*domDeps));
        }
    }
}

bool ActionExtensionDependenciesState::isItkDependant(cepcoreschema::ActionExtension * domExtension) {
    const cepcoreschema::Actions::action_sequence createdActions = domExtension->actions().action();
    int i = 0;
    while ((i < createdActions.size() && (! createdActions.at(i).classification().itkFilter().present()))) {
        i++;
    }

    return i < createdActions.size();

}
