/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// Include .h file
#include "ActionExtensionDescriptionWidget.h"

#include "DefaultGUIText.h"

// Qt files
#include <QMessageBox>

/**  Constructor */
ActionExtensionDescriptionWidget::ActionExtensionDescriptionWidget(QWidget * parent) : QWidget(parent) {
    ui.setupUi(this);
}
/**  Destructor */
ActionExtensionDescriptionWidget::~ActionExtensionDescriptionWidget() {}

void ActionExtensionDescriptionWidget::cancelButtonClicked() {
    emit cancel();
}

void ActionExtensionDescriptionWidget::nextButtonClicked() {
    QString actionExtensionName = ui.actionExtensionNameItself->text();
    QString actionExtensionDescription = ui.actionExtensionDescriptionItself->toPlainText();

    if (actionExtensionName.toUtf8() != actionExtensionName.toAscii()) {
        ui.actionExtensionNameStar->setStyleSheet(enhancedStyle);
        ui.actionExtensionDescriptionStar->setStyleSheet(normalStyle);
        ui.requiredLabel->setStyleSheet(enhancedStyle);
        QMessageBox::warning(this, defaultBeforeGoingFurther, defaultAscii);
    } else if ((actionExtensionName.isEmpty()) || (actionExtensionName == defaultActionExtensionName)) {
        ui.actionExtensionNameStar->setStyleSheet(enhancedStyle);
        ui.actionExtensionDescriptionStar->setStyleSheet(normalStyle);
        ui.requiredLabel->setStyleSheet(enhancedStyle);
        QMessageBox::warning(this, defaultBeforeGoingFurther, defaultRealExtensionName);
    } else if (actionExtensionDescription.toUtf8() != actionExtensionDescription.toAscii()) {
        ui.actionExtensionNameStar->setStyleSheet(normalStyle);
        ui.actionExtensionDescriptionStar->setStyleSheet(enhancedStyle);
        ui.requiredLabel->setStyleSheet(enhancedStyle);
        QMessageBox::warning(this, defaultBeforeGoingFurther, defaultAscii);
    } else if ((actionExtensionDescription.isEmpty()) || (actionExtensionDescription == defaultActionExtensionDescription)) {
        ui.actionExtensionNameStar->setStyleSheet(normalStyle);
        ui.actionExtensionDescriptionStar->setStyleSheet(enhancedStyle);
        ui.requiredLabel->setStyleSheet(enhancedStyle);
        QMessageBox::warning(this, defaultBeforeGoingFurther, defaultRealExtensionDescription);
    } else {
        ui.actionExtensionNameStar->setStyleSheet(normalStyle);
        ui.actionExtensionDescriptionStar->setStyleSheet(normalStyle);
        ui.requiredLabel->setStyleSheet(normalStyle);
        emit next();
    }
}

void ActionExtensionDescriptionWidget::setToDefault() {
    ui.explanationLabel->setText(defaultActionExtensionExplanation);
    ui.actionExtensionNameItself->setText(defaultActionExtensionName);
    ui.actionExtensionDescriptionItself->setPlainText(defaultActionExtensionDescription);
    ui.actionExtensionNameStar->setStyleSheet(normalStyle);
    ui.actionExtensionDescriptionStar->setStyleSheet(normalStyle);
    ui.requiredLabel->setStyleSheet(normalStyle);
}

QString ActionExtensionDescriptionWidget::getActionExtensionName() {
    return ui.actionExtensionNameItself->text();
}

QString ActionExtensionDescriptionWidget::getCepDescription() {
    return ui.actionExtensionDescriptionItself->toPlainText();
}


