/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- Core stuff
#include "ComponentExtension.h"
#include "Application.h"
#include "Log.h"

// -- QT stuff
#include <QDir>
#include <QtGui>

namespace camitk {

// -------------------- constructor --------------------
ComponentExtension::ComponentExtension() {
    autoload = false;
}

// -------------------- destructor --------------------
ComponentExtension::~ComponentExtension() {
}

// -------------------- save --------------------
bool ComponentExtension::save(Component* component) const {
    QString extension = QFileInfo(component->getFileName()).completeSuffix();

    QMessageBox::warning(NULL, "Saving Error", tr("Extension ") + getName() + tr(" can not export the component:<br/>\"")
                         + component->getName() + tr("\"<br/>To the file format \".") + extension + tr("\"<br>This is not implemented yet."));

    return false;
}

// -------------------- initResources --------------------
void ComponentExtension::initResources() {
    // Get the selected language
    QString selectedLanguage = Application::getSelectedLanguage();

    QString componentExtensionDirName = QDir(this->getLocation()).dirName();
    // remove any occurence of "-debug.dll" or ".so" or ".dylib" on the extension file name
    componentExtensionDirName.remove("-debug.dll").remove(".so").remove(".dylib");
    QString languageFile = ":/translate_" + componentExtensionDirName + "/translate/translate_" + selectedLanguage + ".qm";
    QTranslator* translator = new QTranslator();
    if (!translator->load(languageFile))
        CAMITK_WARNING("Application", "initResources", "Cannot load file: " + languageFile.toStdString())
        else
            QCoreApplication::installTranslator(translator);
}



}
