/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "MeshDataModel.h"
#include "MeshComponent.h"

#include <vtkCellData.h>
#include <vtkPointData.h>

namespace camitk {

MeshDataModel::MeshDataModel ( MeshComponent* meshComp ) :
    QAbstractTableModel ( meshComp ), meshComponent ( meshComp ) {

}

int MeshDataModel::rowCount ( const QModelIndex& parent ) const {
    if ( !meshComponent || !(meshComponent->getPointSet()) )
        return 0;

    return meshComponent->getPointSet()->GetCellData()->GetNumberOfArrays() + meshComponent->getPointSet()->GetPointData()->GetNumberOfArrays();
}

int MeshDataModel::columnCount ( const QModelIndex& parent ) const {
    return 3;
}

QVariant MeshDataModel::data ( const QModelIndex& index, int role ) const {
    if ( !meshComponent || !(meshComponent->getPointSet()) )
        return QVariant();

    int row = index.row();
    int col = index.column();

    int nbPointData = meshComponent->getPointSet()->GetPointData()->GetNumberOfArrays();
    int nbCellData =  meshComponent->getPointSet()->GetCellData()->GetNumberOfArrays();
    vtkDataSetAttributes* data;
    int dataNum;
    QString field;

    if ( row < nbPointData ) {
        data = meshComponent->getPointSet()->GetPointData();
        dataNum = row;
        field = "point";
    } else {
        data = meshComponent->getPointSet()->GetCellData();
        dataNum = row - nbPointData;
        field = "cell";
    }

    switch ( role ) {
    case Qt::DisplayRole:
        switch ( col ) {
        case 0 :
            return QString ( data->GetArray ( dataNum )->GetName() );
            break;
        case 1 :
            return field;
            break;
        case 2 : {
            switch ( data->GetArray ( dataNum )->GetNumberOfComponents() ) {
            case 1:
                return QString ( "scalars" );
                break;
            case 3 :
                return QString ( "vectors" );
                break;
            case 9 :
                return QString ( "tensors" );
                break;
            default :
                return QString::number ( data->GetArray ( dataNum )->GetNumberOfComponents() );
                break;
            }
            break;
        }
        default :
            return QVariant();
            break;
        }
        break;
    default :
        return QVariant();
        break;
    }
    return QVariant();
}

QVariant MeshDataModel::headerData ( int section, Qt::Orientation orientation, int role ) const {
    if ( role == Qt::DisplayRole ) {
        if ( orientation == Qt::Horizontal ) {
            switch ( section ) {
            case 0:
                return QString ( "Name" );
                break;
            case 1:
                return QString ( "Field" );
                break;
            case 2:
                return QString ( "Type" );
                break;
            default:
                return QVariant();
                break;
            }
        }
    }
    return QVariant();
}

void MeshDataModel::refresh() {
    reset();
}

}