/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef DICOMTREESTUDYCOMPONENT_H
#define DICOMTREESTUDYCOMPONENT_H

// CamiTK includes
#include <Component.h>
class DicomTreeDirectoryComponent;
class DicomTreeSerieComponent;

// Qt includes
#include <QObject>
#include <QList>



/**
 *
 * @brief
 * This component allows you to read DICOM images files of several SERIES of a same STUDY
 *
 * Each STUDY represents a collection of several medical examinations (which can result with images taken from different MODALITIES). A MODALITY is the provider of information, which is, in other words, the machine that allows the doctor to acquire images from the PATIENT. MODALITY are mainly scanners (MRI ...).
 * Each STUDY can have several SERIES of images. One SERIE of images is the result of one medical examination using ONE MODALITY.
 *
 * This component works on images acquired in several SERIES, but on the same specific STUDY.
 * Each SERIE of images represents one 3D volumic image.
 * Each SERIE of images selected is then been rendered in CamiTK's viewers as an ImageComponent.
 * DICOM images tags are also displayed as Property in the PropertyExplorer (DICOM tab).
 *
 * @note
 * Requires GDCM library in order to work correctly.
 * This component does not support 2D Images serie (GDCM limitation)
 */
class DicomTreeStudyComponent : public camitk::Component {

    Q_OBJECT

public:
    /**
     * Parse the list of files and build a DicomSerieComponent per SERIE
     * @param parent the parent DicomDirectoryComponent that contains all the studies
     * @param fileNames images of different SERIES but of the same STUDY
     **/
    DicomTreeStudyComponent(const std::vector< std::string > & fileNames) throw(camitk::AbortException);

    /// Default Destructor
    virtual ~DicomTreeStudyComponent();

    /// this component has no representation
    void initRepresentation() {}

private:

    /**
     * @brief List of series that study contains
     */
//    QList< DicomSerieComponent > series;

};

#endif // DICOMTREESTUDYCOMPONENT_H

