(* Generated by camlmix. *)
(* Do not edit! *)

module Annot :
sig
(* $Id: annot.mli 7 2009-08-11 20:32:07Z mjambon $ *)

type layer_info = { innermost : bool;
		    outermost : bool }

type tag = [ `Start of string | `Stop ] * (Lexing.position * layer_info)

type filter = [ `All | `Innermost | `Outermost ]

val parse :
  impl_file:string ->
  annot_file:string -> tag list
val guess_annot_file : string -> string option
val from_file : impl_file:string -> annot_file:string -> tag list option

end

module Plugin :
sig
(* $Id: plugin.mli 3 2008-09-29 11:11:48Z mjambon $ *)

type handler =
    [ `Command of string (* External command *)
    | `Function of (string -> string option) (* Function *) ]
      (** Custom comment handler. *)

val add : string -> handler -> unit
  (** Add or replace handler. *)

val remove : string -> unit
  (** Remove handler if it exists. *)

val exists : string -> bool
  (** Test whether such handler exists. *)

val find : string -> handler
  (** Find handler or raise [Not_found]. *)


val count_newlines : string -> int
  (** Count the number of newline characters in a string. *)

val expand : string -> string -> string option
  (** [expand handler_name s] find the handler [handler_name]
      and apply it to the input string [s].
      If the handler is an external command, the result is [None] 
      if and only if the process exits with a non-zero status.
      If the handler is a function, the behavior corresponds to
      the behavior of the function itself and any exception is propagated.
  *)

val register_command : string -> unit
  (** Parse and register a handler defined as "name:command". *)

end

module Input :
sig
(* 
   Copyright 2004 Martin Jambon

   This file is distributed under the terms of the GNU Public License
   http://www.gnu.org/licenses/gpl.txt
*)

(*
   This module provides functions that parse OCaml source code and return
   a list of tokens which are suitable for automatic syntax highlighting.
   Any input is accepted. Only a lexical analysis is performed and thus can
   be used to highlight incorrect programs as well as derivatives
   of OCaml (.ml .mli .mll .mly).
*)

type token =
  [ `Comment of string   (** a (fragment of) comment *)
  | `Special_comment of string * string (** (handler name, full comment) *)
  | `Construct of string (** an uppercase identifier or
			     an identifier starting with ` *)
  | `Keyword of string   (** a keyword *)
  | `Newline             (** a newline character *)
  | `String of string    (** a (fragment of) string or character literal *)
  | `Quotation of string (** a camlp4 quotation *)
  | `Tab                 (** a tabulation character *)
  | `Token of string     (** anything else *)
  | `Start_annot of (Annot.layer_info * string) (** start of a type annotation 
						  read from .annot file *)
  | `Stop_annot of Annot.layer_info ]  (** end of a type annotation
					 read from .annot file *)

val parse :
  ?annot:Annot.tag list -> Lexing.lexbuf -> token list
val string : 
  ?filename:string -> ?annot:Annot.tag list -> string -> token list
val channel : 
  ?filename:string -> ?annot:Annot.tag list -> in_channel -> token list
val file : 
  ?annot:Annot.tag list -> string -> token list

end

module Output :
sig
(* 
   Copyright 2004 Martin Jambon

   This module produces HTML code for the presentation of OCaml programs
   (.ml .mli .mll .mly).

   This file is distributed under the terms of the GNU Public License
   http://www.gnu.org/licenses/gpl.txt
*)

val version : string
(** Version of caml2html. For compatibility with older versions. 
  Use [Version.version] instead, which returns only the version code,
  without the "caml2html " prefix. *)

type class_definition = (string list * (string * string) list)

val default_default_style : class_definition list

val default_style : string

val key_color1 : string option
val key_color2 : string option
val key_color3 : string option
val key_color4 : string option
val key_color5 : string option
val construct_color : string option * string option * string
val comment_color : string option * string option * string
val string_color : string option * string option * string
val alpha_keyword_color : string option * string option * string
val nonalpha_keyword_color : string option * string option * string

val default_keyword_color_list : 
  (string * (string option * string option * string)) list
val default_keyword_colors : 
  (string, string option * string option * string) Hashtbl.t
val all_colors : (string option * string option * string) list
(** colors which are used for the predefined style.
  This is a list of couples (optional color specification, CSS class). *)

val make_css : 
  ?default: class_definition list ->
  ?colors:(string option * string option * string) list -> string -> unit
(** make a CSS file from the given colors *)

type style = [ `Inline | `Inhead of string | `Url of string ]

type param = {
  line_numbers : bool;
  title : bool;
  body_only : bool;
  tab_size : int;
  footnote : bool;
  style : style;
  html_comments : bool;
  charset : string;
  annot_filter : Annot.filter;
  no_annot : bool;
  ie7 : bool;
}
(** the type of the options for making the HTML document *)

val default_param : param

val ocaml :
  ?nbsp:bool ->
  ?keyword_colors:(string, string option * string option * string) Hashtbl.t ->
  ?param:param ->
  Buffer.t -> 
  Input.token list -> unit
(** [ocaml buf l] formats the list of tokens [l] into some HTML code
  which should be placed in a <code> or <pre> region,
  and adds the result the given buffer [buf].
  Option [nbsp] tells if the spaces must be converted into "&nbsp;" or not
  (required in <code> regions but not in <pre>; default is false). *)

val ocamlcode :
  ?annot:Annot.tag list ->
  ?keyword_colors:(string, string option * string option * string) Hashtbl.t ->
  ?param:param -> ?tag_open:string -> ?tag_close:string -> string -> string
(** [ocamlcode s1 s2] parses [s1] and formats the result as a HTML string
  enclosed between <code> and </code> unless specified otherwise. *)

val ocamlpre :
  ?annot:Annot.tag list ->
  ?keyword_colors:(string, string option * string option * string) Hashtbl.t ->
  ?param:param -> ?tag_open:string -> ?tag_close:string -> string -> string
(** [ocamlcode s1 s2] parses [s1] and formats the result as a HTML string
  enclosed between <pre> and </pre> unless specified otherwise. *)

(* $Id: output.mli 12 2010-06-28 18:18:41Z mjambon $ *)

val ocaml_file :
  ?filename:string ->
  ?keyword_colors:(string, string option * string option * string) Hashtbl.t ->
  param:param ->
  Buffer.t ->
  Input.token list -> unit
(** [ocaml_file buf tokens] makes HTML code that represents one source file
  of OCaml code. The name of the file is added as title, 
  depending on the parameters and is specified with the [filename] option.
*)

val begin_document : ?param:param -> Buffer.t -> string list -> unit
val end_document : ?param:param -> Buffer.t -> unit

val handle_file :
  ?keyword_colors:(string, string option * string option * string) Hashtbl.t ->
  ?param:param -> Buffer.t -> string -> unit
(** [handle_file buf srcfile] parse the given file [srcfile]
  and puts the HTML into [buf]. *)

val save_file : ?dir:string -> Buffer.t -> string -> unit
(** [save_file buf file] just saves the contents of buffer [buf]
  in the given [file]. *)

val ocaml_document :
  ?dir:string ->
  ?keyword_colors:(string, string option * string option * string) Hashtbl.t ->
  ?param:param -> string list -> string -> unit
(** [ocaml_document files file] parses the given OCaml [files]
  and make one complete HTML document that shows the contents of 
  these files. *)

end

module Output_latex :
sig
(* 
   Copyright 2004, 2010 Martin Jambon

   This module produces HTML code for the presentation of OCaml programs
   (.ml .mli .mll .mly).

   This file is distributed under the terms of the GNU Public License
   http://www.gnu.org/licenses/gpl.txt
*)

(* $Id: output_latex.mli 12 2010-06-28 18:18:41Z mjambon $ *)

type class_definition = (string list * (string * string) list)

val default_style : string

val key_color1 : string option
val key_color2 : string option
val key_color3 : string option
val key_color4 : string option
val key_color5 : string option
val construct_color : string option * string
val comment_color : string option * string
val string_color : string option * string
val alpha_keyword_color : string option * string
val nonalpha_keyword_color : string option * string

val default_keyword_color_list : 
  (string * (string option * string)) list
val default_keyword_colors : 
  (string, string option * string) Hashtbl.t
val all_colors : (string option * string) list
(** colors which are used for the predefined style.
  This is a list of pairs (optional color specification, CSS class). *)

val make_defs_file : 
  ?colors:(string option * string) list -> string -> unit
(** Dump color definitions and matching highlighting commands into a file. *)

type param = {
  line_numbers : bool;
  title : bool;
  body_only : bool;
  tab_size : int;
  latex_comments : bool;
  defs : string;
}
(** the type of the options for making the HTML document *)

val default_param : param

val ocaml :
  ?keyword_colors:(string, string option * string) Hashtbl.t ->
  ?param:param ->
  Buffer.t -> 
  Input.token list -> unit
(** [ocaml buf l] formats the list of tokens [l] into some LaTeX code
  which should be placed within the alltt environment,
  and adds the result the given buffer [buf]. *)

val ocaml_file :
  ?filename:string ->
  ?keyword_colors:(string, string option * string) Hashtbl.t ->
  param:param ->
  Buffer.t ->
  Input.token list -> unit
(** [ocaml_file buf tokens] makes LaTeX code that represents one source file
  of OCaml code. The name of the file is added as title, 
  depending on the parameters and is specified with the [filename] option.
*)

val begin_document : ?param:param -> Buffer.t -> string list -> unit
val end_document : ?param:param -> Buffer.t -> unit

val handle_file :
  ?keyword_colors:(string, string option * string) Hashtbl.t ->
  ?param:param -> Buffer.t -> string -> unit
(** [handle_file buf srcfile] parse the given file [srcfile]
  and puts the HTML into [buf]. *)

val save_file : ?dir:string -> Buffer.t -> string -> unit
(** [save_file buf file] just saves the contents of buffer [buf]
  in the given [file]. *)

val ocaml_document :
  ?dir:string ->
  ?keyword_colors:(string, string option * string) Hashtbl.t ->
  ?param:param -> string list -> string -> unit
(** [ocaml_document files file] parses the given OCaml [files]
  and make one complete HTML document that shows the contents of 
  these files. *)

end
