(* $Id: client.ml 182 2004-05-25 16:49:11Z gerd $
 * ----------------------------------------------------------------------
 *
 *)


let read_until_eof f =
  let b = Buffer.create 104 in
  try
    while true do
      Buffer.add_string b (input_line f)
    done;
    assert false
  with
      End_of_file ->
	Buffer.contents b
;;

let rwall hostname f =
  let s = read_until_eof f in
  let client =
    Rwall_clnt.WALLPROG.WALLVERS.create_portmapped_client hostname Rpc.Udp in
  Rwall_clnt.WALLPROG.WALLVERS.wallproc_wall client s;
  Rpc_client.shut_down client
;;



let main() =
  match Sys.argv with
      [| _; hostname; filename |] ->
	let f = open_in filename in
	rwall hostname f;
	close_in f
    | [| _; hostname |] ->
	rwall hostname stdin
    | _ ->
	prerr_endline "usage: rwall host [file]";
	exit(1)
;;


main();
exit(0)
;;
