/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifndef AUDIORINGBUFFER_HPP
#define AUDIORINGUBFFER_HPP

#include "RingBuffer.h"
#include "AudioSample.h"


class CAudioRingBufferReader: protected CRingBufferReader
{
private:
   const SoundAttributes *m_pSoundAttributes;
   CRingBuffer *m_pRing;

public:
   CAudioRingBufferReader(CRingBuffer *ring, const SoundAttributes *attr);

   SoundAttributes GetSoundAttributes() const;

   void SetLowWaterMark(SamplePos);
   SamplePos GetLowWaterMark() const;
   void SetHighWaterMark(SamplePos);
   SamplePos GetHighWaterMark() const;

   CAudioSample ReadFromTail(SamplePos length);
   CAudioSample ReadFromHead(SamplePos length, bool clear = false, unsigned long time = ULONG_MAX);
};

#endif
