#include <gnome.h>
#include "support.h"
#include "memory.h"

#include "custom_view.h"
#include "mp3info.h"
#include "queue.h"
#include "gui_queue.h"
#include "configfile.h"

/***************************************************************************************
 * BELOW FOLLOW THE STATICS
 ***************************************************************************************/

// Removes all items from haystack that have a filename AND directory that is in needle.
static GList *
g_list_remove_matching_filenames(GList *haystack, GList *needle)
{
	GList *haystack_item = NULL;
	GList *needle_item = NULL;
	Mp3Info *haystack_mp3info = NULL;
	Mp3Info *needle_mp3info = NULL;

	haystack_item = g_list_first(haystack);
	while(haystack_item)
	{
		haystack_mp3info = (Mp3Info *)haystack_item->data;
		haystack_item = g_list_next(haystack_item);
		
		needle_item = g_list_first(needle);
		while(needle_item)
		{
			needle_mp3info = (Mp3Info *)needle_item->data;
			needle_item = g_list_next(needle_item);
			if( strncmp(needle_mp3info->filename, haystack_mp3info->filename, 2048) == 0
				&& strncmp(needle_mp3info->directory, haystack_mp3info->directory, 2048) == 0 )
			{
				haystack = mem_free_1(haystack, haystack_mp3info);
				break;
			}
		}
	}
	return g_list_first(haystack);
}

/***************************************************************************************
 * END OF STATICS
 ***************************************************************************************/


void
custom_view_add(void)
{
	extern GtkWidget *custom_view;
	extern GtkWidget *cantus;
	extern GList *queue;
	extern Cfg cfg;
	GList *foundfiles = NULL;
	Mp3Info *mp3info = NULL;
	GtkCList *clist_custom_view_files = NULL;
	gint cur = -1;

	clist_custom_view_files = GTK_CLIST(lookup_widget(custom_view, "clist_custom_view_files"));
	
// set the column titles
	clist_set_titles(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), cfg.qcols);
	clist_set_titles(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), cfg.qcols);
	
	while( (mp3info = gtk_clist_get_row_data(clist_custom_view_files, ++cur)) )
		foundfiles = g_list_append(foundfiles, mp3info);

	foundfiles = g_list_remove_matching_filenames(foundfiles, queue);
	queue = g_list_concat(queue, foundfiles);
	
	clist_queue_add_files(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queue")), &foundfiles, cfg.qcols);
	clist_queue_add_files(GTK_CLIST(lookup_widget (cantus, "clist_cantus_queueonly_queue")), &foundfiles, cfg.qcols);

	gtk_widget_destroy(custom_view);
	return;
}
