/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "support.h"

#include "freedb.h"
#include "lib_freedb.h"
#include "gui_freedb.h"
#include "mp3info.h"


/*
 * Show a list of cds in the gui.
 */
void clist_album_choose_albums_add (GList * cdlist)
{
  extern GtkWidget * tracks_sort;
  GtkCList * albumlist = NULL;
  CDInfo * cd = NULL;
  GList * listitem = NULL;
  gchar * row[3];
  gint newrow = 0;
  
  albumlist = (GtkCList *)lookup_widget (tracks_sort, "clist_tracks_sort_cdlist");
  
  /* Parse through the cd list and add every album to the gui. */
  listitem = cdlist;
  while ( listitem ) {
    cd = (CDInfo *)listitem->data;
    
    /* Get the data from the stuct into an array. */
    row[0] = cd->cdtitle;
    row[1] = cd->genre;
    row[2] = malloc (9);
    snprintf (row[2], 9, "%08lx", cd->id);
    
    /* Append to the clist. */
    newrow = gtk_clist_append (albumlist, row);
    /* Attach the cd struct as data to the clist. */
    gtk_clist_set_row_data (albumlist, newrow, cd);
    
    g_free (row[2]);
    listitem = listitem->next;
  }
  
  /* Sort the list. */
  gtk_clist_sort (albumlist);
  gtk_clist_columns_autosize (albumlist);
  
  return;
}


/*
 * Show a list of tracks in the gui.
 */
void clist_tracks_sort_tracks_add (CDInfo * cd)
{
  extern GtkWidget * tracks_sort;
  GtkCList * tracklist = NULL;
  CDTrack * curtrack = NULL;
  gchar * rowdata[4];
  gint row = 0;
  gint newrow = 0;
  
  tracklist = (GtkCList *)lookup_widget (tracks_sort, "clist_tracks_sort_tracks");
  gtk_clist_clear (tracklist);
  
  row = -1;
  while ( cd->track[++row] ) {
    curtrack = (CDTrack *)cd->track[row];
    
    /* Put the track data into a struct. */
    rowdata[0] = curtrack->filename;
    rowdata[1] = strdup ("->");
    rowdata[2] = curtrack->number;
    rowdata[3] = curtrack->title;
    
    /* Append the track to the gui list. */
    newrow = gtk_clist_append (tracklist, rowdata);
    /* Attach the CD (not track) data to the row. */
    gtk_clist_set_row_data (tracklist, newrow, cd);
    
    g_free (rowdata[1]);
  }
  
  gtk_clist_columns_autosize (tracklist);
}


/*
 * Move all selected rows in the tracklist down 1 position.
 */
void clist_tracks_move_track_down (void)
{
  extern GtkWidget * tracks_sort;
  GtkCList * tracklist = NULL;
  CDInfo * cd = NULL;
  CDTrack * curtrack = NULL;
  CDTrack * nexttrack = NULL;
  GList * selection = NULL;
  gchar * trash = NULL;
  gint currow = 0;
  gchar title[2048];
  gchar number[20];
  
  tracklist = (GtkCList *)lookup_widget (tracks_sort, "clist_tracks_sort_tracks");
  
  /* Get the cd struct from the first row. */
  cd = (CDInfo *)gtk_clist_get_row_data (tracklist, 0);
  
  /* Swap each selected item with it's followed one (if one is present). */
  selection = tracklist->selection;
  while ( selection ) {
    currow = (gint)selection->data;
    
    /* If there are no items after the current one, we can't swap. */
    if ( !gtk_clist_get_text (tracklist, currow + 1, 2, &trash) ) {
      selection = selection->next;
      continue;
    }
    
    curtrack = (CDTrack*)cd->track[currow];
    nexttrack = (CDTrack*)cd->track[currow + 1];
    
    /* Swap the rows in the CD struct. We must only swap two of the fields (can't swap the pointer), */
    /* as the filename order doesn't change. */
    strncpy (title, curtrack->title, 2047);
    strncpy (number, curtrack->number, 19);
    
    strncpy (curtrack->title, nexttrack->title, 2047);
    strncpy (curtrack->number, nexttrack->number, 19);
    
    strncpy (nexttrack->title, title, 2047);
    strncpy (nexttrack->number, number, 19);
    
    /* Update the rows in the GUI. */
    gtk_clist_set_text (tracklist, currow, 2, curtrack->number);
    gtk_clist_set_text (tracklist, currow, 3, curtrack->title);
    gtk_clist_set_text (tracklist, currow + 1, 2, nexttrack->number);
    gtk_clist_set_text (tracklist, currow + 1, 3, nexttrack->title);
    gtk_clist_unselect_row (tracklist, currow, 0);
    gtk_clist_select_row (tracklist, currow + 1, 0);
    
    selection = selection->next;
  }
}


/*
 * Move all selected rows in the tracklist up 1 position.
 */
void clist_tracks_move_track_up (void)
{
  extern GtkWidget * tracks_sort;
  GtkCList * tracklist = NULL;
  CDInfo * cd = NULL;
  CDTrack * curtrack = NULL;
  CDTrack * prevtrack = NULL;
  GList * selection = NULL;
  gchar * trash = NULL;
  gint currow = 0;
  gchar title[2048];
  gchar number[20];
  
  tracklist = (GtkCList *)lookup_widget (tracks_sort, "clist_tracks_sort_tracks");
  
  /* Get the cd struct from the first row. */
  cd = (CDInfo *)gtk_clist_get_row_data (tracklist, 0);
  
  /* Swap each selected item with it's previous one (if one is present). */
  /* We're beginning with the list end. */
  selection = g_list_last (tracklist->selection);
  while ( selection ) {
    currow = (gint)selection->data;
    
    /* If there are no items before the current one, we can't swap. */
    if ( !gtk_clist_get_text (tracklist, currow - 1, 2, &trash) ) {
      selection = selection->next;
      continue;
    }
    
    curtrack = (CDTrack*)cd->track[currow];
    prevtrack = (CDTrack*)cd->track[currow - 1];
    
    /* Swap the rows in the CD struct. We must only swap two of the fields (can't swap the pointer), */
    /* as the filename order doesn't change. */
    strncpy (title, curtrack->title, 2047);
    strncpy (number, curtrack->number, 19);
    
    strncpy (curtrack->title, prevtrack->title, 2047);
    strncpy (curtrack->number, prevtrack->number, 19);
    
    strncpy (prevtrack->title, title, 2047);
    strncpy (prevtrack->number, number, 19);
    
    /* Update the rows in the GUI. */
    gtk_clist_set_text (tracklist, currow, 2, curtrack->number);
    gtk_clist_set_text (tracklist, currow, 3, curtrack->title);
    gtk_clist_set_text (tracklist, currow - 1, 2, prevtrack->number);
    gtk_clist_set_text (tracklist, currow - 1, 3, prevtrack->title);
    gtk_clist_unselect_row (tracklist, currow, 0);
    gtk_clist_select_row (tracklist, currow - 1, 0);
    
    selection = selection->prev;
  }
}
