#!/bin/sh
## This script generates a new potfile and re-builds all .mo files.
## Also, POTFILES.in will be re-generated.
##

# Ger a list of all files that are potentially holding translatable strings.
FILES=`find ../src/ ../src/ui-gtk2/ -name "*.cc" -o -name "*.c" -maxdepth 1`
FILES="$FILES `find ../src/ui-gtk2/libs -name "*.cc" -o -name "*.c"`"
FILES="$FILES `find ../src/plugins/ -name "*.cc" -o -name "*.c" -a ! -name lib_charset.[ch]`"
FILES="$FILES ../src/ui-gtk2/glade/strings.c"

# Re-generate (merge) the potfile.
touch cantus.pot
xgettext -jC -k"_" -k"N_" --from-code ISO-8859-1 -o cantus.pot $FILES \
 || exit 1

# Generate .mo files from all .po files.
find . -name "*.po" | while read POFILE; do
  MOFILE=`echo $POFILE | sed 's/\.po$/\.mo/'`
  msgfmt -o $MOFILE $POFILE || exit 1
done

# Generate a POTFILE.in file for intltool-update support.
echo GETTEXT_PACKAGE=cantus > ../configure.ac || exit 1
touch POTFILES.in                             || exit 1
intltool-update -m                            || exit 1
if [ -e missing ]; then
  mv missing POTFILES.in                      || exit 1
fi

rm ../configure.ac
