/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "editarea.h"

//#define _DEBUG_


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
Editarea::Editarea()
{
}


Editarea::~Editarea(void)
{
#ifdef _DEBUG_
  printf(EDITAREANAME "(): Editarea::~Editarea(): Called.\n");
#endif
}


/******************************************************************************
 * Public
 ******************************************************************************/
GtkWidget *Editarea::build(gboolean vertical)
{
  std::list<Gtk::Widget*> focuschain;
  Gtk::Table          *top    = NULL;
  Gtk::Label          *label  = NULL;
  Gtk::Entry          *entry  = NULL;
  Gtk::CheckButton    *check  = NULL;
  Gtk::Button         *button = NULL;
  Gtk::Fixed          *fixed  = NULL;
  Gtk::ScrolledWindow *scroll = NULL;
  Gtk::TextView       *text   = NULL;
  Gtk::AttachOptions   yfill  = vertical ? Gtk::FILL : Gtk::FILL|Gtk::EXPAND;
  // The main table.
  if (vertical)
    table = new Gtk::Table(9, 6);
  else
    table = new Gtk::Table(5, 10);
  table->set_row_spacings(3);
  table->set_col_spacings(5);
  table->set_border_width(5);
  table->set_col_spacing(1, 0);
  table->set_col_spacing(5, 0);
  
  // Labels, Entries and CheckButtons.
  label = new Gtk::Label(_("Artist"), 0, 0.5);
  table->attach(*label, 0, 1, 0, 1, Gtk::FILL, yfill, 0, 0);
  entry = new Gtk::Entry;
  widgets["Artist"] = entry;
  focuschain.push_back(entry);
  table->attach(*entry, 1, 6, 0, 1, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Artist:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 0, 1, Gtk::FILL, yfill);
  
  label = new Gtk::Label(_("Song"), 0, 0.5);
  table->attach(*label, 0, 1, 1, 2, Gtk::FILL, yfill);
  entry = new Gtk::Entry;
  widgets["Song"] = entry;
  focuschain.push_back(entry);
  table->attach(*entry, 1, 6, 1, 2, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Song:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 1, 2, Gtk::FILL, yfill);
  
  label = new Gtk::Label(_("Album"), 0, 0.5);
  table->attach(*label, 0, 1, 2, 3, Gtk::FILL, yfill);
  entry = new Gtk::Entry;
  widgets["Album"] = entry;
  focuschain.push_back(entry);
  table->attach(*entry, 1, 6, 2, 3, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Album:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 2, 3, Gtk::FILL, yfill);
  
  label = new Gtk::Label(_("Year"), 0, 0.5);
  table->attach(*label, 0, 1, 3, 4, Gtk::FILL, yfill);
  entry = new Gtk::Entry;
  widgets["Year"] = entry;
  focuschain.push_back(entry);
  table->attach(*entry, 1, 6, 3, 4, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Year:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 3, 4, Gtk::FILL, yfill);
  
  label = new Gtk::Label(_("Track"), 0, 0.5);
  table->attach(*label, 0, 1, 4, 5, Gtk::FILL, yfill);
  entry = new Gtk::Entry;
  entry->set_size_request(30, -1);
  widgets["Track"] = entry;
  focuschain.push_back(entry);
  table->attach(*entry, 1, 2, 4, 5, Gtk::FILL|Gtk::EXPAND, yfill);
  check = new Gtk::CheckButton;
  widgets["Track:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 2, 3, 4, 5, Gtk::FILL, yfill);
  
  label = new Gtk::Label(_("Genre"), 0, 0.5);
  table->attach(*label, 3, 4, 4, 5, Gtk::FILL, yfill);
  entry = new Gtk::Entry;
  entry->set_size_request(70, -1);
  widgets["Genre"] = entry;
  focuschain.push_back(entry);
  table->attach(*entry, 4, 5, 4, 5, Gtk::FILL | Gtk::EXPAND, yfill);
  button = new Gtk::Button("...");
  //FIXME:table->attach(*button, 5, 6, 4, 5, Gtk::FILL, yfill);
  check = new Gtk::CheckButton;
  widgets["Genre:Check"] = check;
  focuschain.push_back(check);
  table->attach(*check, 6, 7, 4, 5, Gtk::FILL, yfill);
  button->signal_clicked().connect(
                        SigC::slot(*this, &Editarea::on_button_genre_clicked));
  
  // The comment field.
  label = new Gtk::Label(_("Comment"), 0, 0.5);
  scroll = new Gtk::ScrolledWindow;
  scroll->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  scroll->set_shadow_type(Gtk::SHADOW_IN);
  text = new Gtk::TextView;
  widgets["Comment"] = text;
  focuschain.push_back(text);
  scroll->add(*text);
  check = new Gtk::CheckButton;
  widgets["Comment:Check"] = check;
  focuschain.push_back(check);
  if (vertical) {
    table->attach(*label, 0, 6, 7, 8, Gtk::FILL|Gtk::EXPAND, Gtk::FILL);
    table->attach(*check, 6, 7, 7, 8, Gtk::FILL, Gtk::FILL, 0, 0);
    table->attach(*scroll, 0, 7, 8, 9, Gtk::FILL|Gtk::EXPAND, Gtk::FILL);
  }
  else {
    table->attach(*label, 7, 8, 0, 1, Gtk::FILL|Gtk::EXPAND, Gtk::FILL);
    table->attach(*check, 8, 9, 0, 1, Gtk::FILL, Gtk::FILL, 0, 0);
    table->attach(*scroll, 7, 9, 1, 5, Gtk::FILL|Gtk::EXPAND, Gtk::FILL);
  }
  
  // Some distance between the fields and the buttons.
  fixed = new Gtk::Fixed;
  fixed->set_size_request(0, -1);
  if (vertical)
    table->attach(*fixed, 0, 7, 8, 9, Gtk::FILL, Gtk::FILL|Gtk::EXPAND);
  else
    table->attach(*fixed, 9, 10, 0, 5, Gtk::FILL, Gtk::FILL);
  
  // Buttons
  if (vertical) {
    hvbox = new Gtk::HBox;
    hvbox->set_spacing(6);
    hvbox->set_border_width(3);
    table->attach(*hvbox, 0, 7, 9, 10, Gtk::FILL, Gtk::FILL);
    // Vertical boxes should have something expanding benath the buttons to make
    // them right-aligned.
    fixed = new Gtk::Fixed;
    hvbox->pack_start(*fixed, TRUE, TRUE);
  }
  else {
    hvbox = new Gtk::VBox;
    hvbox->set_spacing(6);
    table->attach(*hvbox, 10, 11, 0, 5, Gtk::FILL, Gtk::FILL);
  }
  
  button = new Gtk::Button(Gtk::Stock::SAVE);
  button->set_size_request(-1, 35);
  if (vertical)
    hvbox->pack_end(*button, FALSE, TRUE);
  else
    hvbox->pack_start(*button, FALSE, TRUE);
  button->signal_clicked().connect(signal_button_save_clicked);
  
  button = new Gtk::Button(Gtk::Stock::CLEAR);
  button->set_size_request(-1, 35);
  hvbox->pack_start(*button, FALSE, TRUE);
  button->signal_clicked().connect(
                        SigC::slot(*this, &Editarea::on_button_clear_clicked));
  
  // A container table holding everything.
  top = new Gtk::Table(1, 1);
  top->attach(*table, 0, 1, 0, 1, Gtk::FILL|Gtk::EXPAND, Gtk::FILL|Gtk::EXPAND);
  top->show_all();
  
  // Set the focus chain.
  table->set_focus_chain(focuschain);
  
  return (GtkWidget*)Glib::unwrap(top);
}


Gtk::Widget *Editarea::get_widget(const gchar *widgetname)
{
  Gtk::Widget *widget = widgets[widgetname];
  if (!widget)
    g_warning("Editarea::get_widget(): Widget not found: %s\n", widgetname);
  g_assert(widget != NULL);
  return widget;
}


void Editarea::set_entry_text(const gchar *widgetname, const gchar *str)
{
#ifdef _DEBUG_
  printf("Editarea::~set_entry_text(): Called. (%s)\n", str);
#endif
  Gtk::Entry *entry = (Gtk::Entry*)get_widget(widgetname);
  entry->set_text(str ? str : "");
}


Glib::ustring Editarea::get_entry_text(const gchar *widgetname)
{
  Gtk::Entry *entry = (Gtk::Entry*)get_widget(widgetname);
  return entry->get_text();
}


void Editarea::set_textview_text(const gchar *widgetname, const gchar *str)
{
#ifdef _DEBUG_
  printf("Editarea::~set_textview_text(): Called. (%s)\n", str);
#endif
  Gtk::TextView *text = (Gtk::TextView*)get_widget(widgetname);
  text->get_buffer()->set_text(str);
}


Glib::ustring Editarea::get_textview_text(const gchar *widgetname)
{
#ifdef _DEBUG_
  printf("Editarea::~set_textview_text(): Called. (%s)\n", str);
#endif
  Gtk::TextView                *text   = (Gtk::TextView*)get_widget(widgetname);
  Glib::RefPtr<Gtk::TextBuffer> buffer = text->get_buffer();
  return buffer->get_text();
}


void Editarea::set_check_active(const gchar *widgetname, gboolean active)
{
  Gtk::CheckButton *check = (Gtk::CheckButton*)get_widget(widgetname);
  check->set_active(active);
}


gboolean Editarea::get_check_active(const gchar *widgetname)
{
  Gtk::CheckButton *check = (Gtk::CheckButton*)get_widget(widgetname);
  return check->get_active();
}


void Editarea::set_active(gboolean active)
{
  hvbox->set_sensitive(active);
}


/******************************************************************************
 * Private
 ******************************************************************************/
void Editarea::on_button_clear_clicked(void)
{
  Glib::ListHandle<Gtk::Widget*>           handle = table->get_children();
  Glib::ListHandle<Gtk::Widget*>::iterator iter   = handle.begin();
  while (iter != handle.end()) {
    Gtk::Entry *entry = dynamic_cast<Gtk::Entry*>(*iter);
    if (entry)                            // Handle entry boxes.
      entry->set_text("");
    iter++;
  }
  Gtk::TextView *textview = (Gtk::TextView*)get_widget("Comment");
  textview->get_buffer()->set_text("");
}


void Editarea::on_button_genre_clicked(void)
{
  printf("Genre selector not yet implemented.\n");
}
