/* The Cantus project.
 * (c)2002, 2003 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_GUI_GTKFILELIST_H
#define HAVE_GUI_GTKFILELIST_H

#include <iostream>
#include <gtkmm.h>
#include <gtkmm/treemodelsort.h>
#include <sys/stat.h>
#include <libintl.h>
#include <dirent.h>
#include <grp.h>
#include <pwd.h>
#include "../plugins/gnuhashmap.h"
#include "../libs/lib_shellpattern.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)


class GtkFileList : public Gtk::TreeView {
public:
  GtkFileList(void);
  ~GtkFileList(void);
  
  /* Jump to the given directory. Returns TRUE on success, otherwise FALSE.
   */
  bool set_directory(std::string dir);

  /* Specify a list of patterns that represent filenames to be shown in the
   * filelist.
   */
  void set_filepattern(const gchar **pfilepattern);
  
  /* Specify a comma-sperated list of patterns that represent filenames to be
   * shown in the filelist.
   */
  void set_filepattern(std::string str);
  
  /* Specify whether or not hidden files and directories should be visible.
   */
  void set_showhidden(gboolean show_hidden);
  
  /* Triggers a refresh of the current directory.
   * If "hard" is TRUE, the filelist is cleared and re-read (the selection is
   * lost).
   */
  void update(bool hard = FALSE);
  
  /* Returns a list of all selected filenames as a C-compatible GList.
   */
  GList *get_selection_glist(void);
  
protected:
  /* Called when the selection has changed.
   */
  void on_selection_changed(void);
  
  /* Helper function to create a GList of all selected filenames.
   */
  void glist_filename_append(const Gtk::TreeModel::iterator& iter,
                             GList **filelist);
  
  /* Helper function for iterating through the tree model. This function
   * checks if the given file does still exist and removes dead items from the
   * "in_list" list. Also, it appends the path to a list.
   */
  bool remove_if_dead(const Gtk::TreeIter& iter,
                      std::list<Gtk::TreeIter> *dead);
  
  /* Removes all dead files from the list.
   */
  void remove_dead(void);
  
  /* Re-reads all files and puts them into the list (if not already there).
   */
  void load(void);
  
  // List model columns.
  class ModelColumns : public Gtk::TreeModel::ColumnRecord {
  public:
    Gtk::TreeModelColumn<Glib::ustring> filename;
    Gtk::TreeModelColumn<Glib::ustring> size;
    Gtk::TreeModelColumn<Glib::ustring> mode;
    Gtk::TreeModelColumn<Glib::ustring> owner;
    Gtk::TreeModelColumn<Glib::ustring> fullfilename;
    
    ModelColumns() {
      add(filename);
      add(size);
      add(mode);
      add(owner);
      add(fullfilename);
    }
  };
  ModelColumns                   columns;         // The column model.
  Glib::RefPtr<Gtk::ListStore>   store;           // The filelist store.
  Glib::RefPtr<Gtk::TreeModelSort> sortstore;     // The sorting layer.
  std::string                    curdir;          // The current directory.
  bool                           blocked;         // Blocks signal_changed().
  const gchar                  **filepattern;     // An array of visible globs.
  std::string                    filepattern_str; // A comma-sep. list of globs.
  gboolean                       showhidden;      // Show hidden files?
                               // A hash of all files that are currently shown.
  __gnu_cxx::hash_set<std::string> in_list;
};

#endif
