/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gui_mainwindow.h"


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
/* Constructor.
 */
Mainwindow::Mainwindow()
{
  lockevents  = FALSE;
  pwindow     = NULL;
  filebrowser = NULL;
  pluginarea1 = NULL;
  pluginarea2 = NULL;
  aboutbox    = NULL;
}


/* Destructor.
 */
Mainwindow::~Mainwindow()
{
  if (filebrowser)
    delete filebrowser;
  if (pluginarea1)
    delete pluginarea1;
  if (pluginarea2)
    delete pluginarea2;
  if (aboutbox)
    delete aboutbox;
}


/******************************************************************************
 * Public
 ******************************************************************************/
/* Read the mainwindow's glade file into an xml tree.
 */
Gtk::Window *Mainwindow::create(void)
{
  // Load the Glade file and instantiate its widgets.
  try {
    refXml = Gnome::Glade::Xml::create(PACKAGE_LIB_DIR "cantus-3.glade",
                                       "mainwindow");
  }
  catch(const Gnome::Glade::XmlError & err) {
    std::cerr << err.what() << '\n';
    return(NULL);
  }
  
  // Get the Glade-instantiated Dialog.
  refXml->get_widget("mainwindow",  pwindow);
  refXml->get_widget("table_main",  table);
  refXml->get_widget("progressbar", progressbar);
  
  table->set_border_width(5);
  
  // Create a HPaned in the upper row of the table.
  hpaned = new Gtk::HPaned;
  table->attach(
             *hpaned, 0, 1, 0, 1, Gtk::FILL|Gtk::EXPAND, Gtk::FILL|Gtk::EXPAND);
  
  // Create a notebook in the left side of the hpaned.
  notebook = new Gtk::Notebook;
  notebook->set_show_tabs(FALSE);
  notebook->set_show_border(FALSE);
  hpaned->pack1(*notebook, Gtk::FILL|Gtk::EXPAND);
  
  // Create the filebrowser in the notebook.
  filebrowser = new FileBrowser;
  notebook->append_page(*filebrowser, _("Browser"));
  
  // Pluginarea1
  pluginarea1 = new PluginArea(TRUE);
  pluginarea1->set_size_request(350, -1);
  pluginarea1->show();
  hpaned->pack2(*pluginarea1, Gtk::FILL);
  
  // Pluginarea2
  pluginarea2 = new PluginArea(FALSE);
  table->attach(*pluginarea2, 0, 1, 1, 2, Gtk::FILL, Gtk::FILL, 0, 0);
  pluginarea2->set_size_request(-1, 200);
  
  hpaned->set_position(200000);
  table->show_all();
  
  aboutbox = new AboutBox;
  aboutbox->create();
  
  connect_signals();
  
  return(pwindow);
}


/* Connect all signals to the mainwindow callbacks.
 */
void Mainwindow::connect_signals(void)
{
  g_return_if_fail(pwindow != NULL);
  
  Gtk::MenuItem *widget = NULL;
  
  // File menu.
  refXml->get_widget("menu_file_quit", widget);
  widget->signal_activate().connect(
            SigC::slot(*pwindow, &Gtk::Window::hide));
  refXml->get_widget("menu_file_save", widget);
  widget->signal_activate().connect(signal_menu_file_save_activate);
  
  // View menu.
  refXml->get_widget("menu_view_pluginarea1", widget);
  widget->signal_activate().connect(
            SigC::slot(*this, &Mainwindow::on_menu_view_pluginarea1_activate));
  refXml->get_widget("menu_view_pluginarea2", widget);
  widget->signal_activate().connect(
            SigC::slot(*this, &Mainwindow::on_menu_view_pluginarea2_activate));
  
  // Edit Menu.
  refXml->get_widget("menu_edit_preferences", widget);
  widget->signal_activate().connect(signal_menu_edit_preferences_activate);
  
  // Help menu.
  refXml->get_widget("menu_help_contents", widget);
  widget->signal_activate().connect(
            SigC::slot(*this, &Mainwindow::on_menu_help_contents_activate));
  refXml->get_widget("menu_help_about", widget);
  widget->signal_activate().connect(
            SigC::slot(*this, &Mainwindow::on_menu_help_about_activate));
  
  filebrowser->signal_filelist_selection_changed.connect(
                                        signal_filebrowser_selection_changed);
  pluginarea1->signal_widget_removed.connect(signal_pluginarea_widget_removed);
  pluginarea2->signal_widget_removed.connect(signal_pluginarea_widget_removed);
}


void Mainwindow::pluginarea_update(std::list<Plugin*> *plugins)
{
  pluginarea1->plugins_set(plugins);
  pluginarea2->plugins_set(plugins);
}


void Mainwindow::set_progress(double percent)
{
  progressbar->set_fraction(percent);
}


/* Make the pluginarea visible or invisible. */
void Mainwindow::pluginarea1_set_active(gboolean active)
{
  if (active == pluginarea1->is_visible())
    return;
  if (active) {
    table->remove(*notebook);
    table->attach(*hpaned, 0, 1, 0, 1, Gtk::FILL|Gtk::EXPAND,
                                       Gtk::FILL|Gtk::EXPAND);
    hpaned->add1(*notebook);
    pluginarea1->show();
  }
  else {
    pluginarea1->hide();
    hpaned->remove(*notebook);
    table->remove(*hpaned);
    table->attach(*notebook, 0, 1, 0, 1, Gtk::FILL|Gtk::EXPAND,
                                         Gtk::FILL|Gtk::EXPAND);
  }
  Gtk::CheckMenuItem *widget = NULL;
  lockevents = TRUE;
  refXml->get_widget("menu_view_pluginarea1", widget)->set_active(active);
  lockevents = FALSE;
  signal_pluginarea1_visibility_changed.emit(active);
}


/* Make the pluginarea visible or invisible. */
void Mainwindow::pluginarea2_set_active(gboolean active)
{
  if (active == pluginarea2->is_visible())
    return;
  if (active) {
    table->resize(2, 1);
    table->attach(*pluginarea2, 0, 1, 1, 2, Gtk::FILL, Gtk::FILL);
    pluginarea2->show();
  }
  else {
    pluginarea2->hide();
    table->remove(*pluginarea2);
    table->resize(1, 1);
  }
  Gtk::CheckMenuItem *widget = NULL;
  lockevents = TRUE;
  refXml->get_widget("menu_view_pluginarea2", widget)->set_active(active);
  lockevents = FALSE;
  signal_pluginarea2_visibility_changed.emit(active);
}


/******************************************************************************
 * Private
 ******************************************************************************/
void Mainwindow::on_menu_help_contents_activate(void)
{
  pid_t pid;
  if ((pid = fork()) == 0)	{
    execlp("gnome-help", "gnome-help", "ghelp:" GETTEXTPACKAGE);
    g_error(_("Cannot launch gnome-help"));
  }
}


void Mainwindow::on_menu_help_about_activate(void)
{
  g_return_if_fail(aboutbox != NULL);
  aboutbox->show();
}


void Mainwindow::on_menu_view_pluginarea1_activate(void)
{
  if (lockevents)
    return;
  pluginarea1_set_active(!pluginarea1->is_visible());
}


void Mainwindow::on_menu_view_pluginarea2_activate(void)
{
  if (lockevents)
    return;
  pluginarea2_set_active(!pluginarea2->is_visible());
}
