/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_MAINWINDOW_H
#define HAVE_MAINWINDOW_H

#include <iostream>
#include <gtkmm.h>
#include <libglademm.h>
#include <libintl.h>
#include <list>
#include "gui_filebrowser.h"
#include "gui_pluginarea.h"
#include "gui_aboutbox.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)


class Mainwindow : public SigC::Object {
public:
  Mainwindow();
  ~Mainwindow();
  
  /* Triggered whenever the filebrowser selection changed.
   * The GList contains a list of all filenames currently selected.
   * Warning: The GList is only valid for the duration of the signal.
   */
  SigC::Signal1<void, GList*>   signal_filebrowser_selection_changed;
  /* Triggered whenever the "save" menu has been activated. */
  SigC::Signal0<void>           signal_menu_file_save_activate;
  /* Triggered whenever the "preferences" item has been clicked. */
  SigC::Signal0<void>           signal_menu_edit_preferences_activate;
  /* Triggered whenever the pluginarea1 visibility changed. */
  SigC::Signal1<void, gboolean> signal_pluginarea1_visibility_changed;
  /* Triggered whenever the pluginarea2 visibility changed. */
  SigC::Signal1<void, gboolean> signal_pluginarea2_visibility_changed;
  /* Triggered whenever a widget has been removed from any pluginarea. */
  SigC::Signal1<void, Plugin*>  signal_pluginarea_widget_removed;
  
  /* Builds the complete mainwindow. */
  Gtk::Window *create(void);
  
  /* Update the plugins to be shown in the pluginarea. */
  void pluginarea_update(std::list<Plugin*> *plugins);
  
  /* Updates the progressbar. */
  void set_progress(double percent);
  
  /* Make the pluginarea visible or invisible. */
  void pluginarea1_set_active(gboolean active);
  
  /* Make the pluginarea visible or invisible. */
  void pluginarea2_set_active(gboolean active);
  
  FileBrowser *filebrowser;
  
private:
  void connect_signals(void);
  void on_menu_help_contents_activate(void);
  void on_menu_help_about_activate(void);
  void on_menu_view_pluginarea1_activate(void);
  void on_menu_view_pluginarea2_activate(void);
  
  Glib::RefPtr<Gnome::Glade::Xml> refXml;
  
  gboolean           lockevents;
  Gtk::Window       *pwindow;
  Gtk::Viewport     *viewport;
  Gtk::Table        *table;
  Gtk::ProgressBar  *progressbar;
  Gtk::HPaned       *hpaned;
  Gtk::Notebook     *notebook;
  PluginArea        *pluginarea1;
  PluginArea        *pluginarea2;
  AboutBox          *aboutbox;
};

#endif
