{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetAddress: string;
    procedure SetAddress(const Value: string);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetMulticastRelayHost: string;
    procedure SetMulticastRelayHost(const Value: string);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetRadioID: Integer;
    procedure SetRadioID(const Value: Integer);
    function GetReadInterval: Single;
    procedure SetReadInterval(const Value: Single);
    function GetReceivedPower: Single;
    procedure SetReceivedPower(const Value: Single);
    function GetReceiverState: Integer;
    procedure SetReceiverState(const Value: Integer);
    function GetRtpHeaderExpected: boolean;
    procedure SetRtpHeaderExpected(const Value: boolean);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTransmitterApplicationID: Integer;
    procedure SetTransmitterApplicationID(const Value: Integer);
    function GetTransmitterEntityID: Integer;
    procedure SetTransmitterEntityID(const Value: Integer);
    function GetTransmitterRadioID: Integer;
    procedure SetTransmitterRadioID(const Value: Integer);
    function GetTransmitterSiteID: Integer;
    procedure SetTransmitterSiteID(const Value: Integer);
    function GetWhichGeometry: Integer;
    procedure SetWhichGeometry(const Value: Integer);
    function GetWriteInterval: Single;
    procedure SetWriteInterval(const Value: Single);
    function GetBboxCenter: TVector3Single;
    procedure SetBboxCenter(const Value: TVector3Single);
    function GetBboxSize: TVector3Single;
    procedure SetBboxSize(const Value: TVector3Single);
  public
    property Address: string read GetAddress write SetAddress;
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;
    property EntityID: Integer read GetEntityID write SetEntityID;
    property MulticastRelayHost: string read GetMulticastRelayHost write SetMulticastRelayHost;
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;
    property Port: Integer read GetPort write SetPort;
    property RadioID: Integer read GetRadioID write SetRadioID;
    property ReadInterval: Single read GetReadInterval write SetReadInterval;
    property ReceivedPower: Single read GetReceivedPower write SetReceivedPower;
    property ReceiverState: Integer read GetReceiverState write SetReceiverState;
    property RtpHeaderExpected: boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;
    property SiteID: Integer read GetSiteID write SetSiteID;
    property TransmitterApplicationID: Integer read GetTransmitterApplicationID write SetTransmitterApplicationID;
    property TransmitterEntityID: Integer read GetTransmitterEntityID write SetTransmitterEntityID;
    property TransmitterRadioID: Integer read GetTransmitterRadioID write SetTransmitterRadioID;
    property TransmitterSiteID: Integer read GetTransmitterSiteID write SetTransmitterSiteID;
    property WhichGeometry: Integer read GetWhichGeometry write SetWhichGeometry;
    property WriteInterval: Single read GetWriteInterval write SetWriteInterval;
    property BboxCenter: TVector3Single read GetBboxCenter write SetBboxCenter;
    property BboxSize: TVector3Single read GetBboxSize write SetBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TReceiverPduNode ----------------------------------------------- }

function TReceiverPduNode.GetAddress: string;
begin
  Result := FdAddress.Value;
end;

procedure TReceiverPduNode.SetAddress(const Value: string);
begin
  FdAddress.Send(Value);
end;

function TReceiverPduNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TReceiverPduNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

function TReceiverPduNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TReceiverPduNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TReceiverPduNode.GetMulticastRelayHost: string;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TReceiverPduNode.SetMulticastRelayHost(const Value: string);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TReceiverPduNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TReceiverPduNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TReceiverPduNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TReceiverPduNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TReceiverPduNode.GetRadioID: Integer;
begin
  Result := FdRadioID.Value;
end;

procedure TReceiverPduNode.SetRadioID(const Value: Integer);
begin
  FdRadioID.Send(Value);
end;

function TReceiverPduNode.GetReadInterval: Single;
begin
  Result := FdReadInterval.Value;
end;

procedure TReceiverPduNode.SetReadInterval(const Value: Single);
begin
  FdReadInterval.Send(Value);
end;

function TReceiverPduNode.GetReceivedPower: Single;
begin
  Result := FdReceivedPower.Value;
end;

procedure TReceiverPduNode.SetReceivedPower(const Value: Single);
begin
  FdReceivedPower.Send(Value);
end;

function TReceiverPduNode.GetReceiverState: Integer;
begin
  Result := FdReceiverState.Value;
end;

procedure TReceiverPduNode.SetReceiverState(const Value: Integer);
begin
  FdReceiverState.Send(Value);
end;

function TReceiverPduNode.GetRtpHeaderExpected: boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TReceiverPduNode.SetRtpHeaderExpected(const Value: boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

function TReceiverPduNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TReceiverPduNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterApplicationID: Integer;
begin
  Result := FdTransmitterApplicationID.Value;
end;

procedure TReceiverPduNode.SetTransmitterApplicationID(const Value: Integer);
begin
  FdTransmitterApplicationID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterEntityID: Integer;
begin
  Result := FdTransmitterEntityID.Value;
end;

procedure TReceiverPduNode.SetTransmitterEntityID(const Value: Integer);
begin
  FdTransmitterEntityID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterRadioID: Integer;
begin
  Result := FdTransmitterRadioID.Value;
end;

procedure TReceiverPduNode.SetTransmitterRadioID(const Value: Integer);
begin
  FdTransmitterRadioID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterSiteID: Integer;
begin
  Result := FdTransmitterSiteID.Value;
end;

procedure TReceiverPduNode.SetTransmitterSiteID(const Value: Integer);
begin
  FdTransmitterSiteID.Send(Value);
end;

function TReceiverPduNode.GetWhichGeometry: Integer;
begin
  Result := FdWhichGeometry.Value;
end;

procedure TReceiverPduNode.SetWhichGeometry(const Value: Integer);
begin
  FdWhichGeometry.Send(Value);
end;

function TReceiverPduNode.GetWriteInterval: Single;
begin
  Result := FdWriteInterval.Value;
end;

procedure TReceiverPduNode.SetWriteInterval(const Value: Single);
begin
  FdWriteInterval.Send(Value);
end;

function TReceiverPduNode.GetBboxCenter: TVector3Single;
begin
  Result := FdBboxCenter.Value;
end;

procedure TReceiverPduNode.SetBboxCenter(const Value: TVector3Single);
begin
  FdBboxCenter.Send(Value);
end;

function TReceiverPduNode.GetBboxSize: TVector3Single;
begin
  Result := FdBboxSize.Value;
end;

procedure TReceiverPduNode.SetBboxSize(const Value: TVector3Single);
begin
  FdBboxSize.Send(Value);
end;

{$endif read_implementation}
