{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetLoop: boolean;
    procedure SetLoop(const Value: boolean);
    function GetPauseTime: TFloatTime;
    procedure SetPauseTime(const Value: TFloatTime);
    function GetResumeTime: TFloatTime;
    procedure SetResumeTime(const Value: TFloatTime);
    function GetStartTime: TFloatTime;
    procedure SetStartTime(const Value: TFloatTime);
    function GetStopTime: TFloatTime;
    procedure SetStopTime(const Value: TFloatTime);
  public
    property Loop: boolean read GetLoop write SetLoop;
    property PauseTime: TFloatTime read GetPauseTime write SetPauseTime;
    property ResumeTime: TFloatTime read GetResumeTime write SetResumeTime;
    property StartTime: TFloatTime read GetStartTime write SetStartTime;
    property StopTime: TFloatTime read GetStopTime write SetStopTime;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractTimeDependentNode ----------------------------------------------- }

function TAbstractTimeDependentNode.GetLoop: boolean;
begin
  Result := FdLoop.Value;
end;

procedure TAbstractTimeDependentNode.SetLoop(const Value: boolean);
begin
  FdLoop.Send(Value);
end;

function TAbstractTimeDependentNode.GetPauseTime: TFloatTime;
begin
  Result := FdPauseTime.Value;
end;

procedure TAbstractTimeDependentNode.SetPauseTime(const Value: TFloatTime);
begin
  FdPauseTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetResumeTime: TFloatTime;
begin
  Result := FdResumeTime.Value;
end;

procedure TAbstractTimeDependentNode.SetResumeTime(const Value: TFloatTime);
begin
  FdResumeTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetStartTime: TFloatTime;
begin
  Result := FdStartTime.Value;
end;

procedure TAbstractTimeDependentNode.SetStartTime(const Value: TFloatTime);
begin
  FdStartTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetStopTime: TFloatTime;
begin
  Result := FdStopTime.Value;
end;

procedure TAbstractTimeDependentNode.SetStopTime(const Value: TFloatTime);
begin
  FdStopTime.Send(Value);
end;

{$endif read_implementation}
