/* Site-specific code. Here parsing and more of this site is.
 * $Id: DigitalTheatre.pike,v 1.4 2001/01/28 08:45:12 neotron Exp $
 *
 * Written by David Hedbor <david@hedbor.org>.
 *
 */

import Headlines;

#include <headlines/base.h>
#include <headlines/RDF.h>

constant name = "digitaltheatre";
constant site = "Digital Theatre";
constant url  = "http://www.dtheatre.com/";
constant path  = "backend.php3?xml=yes";

constant names = ({ "title", "time" });
constant titles = ({" Application ", " Date " });

constant sub = "Computing/General";
array headlines;

string entry2txt(mapping hl)
{
  return sprintf("Program: %s\n"
		 "URL:     %s\n"
		 "Date:    %s\n\n",
		 hl->title||"None", HTTPFetcher()->encode(hl->url||""),
		 hl->time);
}

private static void parse_reply(string data)
{
  rdf_parse_reply(data);

  foreach(headlines, mapping hl) {
    array tmp = hl->url / "/";
    hl->time = ctime((int)tmp[-1])[4..23];
  }
}
