/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;

final class FieldInfos {
    private Vector byNumber = new Vector();
    private Hashtable byName = new Hashtable();

    FieldInfos() {
        this.add("", false);
    }

    FieldInfos(Directory directory, String string) throws IOException {
        InputStream inputStream = directory.openFile(string);
        try {
            this.read(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    final void add(Document document) {
        Enumeration enumeration = document.fields();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            this.add(field.name(), field.isIndexed());
        }
    }

    final void add(FieldInfos fieldInfos) {
        int n = 0;
        while (n < fieldInfos.size()) {
            FieldInfo fieldInfo = fieldInfos.fieldInfo(n);
            this.add(fieldInfo.name, fieldInfo.isIndexed);
            ++n;
        }
    }

    final void add(String string, boolean bl) {
        FieldInfo fieldInfo = this.fieldInfo(string);
        if (fieldInfo == null) {
            this.addInternal(string, bl);
        } else if (fieldInfo.isIndexed != bl) {
            fieldInfo.isIndexed = true;
        }
    }

    private final void addInternal(String string, boolean bl) {
        FieldInfo fieldInfo = new FieldInfo(string, bl, this.byNumber.size());
        this.byNumber.addElement(fieldInfo);
        this.byName.put(string, fieldInfo);
    }

    final int fieldNumber(String string) {
        FieldInfo fieldInfo = this.fieldInfo(string);
        if (fieldInfo != null) {
            return fieldInfo.number;
        }
        return -1;
    }

    final FieldInfo fieldInfo(String string) {
        return (FieldInfo)this.byName.get(string);
    }

    final String fieldName(int n) {
        return this.fieldInfo((int)n).name;
    }

    final FieldInfo fieldInfo(int n) {
        return (FieldInfo)this.byNumber.elementAt(n);
    }

    final int size() {
        return this.byNumber.size();
    }

    final void write(Directory directory, String string) throws IOException {
        OutputStream outputStream = directory.createFile(string);
        try {
            this.write(outputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    final void write(OutputStream outputStream) throws IOException {
        outputStream.writeVInt(this.size());
        int n = 0;
        while (n < this.size()) {
            FieldInfo fieldInfo = this.fieldInfo(n);
            outputStream.writeString(fieldInfo.name);
            outputStream.writeByte(fieldInfo.isIndexed ? (byte)1 : 0);
            ++n;
        }
    }

    private final void read(InputStream inputStream) throws IOException {
        int n = inputStream.readVInt();
        int n2 = 0;
        while (n2 < n) {
            this.addInternal(inputStream.readString().intern(), inputStream.readByte() != 0);
            ++n2;
        }
    }
}

