/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSInputStream;
import org.apache.lucene.store.FSOutputStream;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.util.Constants;

public final class FSDirectory
extends Directory {
    private static final Hashtable DIRECTORIES = new Hashtable();
    private File directory = null;
    private int refCount;

    public static FSDirectory getDirectory(String string, boolean bl) throws IOException {
        return FSDirectory.getDirectory(new File(string), bl);
    }

    public static FSDirectory getDirectory(File file, boolean bl) throws IOException {
        FSDirectory fSDirectory;
        file = new File(file.getCanonicalPath());
        Hashtable hashtable = DIRECTORIES;
        synchronized (hashtable) {
            fSDirectory = (FSDirectory)DIRECTORIES.get(file);
            if (fSDirectory == null) {
                fSDirectory = new FSDirectory(file, bl);
                DIRECTORIES.put(file, fSDirectory);
            } else if (bl) {
                fSDirectory.create();
            }
        }
        FSDirectory fSDirectory2 = fSDirectory;
        synchronized (fSDirectory2) {
            ++fSDirectory.refCount;
        }
        return fSDirectory;
    }

    private FSDirectory(File file, boolean bl) throws IOException {
        this.directory = file;
        if (bl) {
            this.create();
        }
        if (!this.directory.isDirectory()) {
            throw new IOException(file + " not a directory");
        }
    }

    private synchronized void create() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdir()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        String[] stringArray = this.directory.list();
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(this.directory, stringArray[n]);
            if (!file.delete()) {
                throw new IOException("couldn't delete " + stringArray[n]);
            }
            ++n;
        }
    }

    public final String[] list() throws IOException {
        return this.directory.list();
    }

    public final boolean fileExists(String string) throws IOException {
        File file = new File(this.directory, string);
        return file.exists();
    }

    public final long fileModified(String string) throws IOException {
        File file = new File(this.directory, string);
        return file.lastModified();
    }

    public static final long fileModified(File file, String string) throws IOException {
        File file2 = new File(file, string);
        return file2.lastModified();
    }

    public final long fileLength(String string) throws IOException {
        File file = new File(this.directory, string);
        return file.length();
    }

    public final void deleteFile(String string) throws IOException {
        File file = new File(this.directory, string);
        if (!file.delete()) {
            throw new IOException("couldn't delete " + string);
        }
    }

    public final synchronized void renameFile(String string, String string2) throws IOException {
        File file = new File(this.directory, string);
        File file2 = new File(this.directory, string2);
        if (file2.exists() && !file2.delete()) {
            throw new IOException("couldn't delete " + string2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException("couldn't rename " + string + " to " + string2);
        }
    }

    public final OutputStream createFile(String string) throws IOException {
        return new FSOutputStream(new File(this.directory, string));
    }

    public final InputStream openFile(String string) throws IOException {
        return new FSInputStream(new File(this.directory, string));
    }

    public final Lock makeLock(String string) {
        final File file = new File(this.directory, string);
        return new Lock(){

            public boolean obtain() throws IOException {
                if (Constants.JAVA_1_1) {
                    return true;
                }
                return file.createNewFile();
            }

            public void release() {
                if (Constants.JAVA_1_1) {
                    return;
                }
                file.delete();
            }

            public String toString() {
                return "Lock@" + file;
            }
        };
    }

    public final synchronized void close() throws IOException {
        if (--this.refCount <= 0) {
            Hashtable hashtable = DIRECTORIES;
            synchronized (hashtable) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public String toString() {
        return "FSDirectory@" + this.directory;
    }
}

