/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BaseJspListener;
import org.apache.jasper.compiler.BeanEndGenerator;
import org.apache.jasper.compiler.BeanGenerator;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.CharDataGenerator;
import org.apache.jasper.compiler.ClassDeclarationPhase;
import org.apache.jasper.compiler.CommentGenerator;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.DeclarationGenerator;
import org.apache.jasper.compiler.ExpressionGenerator;
import org.apache.jasper.compiler.FileDeclarationPhase;
import org.apache.jasper.compiler.ForwardGenerator;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.GetPropertyGenerator;
import org.apache.jasper.compiler.IncludeGenerator;
import org.apache.jasper.compiler.InfoGenerator;
import org.apache.jasper.compiler.InitMethodPhase;
import org.apache.jasper.compiler.JakartaCommentGenerator;
import org.apache.jasper.compiler.MappedCharDataGenerator;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.PluginGenerator;
import org.apache.jasper.compiler.ScriptletGenerator;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SetPropertyGenerator;
import org.apache.jasper.compiler.StaticInitializerPhase;
import org.apache.jasper.compiler.StoredCharDataGenerator;
import org.apache.jasper.compiler.TagBeginGenerator;
import org.apache.jasper.compiler.TagEndGenerator;
import org.apache.jasper.compiler.TagLibraries;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.compiler.TagPoolGenerator;
import org.apache.jasper.compiler.TagPoolManagerGenerator;

public class JspParseEventListener
extends BaseJspListener {
    private static CommentGenerator commentGenerator = new JakartaCommentGenerator();
    JspCompilationContext ctxt;
    String jspServletBase = Constants.JSP_SERVLET_BASE;
    String serviceMethodName = "_jspService";
    String servletContentType = "text/html";
    String extendsClass = "";
    Vector interfaces = new Vector();
    Vector imports = new Vector();
    String error = "";
    boolean genSessionVariable = true;
    boolean singleThreaded = false;
    boolean autoFlush = true;
    Vector generators = new Vector();
    BeanRepository beanInfo;
    int bufferSize = 8192;
    boolean languageDir = false;
    boolean extendsDir = false;
    boolean sessionDir = false;
    boolean bufferDir = false;
    boolean threadsafeDir = false;
    boolean errorpageDir = false;
    boolean iserrorpageDir = false;
    boolean infoDir = false;
    boolean autoFlushDir = false;
    boolean contentTypeDir = false;
    int stringId = 0;
    Vector vector = new Vector();
    String dataFile;
    TagLibraries libraries;
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;
    private Vector tagPools = new Vector();
    static final String languageStr = "language";
    static final String extendsStr = "extends";
    static final String importStr = "import";
    static final String sessionStr = "session";
    static final String bufferStr = "buffer";
    static final String autoFlushStr = "autoFlush";
    static final String isThreadSafeStr = "isThreadSafe";
    static final String infoStr = "info";
    static final String errorPageStr = "errorPage";
    static final String isErrorPageStr = "isErrorPage";
    static final String contentTypeStr = "contentType";
    PageDirectiveHandlerInfo[] pdhis = new PageDirectiveHandlerInfo[]{new PageDirectiveHandlerInfo("language", new LanguageHandler()), new PageDirectiveHandlerInfo("extends", new ExtendsHandler()), new PageDirectiveHandlerInfo("import", new ImportsHandler()), new PageDirectiveHandlerInfo("session", new SessionHandler()), new PageDirectiveHandlerInfo("buffer", new BufferHandler()), new PageDirectiveHandlerInfo("autoFlush", new AutoFlushHandler()), new PageDirectiveHandlerInfo("isThreadSafe", new IsThreadSafeHandler()), new PageDirectiveHandlerInfo("info", new InfoHandler()), new PageDirectiveHandlerInfo("isErrorPage", new IsErrorPageHandler()), new PageDirectiveHandlerInfo("contentType", new ContentTypeHandler()), new PageDirectiveHandlerInfo("errorPage", new ErrorPageHandler())};
    static /* synthetic */ Class class$org$apache$jasper$compiler$ServiceMethodPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$FileDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$ClassDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$StaticInitializerPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$InitMethodPhase;

    final void addGenerator(Generator gen) throws JasperException {
        gen.init(this.ctxt);
        this.generators.addElement(gen);
    }

    public static void setCommentGenerator(CommentGenerator generator) {
        if (null == commentGenerator) {
            throw new IllegalArgumentException("null == generator");
        }
        commentGenerator = generator;
    }

    JspParseEventListener(JspCompilationContext ctxt) {
        super(ctxt.getReader(), ctxt.getWriter());
        this.ctxt = ctxt;
        this.beanInfo = new BeanRepository(ctxt.getClassLoader());
        this.libraries = new TagLibraries(ctxt.getClassLoader());
        if (ctxt.getOptions().getLargeFile()) {
            this.dataFile = ctxt.getOutputDir() + File.separatorChar + ctxt.getServletPackageName() + "_" + ctxt.getServletClassName() + ".dat";
        }
    }

    public void beginPageProcessing() throws JasperException {
        for (int i = 0; i < Constants.STANDARD_IMPORTS.length; ++i) {
            this.imports.addElement(Constants.STANDARD_IMPORTS[i]);
        }
    }

    public void endPageProcessing() throws JasperException {
        this.generateHeader();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ServiceMethodPhase == null ? (class$org$apache$jasper$compiler$ServiceMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ServiceMethodPhase")) : class$org$apache$jasper$compiler$ServiceMethodPhase);
        this.writer.println();
        this.generateFooter();
        if (this.ctxt.getOptions().getLargeFile()) {
            try {
                ObjectOutputStream o = new ObjectOutputStream(new FileOutputStream(this.dataFile));
                char[][] tempCharArray = new char[this.vector.size()][];
                this.vector.copyInto((Object[])tempCharArray);
                o.writeObject(tempCharArray);
                o.close();
                this.writer.close();
            }
            catch (IOException ex) {
                throw new JasperException(Constants.getString("jsp.error.data.file.write"), ex);
            }
        }
        this.ctxt.setContentType(this.servletContentType);
    }

    private Stack getTagHandlerStack() {
        if (this.tagHandlerStack == null) {
            this.tagHandlerStack = new Stack();
        }
        return this.tagHandlerStack;
    }

    private Hashtable getTagVarNumbers() {
        if (this.tagVarNumbers == null) {
            this.tagVarNumbers = new Hashtable();
        }
        return this.tagVarNumbers;
    }

    private void generateAll(Class phase) throws JasperException {
        for (int i = 0; i < this.generators.size(); ++i) {
            Generator gen = (Generator)this.generators.elementAt(i);
            if (!phase.isInstance(gen)) continue;
            gen.generate(this.writer, phase);
        }
    }

    private void generateHeader() throws JasperException {
        String servletPackageName = this.ctxt.getServletPackageName();
        String servletClassName = this.ctxt.getServletClassName();
        if (!"".equals(servletPackageName) && servletPackageName != null) {
            this.writer.println("package " + servletPackageName + ";");
            this.writer.println();
        }
        Enumeration e = this.imports.elements();
        while (e.hasMoreElements()) {
            this.writer.println("import " + (String)e.nextElement() + ";");
        }
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$FileDeclarationPhase == null ? (class$org$apache$jasper$compiler$FileDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.FileDeclarationPhase")) : class$org$apache$jasper$compiler$FileDeclarationPhase);
        this.writer.println();
        this.writer.print("public class " + servletClassName + " extends ");
        this.writer.print(this.extendsClass.equals("") ? this.jspServletBase : this.extendsClass);
        if (this.singleThreaded) {
            this.interfaces.addElement("SingleThreadModel");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.println("     implements ");
            for (int i = 0; i < this.interfaces.size() - 1; ++i) {
                this.writer.println(" " + this.interfaces.elementAt(i) + ",");
            }
            this.writer.println(" " + this.interfaces.elementAt(this.interfaces.size() - 1));
        }
        this.writer.println(" {");
        this.writer.pushIndent();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ClassDeclarationPhase == null ? (class$org$apache$jasper$compiler$ClassDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ClassDeclarationPhase")) : class$org$apache$jasper$compiler$ClassDeclarationPhase);
        this.writer.println();
        this.writer.println("static {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$StaticInitializerPhase == null ? (class$org$apache$jasper$compiler$StaticInitializerPhase = JspParseEventListener.class$("org.apache.jasper.compiler.StaticInitializerPhase")) : class$org$apache$jasper$compiler$StaticInitializerPhase);
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("public " + servletClassName + "( ) {");
        this.writer.println("}");
        this.writer.println();
        this.writer.println("private boolean _jspx_inited = false;");
        this.writer.println();
        this.writer.println("public final synchronized void _jspx_init() throws org.apache.jasper.JasperException {");
        this.writer.pushIndent();
        this.writer.println("if (! _jspx_inited) {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$InitMethodPhase == null ? (class$org$apache$jasper$compiler$InitMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.InitMethodPhase")) : class$org$apache$jasper$compiler$InitMethodPhase);
        this.writer.println("_jspx_inited = true;");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public void " + this.serviceMethodName + "(" + "HttpServletRequest request, " + "HttpServletResponse  response)");
        this.writer.println("    throws java.io.IOException, ServletException {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("JspFactory _jspxFactory = null;");
        this.writer.println("PageContext pageContext = null;");
        if (this.genSessionVariable) {
            this.writer.println("HttpSession session = null;");
        }
        if (this.ctxt.isErrorPage()) {
            this.writer.println("Throwable exception = (Throwable) request.getAttribute(\"javax.servlet.jsp.jspException\");");
        }
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("JspWriter out = null;");
        this.writer.println("Object page = this;");
        this.writer.println("String  _value = null;");
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("_jspx_init();");
        this.writer.println("_jspxFactory = JspFactory.getDefaultFactory();");
        if (this.contentTypeDir) {
            this.writer.println("response.setContentType(" + this.writer.quoteString(this.servletContentType) + ");");
        } else {
            this.writer.println("response.setContentType(\"" + this.servletContentType + ";charset=ISO-8859-1\");");
        }
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response,");
        this.writer.println("\t\t\t" + this.writer.quoteString(this.error) + ", " + this.genSessionVariable + ", " + this.bufferSize + ", " + this.autoFlush + ");");
        this.writer.println();
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        if (this.genSessionVariable) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("out = pageContext.getOut();");
    }

    private void generateFooter() throws JasperException {
        this.writer.popIndent();
        this.writer.println("} catch (Exception ex) {");
        this.writer.pushIndent();
        this.writer.println("if (out != null && out.getBufferSize() != 0)");
        this.writer.pushIndent();
        this.writer.println("out.clearBuffer();");
        this.writer.popIndent();
        this.writer.println("if (pageContext != null) pageContext.handlePageException(ex);");
        this.writer.popIndent();
        this.writer.println("} catch (Error error) {");
        this.writer.pushIndent();
        this.writer.println("throw error;");
        this.writer.popIndent();
        this.writer.println("} catch (Throwable throwable) {");
        this.writer.pushIndent();
        this.writer.println("throw new ServletException(throwable);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("} finally {");
        this.writer.pushIndent();
        this.writer.println("if (out instanceof " + Constants.JSP_RUNTIME_PACKAGE + ".JspWriterImpl) { ");
        this.writer.println("    ((" + Constants.JSP_RUNTIME_PACKAGE + ".JspWriterImpl)out).flushBuffer();");
        this.writer.println("}");
        this.writer.println("if (_jspxFactory != null) _jspxFactory.releasePageContext(pageContext);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
    }

    public void handleComment(Mark start, Mark stop) throws JasperException {
        Constants.message("jsp.message.htmlcomment", new Object[]{this.reader.getChars(start, stop)}, 4);
    }

    public void handleDirective(String directive, Mark start, Mark stop, Hashtable attrs) throws JasperException {
        Constants.message("jsp.message.handling_directive", new Object[]{directive, attrs}, 4);
        if (directive.equals("page")) {
            Enumeration e = attrs.keys();
            while (e.hasMoreElements()) {
                String attr = (String)e.nextElement();
                for (int i = 0; i < this.pdhis.length; ++i) {
                    PageDirectiveHandlerInfo pdhi = this.pdhis[i];
                    if (!attr.equals(pdhi.attribute)) continue;
                    String value = (String)attrs.get(pdhi.attribute);
                    pdhi.handler.handlePageDirectiveAttribute(this, value, start, stop);
                }
            }
        }
        if (this.bufferSize == 0 && !this.autoFlush) {
            throw new CompileException(start, Constants.getString("jsp.error.page.bad_b_and_a_combo"));
        }
        if (directive.equals("taglib")) {
            String uri = (String)attrs.get("uri");
            String prefix = (String)attrs.get("prefix");
            try {
                TagLibraryInfoImpl tl = new TagLibraryInfoImpl(this.ctxt, prefix, uri);
                this.libraries.addTagLibrary(prefix, tl);
            }
            catch (Exception ex) {
                Object[] args = new Object[]{uri, ex.getMessage()};
                throw new CompileException(start, Constants.getString("jsp.error.badtaglib", args));
            }
        }
        if (directive.equals("include")) {
            String file = (String)attrs.get("file");
            if (file == null) {
                throw new CompileException(start, Constants.getString("jsp.error.include.missing.file"));
            }
            try {
                this.reader.pushFile(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new CompileException(start, Constants.getString("jsp.error.include.bad.file"));
            }
        }
    }

    public void handleDeclaration(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new DeclarationGenerator(this.reader.getChars(start, stop)), start, stop);
        this.addGenerator(gen);
    }

    public void handleScriptlet(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ScriptletGenerator(this.reader.getChars(start, stop)), start, stop);
        this.addGenerator(gen);
    }

    public void handleExpression(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ExpressionGenerator(this.reader.getChars(start, stop)), start, stop);
        this.addGenerator(gen);
    }

    public void handleBean(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new BeanGenerator(start, attrs, this.beanInfo, this.genSessionVariable), start, stop);
        this.addGenerator(gen);
    }

    public void handleBeanEnd(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new BeanEndGenerator(), start, stop);
        this.addGenerator(gen);
    }

    public void handleGetProperty(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new GetPropertyGenerator(start, stop, attrs, this.beanInfo), start, stop);
        this.addGenerator(gen);
    }

    public void handleSetProperty(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new SetPropertyGenerator(start, stop, attrs, this.beanInfo), start, stop);
        this.addGenerator(gen);
    }

    public void handlePlugin(Mark start, Mark stop, Hashtable attrs, Hashtable param, String fallback) throws JasperException {
        Constants.message("jsp.message.handling_plugin", new Object[]{attrs}, 4);
        GeneratorWrapper gen = new GeneratorWrapper(new PluginGenerator(start, attrs, param, fallback), start, stop);
        this.addGenerator(gen);
    }

    public void handleForward(Mark start, Mark stop, Hashtable attrs, Hashtable param) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ForwardGenerator(start, attrs, param), start, stop);
        this.addGenerator(gen);
    }

    public void handleInclude(Mark start, Mark stop, Hashtable attrs, Hashtable param) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new IncludeGenerator(start, attrs, param), start, stop);
        this.addGenerator(gen);
    }

    public void handleCharData(Mark start, Mark stop, char[] chars) throws JasperException {
        GeneratorBase cdg = this.ctxt.getOptions().getLargeFile() ? new StoredCharDataGenerator(this.vector, this.dataFile, this.stringId++, chars) : (this.ctxt.getOptions().getMappedFile() ? new MappedCharDataGenerator(chars) : new CharDataGenerator(chars));
        GeneratorWrapper gen = new GeneratorWrapper(cdg, start, stop);
        this.addGenerator(gen);
    }

    public void handleTagBegin(Mark start, Mark stop, Hashtable attrs, String prefix, String shortTagName, TagLibraryInfo tli, TagInfo ti) throws JasperException {
        String tagPoolVarName;
        TagBeginGenerator tbg = new TagBeginGenerator(start, prefix, shortTagName, attrs, tli, ti, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers());
        GeneratorWrapper gen = new GeneratorWrapper(tbg, start, stop);
        this.addGenerator(gen);
        if (this.tagPools.size() == 0) {
            this.addGenerator(new TagPoolManagerGenerator());
        }
        if (!this.tagPools.contains(tagPoolVarName = TagPoolGenerator.getPoolName(tli, ti, attrs))) {
            this.tagPools.addElement(tagPoolVarName);
            TagPoolGenerator tpg = new TagPoolGenerator(prefix, shortTagName, attrs, tli, ti);
            gen = new GeneratorWrapper(tpg, start, stop);
            this.addGenerator(gen);
        }
    }

    public void handleTagEnd(Mark start, Mark stop, String prefix, String shortTagName, Hashtable attrs, TagLibraryInfo tli, TagInfo ti) throws JasperException {
        TagEndGenerator teg = new TagEndGenerator(prefix, shortTagName, attrs, tli, ti, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers());
        GeneratorWrapper gen = new GeneratorWrapper(teg, start, stop);
        this.addGenerator(gen);
    }

    public TagLibraries getTagLibraries() {
        return this.libraries;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class GeneratorWrapper
    implements Generator,
    ClassDeclarationPhase,
    FileDeclarationPhase,
    ServiceMethodPhase,
    InitMethodPhase,
    StaticInitializerPhase {
        Generator generator;
        Mark start;
        Mark stop;

        GeneratorWrapper(Generator generator, Mark start, Mark stop) {
            this.generator = generator;
            this.start = start;
            this.stop = stop;
        }

        public boolean generateCoordinates(Class phase) {
            return this.generator.generateCoordinates(phase);
        }

        public void init(JspCompilationContext ctxt) throws JasperException {
            this.generator.init(ctxt);
        }

        public void generate(ServletWriter out, Class phase) throws JasperException {
            if (phase.isInstance(this.generator)) {
                boolean genCoords = this.generator.generateCoordinates(phase);
                if (genCoords) {
                    commentGenerator.generateStartComment(this.generator, out, this.start, this.stop);
                }
                this.generator.generate(out, phase);
                if (genCoords) {
                    commentGenerator.generateEndComment(this.generator, out, this.start, this.stop);
                }
            }
        }
    }

    static final class ExtendsHandler
    implements PageDirectiveHandler {
        ExtendsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String extendsClzz, Mark start, Mark stop) throws JasperException {
            if (listener.extendsDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.extends"));
            }
            listener.extendsDir = true;
            if (extendsClzz != null) {
                listener.extendsClass = extendsClzz;
                if (extendsClzz.indexOf(".") == -1) {
                    listener.imports.addElement(extendsClzz);
                }
            }
        }
    }

    static final class ImportsHandler
    implements PageDirectiveHandler {
        ImportsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String importPkgs, Mark start, Mark stop) throws JasperException {
            if (importPkgs != null) {
                StringTokenizer tokenizer = new StringTokenizer(importPkgs, ",");
                while (tokenizer.hasMoreTokens()) {
                    listener.imports.addElement(tokenizer.nextToken());
                }
            }
        }
    }

    static final class LanguageHandler
    implements PageDirectiveHandler {
        LanguageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String language, Mark start, Mark stop) throws JasperException {
            if (listener.languageDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.language"));
            }
            listener.languageDir = true;
            if (language != null && !language.equalsIgnoreCase("java")) {
                throw new CompileException(start, Constants.getString("jsp.error.page.nomapping.language") + language);
            }
        }
    }

    static final class ErrorPageHandler
    implements PageDirectiveHandler {
        ErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String errorpage, Mark start, Mark stop) throws JasperException {
            if (listener.errorpageDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.errorpage"));
            }
            listener.errorpageDir = true;
            if (errorpage != null) {
                listener.error = errorpage;
            }
        }
    }

    static final class IsErrorPageHandler
    implements PageDirectiveHandler {
        IsErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String iserrorpage, Mark start, Mark stop) throws JasperException {
            if (listener.iserrorpageDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.iserrorpage"));
            }
            listener.iserrorpageDir = true;
            if (iserrorpage == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
            if (iserrorpage.equalsIgnoreCase("true")) {
                listener.ctxt.setErrorPage(true);
            } else if (iserrorpage.equalsIgnoreCase("false")) {
                listener.ctxt.setErrorPage(false);
            } else {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
        }
    }

    static final class InfoHandler
    implements PageDirectiveHandler {
        InfoHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String info, Mark start, Mark stop) throws JasperException {
            if (listener.infoDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.info"));
            }
            listener.infoDir = true;
            if (info == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.info"));
            }
            JspParseEventListener jspParseEventListener = listener;
            jspParseEventListener.getClass();
            GeneratorWrapper gen = jspParseEventListener.new GeneratorWrapper(new InfoGenerator(info), start, stop);
            listener.addGenerator(gen);
        }
    }

    static final class IsThreadSafeHandler
    implements PageDirectiveHandler {
        IsThreadSafeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String threadsafe, Mark start, Mark stop) throws JasperException {
            if (listener.threadsafeDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.threadsafe"));
            }
            listener.threadsafeDir = true;
            if (threadsafe == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
            if (threadsafe.equalsIgnoreCase("true")) {
                listener.singleThreaded = false;
            } else if (threadsafe.equalsIgnoreCase("false")) {
                listener.singleThreaded = true;
            } else {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
        }
    }

    static final class AutoFlushHandler
    implements PageDirectiveHandler {
        AutoFlushHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String autoflush, Mark start, Mark stop) throws JasperException {
            if (listener.autoFlushDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.autoflush"));
            }
            listener.autoFlushDir = true;
            if (autoflush == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.autoflush"));
            }
            if (autoflush.equalsIgnoreCase("true")) {
                listener.autoFlush = true;
            } else if (autoflush.equalsIgnoreCase("false")) {
                listener.autoFlush = false;
            } else {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.autoflush"));
            }
        }
    }

    static final class BufferHandler
    implements PageDirectiveHandler {
        BufferHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String buffer, Mark start, Mark stop) throws JasperException {
            if (listener.bufferDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.buffer"));
            }
            listener.bufferDir = true;
            if (buffer != null) {
                if (buffer.equalsIgnoreCase("none")) {
                    listener.bufferSize = 0;
                } else {
                    Integer i = null;
                    try {
                        int ind = buffer.indexOf("k");
                        String num = ind == -1 ? buffer : buffer.substring(0, ind);
                        i = new Integer(num);
                    }
                    catch (NumberFormatException n) {
                        throw new CompileException(start, Constants.getString("jsp.error.page.invalid.buffer"));
                    }
                    listener.bufferSize = i * 1024;
                }
            } else {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.buffer"));
            }
        }
    }

    static final class SessionHandler
    implements PageDirectiveHandler {
        SessionHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String session, Mark start, Mark stop) throws JasperException {
            if (listener.sessionDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.session"));
            }
            listener.sessionDir = true;
            if (session == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.session"));
            }
            if (session.equalsIgnoreCase("true")) {
                listener.genSessionVariable = true;
            } else if (session.equalsIgnoreCase("false")) {
                listener.genSessionVariable = false;
            } else {
                throw new CompileException(start, "Invalid value for session");
            }
        }
    }

    static final class ContentTypeHandler
    implements PageDirectiveHandler {
        ContentTypeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String contentType, Mark start, Mark stop) throws JasperException {
            if (listener.contentTypeDir) {
                throw new CompileException(start, Constants.getString("jsp.error.page.multiple.contenttypes"));
            }
            listener.contentTypeDir = true;
            if (contentType == null) {
                throw new CompileException(start, Constants.getString("jsp.error.page.invalid.contenttype"));
            }
            listener.servletContentType = contentType;
        }
    }

    static final class PageDirectiveHandlerInfo {
        String attribute;
        PageDirectiveHandler handler;

        PageDirectiveHandlerInfo(String attribute, PageDirectiveHandler handler) {
            this.attribute = attribute;
            this.handler = handler;
        }
    }

    static interface PageDirectiveHandler {
        public void handlePageDirectiveAttribute(JspParseEventListener var1, String var2, Mark var3, Mark var4) throws JasperException;
    }
}

