/*******************************************************************\

Module: ANSI-C Language Conversion

Author: Daniel Kroening, kroening@kroening.com

\*******************************************************************/

#ifndef CPROVER_ANSI_C_CONVERT_TYPE_H
#define CPROVER_ANSI_C_CONVERT_TYPE_H

#include <util/message_stream.h>

#include "c_types.h"
#include "c_qualifiers.h"
#include "c_storage_spec.h"

class ansi_c_convert_typet:public message_streamt
{
public:
  unsigned unsigned_cnt, signed_cnt, char_cnt,
           int_cnt, short_cnt, long_cnt,
           double_cnt, float_cnt, c_bool_cnt,
           proper_bool_cnt, complex_cnt;
  
  // extensions
  unsigned int8_cnt, int16_cnt, int32_cnt, int64_cnt,
           ptr32_cnt, ptr64_cnt,
           gcc_float128_cnt, gcc_int128_cnt, bv_cnt, bv_width,
           floatbv_cnt, mantissa_width;
  bool gcc_mode_QI, gcc_mode_HI, gcc_mode_SI, gcc_mode_DI, gcc_mode_TI;
           
  bool packed, aligned;
  exprt vector_size, alignment;

  // storage spec
  c_storage_spect c_storage_spec;
       
  // qualifiers
  c_qualifierst c_qualifiers;

  void read(const typet &type);
  void write(typet &type);
  
  locationt location;
  
  std::list<typet> other;
  
  ansi_c_convert_typet(message_handlert &_message_handler):
    message_streamt(_message_handler)
  {
  }
  
  void clear()
  {
    unsigned_cnt=signed_cnt=char_cnt=int_cnt=short_cnt=
    long_cnt=double_cnt=float_cnt=c_bool_cnt=proper_bool_cnt=complex_cnt=
    int8_cnt=int16_cnt=int32_cnt=int64_cnt=
    ptr32_cnt=ptr64_cnt=
    gcc_float128_cnt=gcc_int128_cnt=bv_cnt=floatbv_cnt=0;
    vector_size.make_nil();
    alignment.make_nil();
    bv_width=0;
    gcc_mode_QI=gcc_mode_HI=gcc_mode_SI=gcc_mode_DI=gcc_mode_TI=false;
    
    packed=aligned=false;

    other.clear();
    c_storage_spec.clear();
    c_qualifiers.clear();
  }
  
protected:
  void read_rec(const typet &type);
};

#endif
