#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "pinyin.h"

PinYin pytab[26][MAX_EACH_PY];
char hztab[MAX_PY_NUM][MAX_EACH_HZ]; 

int LoadTable(char* pathname)
{
  FILE *stream;
  char str[250],strpy[15],strhz[241];
  int i=1, j=0, lastpy=0, curpy;

  if ( (stream = fopen( pathname, "r" )) == NULL )
  {
    fprintf(stderr,"%s file not found\n",pathname);
    exit(1);
  }

  while ( !feof( stream ))
  {
    if ( fgets(str,250,stream) != NULL)
    {
      sscanf(str,"%s %s",strpy,strhz);
      strcpy( hztab[i],strhz);

      curpy = strpy[0]-'a';
      if (curpy != lastpy) j = 0;
      strcpy( pytab[curpy][j].py,strpy);
      pytab[curpy][j].key = i;
      lastpy = curpy;

      i++,j++;
    }
  }
  fclose(stream);
  return 0;
}

int PrintOutPhrase(char *infile,char *pathname)
{
  FILE *out,*in;
  u_char len;
  u_char key[MAX_PHRASE_LEN+1],str[2*MAX_PHRASE_LEN+1],
           tmppy[10],pinyin[70];
  char tab='\011',*p;
  int i,j,k,size,l,m,fsize;
  u_char freq;
  Phrase *p0;
  u_short count,keyint,keytmp;
  char *file;

  if ( (out = fopen( pathname, "wb" )) == NULL )
  {
    fprintf(stderr,"%s cant open.\n",pathname);
    exit(1);
  }

  if ( (in = fopen( infile, "rb" )) == NULL )
  {
    fprintf(stderr,"%s cant open.\n",infile);
    exit(1);
  }

  if (fseek(in,-4,SEEK_END) == -1 ||
      fread(&fsize,sizeof(int),1,in) != 1 ||
      fsize != ftell(in))   // error!!
  {
      fprintf(stderr,"%s is not a valid pinyin phrase file.\n",infile);
      exit(1);
  }

  if ( (file = (char*)malloc(fsize)) == NULL)
  {
       fprintf(stderr,"Not enough memory!\n");
       exit(1);
  }

  fseek(in,0,SEEK_SET);
  fread(file,fsize,1,in);

  p = file;
  for(i = 1; i < MAX_PY_NUM; i++)
  {
     count = *(u_short *)p;
     p += sizeof(u_short);
     if (count == 0) continue;

     for(j = 0; j < count; j++)
     {
         p0 = (Phrase *)p; 
         len = p0->len;
         pinyin[0] = '\0';  
 	 for(k=0; k<len; k++)
         {
	    keyint = (u_short)p0->key[0];
	    keyint = (keyint<<(8-k)) & 0x0100;
	    keyint += (u_short)p0->key[k+1];
	    for(l=0; l<26; l++)
	      for(m=0; keytmp=pytab[l][m].key; m++)
	        if (keyint == keytmp)
                {
		   sprintf(tmppy,"%s ",pytab[l][m].py);
                   break;
                }
            strcat(pinyin,tmppy);
	 }

         for(k = 0; k < p0->count; k++)
         {
             memcpy(str,p0->key+len+1+(2*len+1)*k,2*len);
             str[2*len] = '\0';
             freq = p0->key[len+1+(2*len+1)*k+2*len];
             if (len > 1)  // single char ignored
             fprintf(out,"%s %s %d\n",str,pinyin,freq);
         }
         p += 2+len+1+(2*len+1)*p0->count;
     }
  } // MAX_PY

  fclose(in);
  fclose(out);
  return 1;
}

int main(int argc,char **argv)
{
  if (argc != 3) 
  {
    fprintf(stderr,"usage: %s <input_name> <output_name>\n",argv[0]);
    return 1;
  }
  LoadTable("./pinyin.map");
  PrintOutPhrase(argv[1],argv[2]);

  return 0;  // no error
}
