/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _MCVISCBNDRY_H_
#define _MCVISCBNDRY_H_

#include <MCInterpBndryData.H>
#include <BC_TYPES.H>

class MCViscBndry : public MCInterpBndryData
{
public:
    MCViscBndry() : MCInterpBndryData()  {}

    MCViscBndry(const BoxArray& _grids, const Geometry& geom) :
#if BL_SPACEDIM == 2
        MCInterpBndryData(_grids,4,geom) {};
#elif BL_SPACEDIM == 3
        MCInterpBndryData(_grids,3*(1+3),geom) {};
#endif

    virtual void setBndryConds (const BCRec& phys_bc,
                                int          ratio,
                                int          comp=0);
    void setHomogValues();
};

#endif
