# About the Cooperative Computing Tools

The [Cooperating Computing Tools (CCTools)](index.md) help you to design
and deploy scalable applications that run on hundreds or thousands
of machines at once.  If you have a large quantity of computational
work to accomplish that would take years to complete on your laptop,
then you have come to the right place.

<img src="https://github.com/cooperative-computing-lab/makeflow-examples/raw/master/banner.png" width=100%>

If you are a first-time user, start by checking out the 
[Makeflow workflow system](../makeflow), and use it to get your work
organized into a regular graph.  You can test it on your laptop,
and when you are ready, throw the switch to dispatch jobs to
your account University campus cluster, a national supercomputing site,
or a commercial cloud.

For more advanced dynamic applications, take a look at the 
the [Work Queue framework](../work_queue), which can be used to construct
applications that consist of many asynchronous tasks running across
multiple distributed systems.  WQ has been used to build custom genome assemblers, ensemble molecular simulators, data analysis systems, and more.

This software is used by a broad community of people in multiple fields,
including high energy physics, molecular dynamics, bioinformatics,
astronomy, economics, digital humanities, and more.  We have an active
mailing list and issue tracker, and we regularly interact with our users
at annual meetings.  It is production-ready: we have
a regular engineering process, automated builds, and distribution through
packaging channels such as Conda and Spack.

CCTools is published by the [Cooperative Computing Lab](http://ccl.cse.nd.edu) at the [University of Notre Dame](http://www.nd.edu/~dthain).
We are a research group funded by the National Science Foundation and
the Department of Energy to design, evaluate, and deploy software systems
that enable new discoveries in many fields of science and engineering.
We thrive on helping people to succeed, so if you have a challenging
problem or just want to exchange ideas, then please [get in touch](help.md) --
we are eager to work with you.

This work has been sponsored in part by the National Science Foundation via grants OAC-1931348 (CSSI 2019-2022), OAC-1642409 (SI2 2016-2019), OAC-1148330 (SI2 2013-2016), and CNS-0453229 (CAREER 2007-2012)

This software is Copyright (C) 2019- The University of Notre Dame.  The software is distributed unt the GNU General Public License V2.  See the file COPYING for details.
