
static char *InfoHelp[] = {
    "NAME",
    "    info, infov, map - Information and simple statistics",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles",
    "",
    "DESCRIPTION",
    "    This module writes information about the structure and contents ",
    "    of all input datasets to standard output. The information displayed ",
    "    depends on the chosen operator.",
    "",
    "OPERATORS",
    "    info   Dataset information listed by code number",
    "           Prints information and simple statistics for each field of all",
    "           input datasets. For each field the operator prints one line with the following elements:",
    "           - Date and Time",
    "           - Code number and Level",
    "           - Size of the grid and number of Missing values",
    "           - Minimum, Mean and Maximum \\",
    "           The mean value is computed without the use of area weights!",
    "    infov  Dataset information listed by variable name",
    "           The same as operator info but using the name instead of the code",
    "           number to identify the variables.",
    "    map    Dataset information and simple map",
    "           Prints information, simple statistics and a map for each field of all input",
    "           datasets. The map will be printed only for fields on a regular lon/lat grid.",
    NULL
};

static char *SinfoHelp[] = {
    "NAME",
    "    sinfo, sinfov, sinfop - Short information",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles",
    "",
    "DESCRIPTION",
    "    This module writes information about the structure of all input datasets to ",
    "    standard output. The information displayed depends on the chosen operator.",
    "",
    "OPERATORS",
    "    sinfo   Short dataset information listed by code number",
    "            Prints short information of a dataset. The information is divided into",
    "            4 sections. Section 1 prints one line per variable with the following information:",
    "            - institute and source",
    "            - parameter table and code number",
    "            - horizontal grid size and number",
    "            - number of vertical levels and z-axis number",
    "            Section 2 and 3 gives a short overview of all horizontal and vertical grids.",
    "            And the last section contains short information of the time axis.",
    "    sinfov  Short dataset information listed by variable name",
    "            The same as operator sinfo but using the name instead of the code number",
    "            and parameter table to identify the variables.",
    NULL
};

static char *DiffHelp[] = {
    "NAME",
    "    diff, diffv - Compare two datasets field by field",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2",
    "",
    "DESCRIPTION",
    "    Compares the contents of two datasets field by field. The input",
    "    datasets need to have the same structure and its fields need to have ",
    "    the same header information and dimensions.",
    "",
    "OPERATORS",
    "    diff   Compare two datasets listed by code number",
    "           Provides statistics on differences between two datasets.",
    "           For each pair of fields the operator prints one line with the following information:",
    "           - Date and Time",
    "           - Code number and Level",
    "           - Size of the grid and number of Missing values",
    "           - Occurrence of coefficient pairs with different signs (S)",
    "           - Occurrence of zero values (Z)",
    "           - Maxima of absolute difference of coefficient pairs",
    "           - Maxima of relative difference of non-zero coefficient pairs with equal signs",
    "    diffv  Compare two datasets listed by variable name",
    "           The same as operator diff. Using the name instead of the code number",
    "           to identify the variable.",
    NULL
};

static char *NinfoHelp[] = {
    "NAME",
    "    npar, nlevel, nyear, nmon, ndate, ntime - ",
    "    Print the number of parameters, levels or times",
    "",
    "SYNOPSIS",
    "    <operator>  ifile",
    "",
    "DESCRIPTION",
    "    This module prints the number of variables, levels or times of the ",
    "    input dataset.",
    "",
    "OPERATORS",
    "    npar    Number of parameters",
    "            Prints the number of parameters (variables).",
    "    nlevel  Number of levels",
    "            Prints the number of levels for each variable.",
    "    nyear   Number of years",
    "            Prints the number of different years.",
    "    nmon    Number of months",
    "            Prints the number of different combinations of years and months.",
    "    ndate   Number of dates",
    "            Prints the number of different dates.",
    "    ntime   Number of time steps",
    "            Prints the number of time steps.",
    NULL
};

static char *ShowinfoHelp[] = {
    "NAME",
    "    showformat, showcode, showname, showstdname, showlevel, showltype, showyear, ",
    "    showmon, showdate, showtime, showtimestamp - Show variables, levels or times",
    "",
    "SYNOPSIS",
    "    <operator>  ifile",
    "",
    "DESCRIPTION",
    "    This module prints the format, variables, levels or times of the input dataset.",
    "",
    "OPERATORS",
    "    showformat     Show file format",
    "                   Prints the file format of the input dataset.",
    "    showcode       Show code numbers",
    "                   Prints the code number of all variables.",
    "    showname       Show variable names",
    "                   Prints the name of all variables.",
    "    showstdname    Show standard names",
    "                   Prints the standard name of all variables.",
    "    showlevel      Show levels",
    "                   Prints all levels for each variable.",
    "    showltype      Show GRIB level types",
    "                   Prints the GRIB level type for all z-axes.",
    "    showyear       Show years",
    "                   Prints all years.",
    "    showmon        Show months",
    "                   Prints all months.",
    "    showdate       Show date information",
    "                   Prints date information of all time steps (format YYYY-MM-DD).",
    "    showtime       Show time information",
    "                   Prints time information of all time steps (format hh:mm:ss).",
    "    showtimestamp  Show timestamp",
    "                   Prints timestamp of all time steps (format YYYY-MM-DDThh:mm:ss).",
    NULL
};

static char *FiledesHelp[] = {
    "NAME",
    "    pardes, griddes, zaxisdes, vct - Dataset description",
    "",
    "SYNOPSIS",
    "    <operator>  ifile",
    "",
    "DESCRIPTION",
    "    This module prints the description of the parameters, the grids,",
    "    the z-axis or the vertical coordinate table.",
    "",
    "OPERATORS",
    "    pardes    Parameter description",
    "              Prints a table with a description of all variables.",
    "              For each variable the operator prints one line listing the",
    "              code, name, description and units.",
    "    griddes   Grid description",
    "              Prints the description of all grids.",
    "    zaxisdes  Z-axis description",
    "              Prints the description of all z-axes.",
    "    vct       Vertical coordinate table",
    "              Prints the vertical coordinate table.",
    NULL
};

static char *CopyHelp[] = {
    "NAME",
    "    copy, cat - Copy datasets",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators to copy or concatenate datasets. Each input",
    "    dataset is required to have the same variables with complete time steps.",
    "",
    "OPERATORS",
    "    copy  Copy datasets",
    "          Copies all input datasets to ofile. ",
    "    cat   Concatenate datasets",
    "          Concatenates all input datasets and appends the result to the end ",
    "          of ofile. If ofile does not exist it will be created.",
    NULL
};

static char *ReplaceHelp[] = {
    "NAME",
    "    replace - Replace variables",
    "",
    "SYNOPSIS",
    "    replace  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Replaces all common variables of ifile2 and ifile1 with those of ifile1",
    "    and write the result to ofile.",
    "    Both input datasets need to have the same number of time steps.",
    NULL
};

static char *MergeHelp[] = {
    "NAME",
    "    merge, mergetime - Merge datasets",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This module reads datasets from several input files,",
    "    merges them and writes the resulting dataset to ofile.",
    "",
    "OPERATORS",
    "    merge      Merge datasets with different fields",
    "               Merges time series of different fields from several input datasets.",
    "               The number of fields per time step written to ofile",
    "               is the sum of the field numbers per time step in all input datasets.",
    "               The time series on all input datasets are required to have different",
    "               fields and the same number of time steps.",
    "    mergetime  Merge datasets sorted by date and time",
    "               Merges all time steps of all input files sorted by date and time.",
    "               After this operation every input time step is in ofile and",
    "               all time steps are sorted by date and time. Each input file is ",
    "               required to have the same variables and different time steps.",
    NULL
};

static char *SplitHelp[] = {
    "NAME",
    "    splitcode, splitname, splitlevel, splitgrid, splitzaxis, splittabnum - ",
    "    Split a dataset",
    "",
    "SYNOPSIS",
    "    <operator>  ifile oprefix",
    "",
    "DESCRIPTION",
    "    This module splits a dataset to several files with names",
    "    formed from the field header information and the string oprefix.",
    "",
    "OPERATORS",
    "    splitcode    Split code numbers",
    "                 Splits a dataset into pieces, one for each different code number.",
    "                 Appends three digits with the code number to oprefix to ",
    "                 form the output file names.",
    "    splitname    Split variable names",
    "                 Splits a dataset into pieces, one for each variable name.",
    "                 Appends a string with the variable name to oprefix to ",
    "                 form the output file names.",
    "    splitlevel   Split levels",
    "                 Splits a dataset into pieces, one for each different level.",
    "                 Appends six digits with the level to oprefix to ",
    "                 form the output file names.",
    "    splitgrid    Split grids",
    "                 Splits a dataset into pieces, one for each different grid.",
    "                 Appends two digits with the grid number to oprefix to ",
    "                 form the output file names.",
    "    splitzaxis   Split z-axes",
    "                 Splits a dataset into pieces, one for each different z-axis.",
    "                 Appends two digits with the z-axis number to oprefix to ",
    "                 form the output file names.",
    "    splittabnum  Split parameter table numbers",
    "                 Splits a dataset into pieces, one for each GRIB1 parameter table number.",
    "                 Appends three digits with the table number to oprefix to ",
    "                 form the output file names.",
    NULL
};

static char *SplittimeHelp[] = {
    "NAME",
    "    splithour, splitday, splitmon, splitseas, splityear - ",
    "    Split time steps of a dataset",
    "",
    "SYNOPSIS",
    "    <operator>  ifile oprefix",
    "",
    "DESCRIPTION",
    "    This module splits time steps of a dataset to several files with names",
    "    formed from the field header information and the string  oprefix.",
    "",
    "OPERATORS",
    "    splithour  Split hours",
    "               Splits a file into pieces, one for each different hour.",
    "               Appends two digits with the hour to oprefix to ",
    "               form the output file names.",
    "    splitday   Split days",
    "               Splits a file into pieces, one for each different day.",
    "               Appends two digits with the day to oprefix to ",
    "               form the output file names.",
    "    splitmon   Split months",
    "               Splits a file into pieces, one for each different month.",
    "               Appends two digits with the month to oprefix to ",
    "               form the output file names.",
    "    splitseas  Split seasons",
    "               Splits a file into pieces, one for each different season.",
    "               Appends three characters with the season to oprefix to ",
    "               form the output file names.",
    "    splityear  Split years",
    "               Splits a file into pieces, one for each different year.",
    "               Appends four digits with the year to oprefix to ",
    "               form the output file names.",
    NULL
};

static char *SplitselHelp[] = {
    "NAME",
    "    splitsel - Split selected time steps",
    "",
    "SYNOPSIS",
    "    splitsel,nsets[,noffset[,nskip]]  ifile oprefix",
    "",
    "DESCRIPTION",
    "    This operator splits a dataset into pieces, one for each adjacent",
    "    sequence t1, ...., tn of time steps of the same selected time range.",
    "    Appends six digits with the sequence number to oprefix to ",
    "    form the output file names.",
    "",
    "PARAMETER",
    "    nsets    INTEGER  Number of input time steps for each output file",
    "    noffset  INTEGER  Number of input time steps skipped before the first time step range (optional)",
    "    nskip    INTEGER  Number of input time steps skipped between time step ranges (optional)",
    NULL
};

static char *SelvarHelp[] = {
    "NAME",
    "    selcode, delcode, selname, delname, selstdname, sellevel, sellevidx, selgrid, ",
    "    selzaxis, selltype, seltabnum - Select fields",
    "",
    "SYNOPSIS",
    "    selcode,codes  ifile ofile",
    "    delcode,codes  ifile ofile",
    "    selname,varnames  ifile ofile",
    "    delname,varnames  ifile ofile",
    "    selstdname,stdnames  ifile ofile",
    "    sellevel,levels  ifile ofile",
    "    sellevidx,levidx  ifile ofile",
    "    selgrid,grids  ifile ofile",
    "    selzaxis,zaxes  ifile ofile",
    "    selltype,ltypes  ifile ofile",
    "    seltabnum,tabnums  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module selects some fields from ifile and writes them to ofile.",
    "    The fields selected depend on the chosen operator and the parameters.",
    "",
    "OPERATORS",
    "    selcode     Select variables by code number",
    "                Selects all fields with code numbers in a user given list.",
    "    delcode     Delete variables by code number",
    "                Deletes all fields with code numbers in a user given list.",
    "    selname     Select variables by name",
    "                Selects all fields with variable names in a user given list.",
    "    delname     Delete variables by name",
    "                Deletes all fields with variable names in a user given list.",
    "    selstdname  Select variables by standard name",
    "                Selects all fields with standard names in a user given list.",
    "    sellevel    Select levels",
    "                Selects all fields with levels in a user given list.",
    "    sellevidx   Select levels by index",
    "                Selects all fields with index of levels in a user given list.",
    "    selgrid     Select grids",
    "                Selects all fields with grids in a user given list.",
    "    selzaxis    Select z-axes",
    "                Selects all fields with z-axes in a user given list.",
    "    selltype    Select GRIB level types",
    "                Selects all fields with GRIB level type in a user given list.",
    "    seltabnum   Select parameter table numbers",
    "                Selects all fields with parameter table numbers in a user given list.",
    "",
    "PARAMETER",
    "    codes     INTEGER  Comma separated list of code numbers",
    "    varnames  STRING   Comma separated list of variable names",
    "    stdnames  STRING   Comma separated list of standard names",
    "    levels    FLOAT    Comma separated list of levels",
    "    levidx    INTEGER  Comma separated list of index of levels",
    "    ltypes    INTEGER  Comma separated list of GRIB level types",
    "    grids     STRING   Comma separated list of grid names or numbers",
    "    zaxes     STRING   Comma separated list of z-axis names or numbers",
    "    tabnums   INTEGER  Comma separated list of parameter table numbers",
    NULL
};

static char *SeltimeHelp[] = {
    "NAME",
    "    seltimestep, seltime, selhour, selday, selmon, selyear, selseas, seldate, ",
    "    selsmon - Select time steps",
    "",
    "SYNOPSIS",
    "    seltimestep,timesteps  ifile ofile",
    "    seltime,times  ifile ofile",
    "    selhour,hours  ifile ofile",
    "    selday,days  ifile ofile",
    "    selmon,months  ifile ofile",
    "    selyear,years  ifile ofile",
    "    selseas,seasons  ifile ofile",
    "    seldate,date1[,date2]  ifile ofile",
    "    selsmon,month[,nts1[,nts2]]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module selects user specified time steps from ifile and writes them to ofile.",
    "    The time steps selected depends on the chosen operator and the parameters.",
    "",
    "OPERATORS",
    "    seltimestep  Select time steps",
    "                 Selects all time steps with a time step in a user given list.",
    "    seltime      Select times",
    "                 Selects all time steps with a time in a user given list.",
    "    selhour      Select hours",
    "                 Selects all time steps with a hour in a user given list.",
    "    selday       Select days",
    "                 Selects all time steps with a day in a user given list.",
    "    selmon       Select months",
    "                 Selects all time steps with a month in a user given list.",
    "    selyear      Select years",
    "                 Selects all time steps with a year in a user given list.",
    "    selseas      Select seasons",
    "                 Selects all time steps with a month of a season in a user given list.",
    "    seldate      Select dates",
    "                 Selects all time steps with a date in a user given range.",
    "    selsmon      Select single month",
    "                 Selects a month and optional an unlimited number of time steps before and after this month.",
    "",
    "PARAMETER",
    "    timesteps  INTEGER  Comma separated list of time steps",
    "    times      STRING   Comma separated list of times (format hh:mm:ss)",
    "    hours      INTEGER  Comma separated list of hours",
    "    days       INTEGER  Comma separated list of days",
    "    months     INTEGER  Comma separated list of months",
    "    years      INTEGER  Comma separated list of years",
    "    seasons    STRING   Comma separated list of seasons (DJF, MAM, JJA, SON)",
    "    date1      STRING   Start date (format YYYY-MM-DDThh:mm:ss)",
    "    date2      STRING   End date (format YYYY-MM-DDThh:mm:ss)",
    "    nts1       INTEGER  Number of time steps before the selected month [default: 0]",
    "    nts2       INTEGER  Number of time steps after the selected month [default: nts1]",
    NULL
};

static char *SelboxHelp[] = {
    "NAME",
    "    sellonlatbox, selindexbox - Select a box of a field",
    "",
    "SYNOPSIS",
    "    sellonlatbox,lon1,lon2,lat1,lat2  ifile ofile",
    "    selindexbox,idx1,idx2,idy1,idy2  ifile ofile",
    "",
    "DESCRIPTION",
    "    Selects a box of the rectangular understood field.",
    "    All input fields need to have the same horizontal grid.",
    "",
    "OPERATORS",
    "    sellonlatbox  Select a longitude/latitude box",
    "                  Selects a longitude/latitude box. The user has to give the ",
    "                  longitudes and latitudes of the edges of the box.",
    "    selindexbox   Select an index box",
    "                  Selects an index box. The user has to give the indexes of the ",
    "                  edges of the box. The index of the left edge may be greater ",
    "                  then that of the right edge.",
    "",
    "PARAMETER",
    "    lon1  FLOAT    Western longitude",
    "    lon2  FLOAT    Eastern longitude",
    "    lat1  FLOAT    Southern or northern latitude",
    "    lat2  FLOAT    Northern or southern latitude",
    "    idx1  INTEGER  Index of first longitude",
    "    idx2  INTEGER  Index of last longitude",
    "    idy1  INTEGER  Index of first latitude",
    "    idy2  INTEGER  Index of last latitude",
    NULL
};

static char *CondHelp[] = {
    "NAME",
    "    ifthen, ifnotthen - Conditional select one field",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module selects field elements from ifile2 with respect to ifile1 and writes them ",
    "    to ofile. The fields in ifile1 are handled as a mask. A value ",
    "    not equal to zero is treated as \"true\", zero is treated as \"false\".",
    "    The number of fields in ifile1 has either to be the same as in ifile2 or the",
    "    same as in one time step of ifile2 or only one.",
    "    The fields in ofile inherit the meta data from ifile2.",
    "",
    "OPERATORS",
    "    ifthen     If then",
    "                        / i_2(t,x) if i_1([t,]x) NE 0  AND  i_1([t,]x) NE miss",
    "               o(t,x) =",
    "                        \\ miss     if i_1([t,]x) EQ 0  OR   i_1([t,]x) EQ miss",
    "    ifnotthen  If not then",
    "                        / i_2(t,x) if i_1([t,]x) EQ 0  AND  i_1([t,]x) NE miss",
    "               o(t,x) = ",
    "                        \\ miss     if i_1([t,]x) NE 0  OR   i_1([t,]x) EQ miss",
    NULL
};

static char *Cond2Help[] = {
    "NAME",
    "    ifthenelse - Conditional select  two fields",
    "",
    "SYNOPSIS",
    "    ifthenelse  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator selects field elements from ifile2 or ifile3 with respect to",
    "    ifile1 and writes them to ofile. The fields in ifile1 are handled as a mask.",
    "    A value not equal to zero is treated as \"true\", zero is treated as \"false\".",
    "    The number of fields in ifile1 has either to be the same as in ifile2 or the ",
    "    same as in one time step of ifile2 or only one.",
    "    ifile2 and ifile3 need to have the same number of fields.",
    "    The fields in ofile inherit the meta data from ifile2.",
    "    ",
    "              / i_2(t,x) if i_1([t,]x) NE 0  AND  i_1([t,]x) NE miss",
    "    o(t,x) = <  i_3(t,x) if i_1([t,]x) EQ 0  AND  i_1([t,]x) NE miss",
    "              \\ miss     if i_1([t,]x) EQ miss",
    NULL
};

static char *CondcHelp[] = {
    "NAME",
    "    ifthenc, ifnotthenc - Conditional select a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module creates fields with a constant value or missing value.",
    "    The fields in ifile are handled as a mask. A value not equal ",
    "    to zero is treated as \"true\", zero is treated as \"false\".",
    "",
    "OPERATORS",
    "    ifthenc     If then constant",
    "                         / c      if i(t,x) NE 0  AND  i(t,x) NE miss",
    "                o(t,x) =",
    "                         \\ miss   if i(t,x) EQ 0  OR   i(t,x) EQ miss",
    "    ifnotthenc  If not then constant",
    "                         / c      if i(t,x) EQ 0  AND  i(t,x) NE miss",
    "                o(t,x) =",
    "                         \\ miss   if i(t,x) NE 0  OR   i(t,x) EQ miss",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
    NULL
};

static char *CompHelp[] = {
    "NAME",
    "    eq, ne, le, lt, ge, gt - Comparison of two fields",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module compares two datasets field by field. The resulting",
    "    field is a mask containing 1 if the comparison is true and 0 if not. ",
    "    The number of fields in ifile1 should be the same as in ifile2.",
    "    One of the input files can contain only one time step or one field.",
    "    The fields in ofile inherit the meta data from ifile1 or ifile2.",
    "    The type of comparison depends on the chosen operator.",
    "",
    "OPERATORS",
    "    eq  Equal",
    "                  /   1   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    ne  Not equal",
    "                  /   1   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    le  Less equal",
    "                  /   1   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    lt  Less than",
    "                  /   1   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    ge  Greater equal",
    "                  /   1   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    gt  Greater than",
    "                  /   1   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    NULL
};

static char *CompcHelp[] = {
    "NAME",
    "    eqc, nec, lec, ltc, gec, gtc - Comparison of a field with a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module compares all fields of a dataset with a constant. The resulting",
    "    field is a mask containing 1 if the comparison is true and 0 if not.",
    "    The type of comparison depends on the chosen operator.",
    "",
    "OPERATORS",
    "    eqc  Equal constant",
    "                   /   1   if i(t,x) EQ c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) NE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    nec  Not equal constant",
    "                   /   1   if i(t,x) NE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) EQ c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    lec  Less equal constant",
    "                   /   1   if i(t,x) LE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) GT c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    ltc  Less than constant",
    "                   /   1   if i(t,x) LT c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) GE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    gec  Greater equal constant",
    "                   /   1   if i(t,x) GE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) LT c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    gtc  Greater than constant",
    "                   /   1   if i(t,x) GT c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) LE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
    NULL
};

static char *SetHelp[] = {
    "NAME",
    "    setpartab, setcode, setname, setlevel, setltype - Set field info",
    "",
    "SYNOPSIS",
    "    setpartab,table  ifile ofile",
    "    setcode,code  ifile ofile",
    "    setname,name  ifile ofile",
    "    setlevel,level  ifile ofile",
    "    setltype,ltype  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets some field information. Depending on the chosen",
    "    operator the parameter table, code number, variable name or",
    "    level is set.",
    "",
    "OPERATORS",
    "    setpartab  Set parameter table",
    "               Sets the parameter table for all variables.",
    "    setcode    Set code number",
    "               Sets the code number for all variables to the same given value.",
    "    setname    Set variable name",
    "               Sets the name of the first variable.",
    "    setlevel   Set level",
    "               Sets the first level of all variables.",
    "    setltype   Set GRIB level type",
    "               Sets the GRIB level type of all variables.",
    "",
    "PARAMETER",
    "    table  STRING   Parameter table file or name",
    "    code   INTEGER  Code number",
    "    name   STRING   Variable name",
    "    level  FLOAT    New level",
    "    ltype  INTEGER  GRIB level type",
    NULL
};

static char *SettimeHelp[] = {
    "NAME",
    "    setdate, settime, setday, setmon, setyear, settunits, settaxis, setreftime, ",
    "    setcalendar, shifttime - Set time",
    "",
    "SYNOPSIS",
    "    setdate,date  ifile ofile",
    "    settime,time  ifile ofile",
    "    setday,day  ifile ofile",
    "    setmon,month  ifile ofile",
    "    setyear,year  ifile ofile",
    "    settunits,units  ifile ofile",
    "    settaxis,date,time[,inc]  ifile ofile",
    "    setreftime,date,time[,units]  ifile ofile",
    "    setcalendar,calendar  ifile ofile",
    "    shifttime,sval  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets the time axis or part of the time axis. Which part of the",
    "    time axis is overwritten depends on the chosen operator.",
    "",
    "OPERATORS",
    "    setdate      Set date",
    "                 Sets the date in every time step to the same given value.",
    "    settime      Set time of the day",
    "                 Sets the time in every time step to the same given value.",
    "    setday       Set day",
    "                 Sets the day in every time step to the same given value.",
    "    setmon       Set month",
    "                 Sets the month in every time step to the same given value.",
    "    setyear      Set year",
    "                 Sets the year in every time step to the same given value.",
    "    settunits    Set time units",
    "                 Sets the base units of a relative time axis.",
    "    settaxis     Set time axis",
    "                 Sets the time axis.",
    "    setreftime   Set reference time",
    "                 Sets the reference time of a relative time axis.",
    "    setcalendar  Set calendar",
    "                 Sets the calendar of a relative time axis.",
    "    shifttime    Shift time steps",
    "                 Shifts all time steps by the parameter sval.",
    "",
    "PARAMETER",
    "    day       INTEGER  Value of the new day",
    "    month     INTEGER  Value of the new month",
    "    year      INTEGER  Value of the new year",
    "    units     STRING   Base units of the time axis (seconds, minutes, hours, days, months, years)",
    "    date      STRING   Date (format YYYY-MM-DD)",
    "    time      STRING   Time (format hh:mm:ss)",
    "    inc       STRING   Optional increment (seconds, minutes, hours, days, months, years) [default: 0hour]",
    "    calendar  STRING   Calendar (standard, proleptic, 360days, 365days, 366days)",
    "    sval      STRING   Shift value (e.g. -3hour)",
    NULL
};

static char *ChangeHelp[] = {
    "NAME",
    "    chcode, chname, chlevel, chlevelc, chlevelv - Change field header",
    "",
    "SYNOPSIS",
    "    chcode,oldcode,newcode[,...]  ifile ofile",
    "    chname,oldname,newname,...  ifile ofile",
    "    chlevel,oldlev,newlev,...  ifile ofile",
    "    chlevelc,code,oldlev,newlev  ifile ofile",
    "    chlevelv,name,oldlev,newlev  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module reads fields from ifile, changes some header values",
    "    and writes the results to ofile. The kind of changes depends on ",
    "    the chosen operator.",
    "",
    "OPERATORS",
    "    chcode    Change code number",
    "              Changes some user given code numbers to new user given values.",
    "    chname    Change variable name",
    "              Changes some user given variable names to new user given names.",
    "    chlevel   Change level",
    "              Changes some user given levels to new user given values.",
    "    chlevelc  Change level of one code",
    "              Changes one level of a user given code number.",
    "    chlevelv  Change level of one variable",
    "              Changes one level of a user given variable name.",
    "",
    "PARAMETER",
    "    code                 INTEGER  Code number",
    "    oldcode,newcode,...  INTEGER  Pairs of old and new code numbers",
    "    name                 STRING   Variable name",
    "    oldname,newname,...  STRING   Pairs of old and new variable names",
    "    oldlev               FLOAT    Old level",
    "    newlev               FLOAT    New level",
    "    oldlev,newlev,...    FLOAT    Pairs of old and new levels",
    NULL
};

static char *SetgridHelp[] = {
    "NAME",
    "    setgrid, setgridtype - Set grid type",
    "",
    "SYNOPSIS",
    "    setgrid,grid  ifile ofile",
    "    setgridtype,gridtype  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets the grid description of all fields with the same grid size",
    "    as the new grid.",
    "",
    "OPERATORS",
    "    setgrid      Set grid",
    "                 Sets the grid description of all fields.",
    "    setgridtype  Set grid type",
    "                 Sets the grid type of all grids to a user given value.",
    "",
    "PARAMETER",
    "    grid      STRING  Target grid description file or name",
    "    gridtype  STRING  Target grid type (curvilinear or cell)",
    NULL
};

static char *SetzaxisHelp[] = {
    "NAME",
    "    setzaxis - Set z-axis type",
    "",
    "SYNOPSIS",
    "    setzaxis,zaxis  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator sets the z-axis description of all variables with the",
    "    same number of level as the new z-axis.",
    "",
    "PARAMETER",
    "    zaxis  STRING  Z-axis description file or name of the target z-axis",
    NULL
};

static char *SetgattHelp[] = {
    "NAME",
    "    setgatt, setgatts - Set global attribute",
    "",
    "SYNOPSIS",
    "    setgatt,attname,attstring  ifile ofile",
    "    setgatts,attfile  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets global text attributes of a dataset. Depending on the chosen ",
    "    operator the attributes are read from a file or can be specified by a parameter.",
    "",
    "OPERATORS",
    "    setgatt   Set global attribute",
    "              Sets one user defined global text attribute.",
    "    setgatts  Set global attributes",
    "              Sets user defined global text attributes. The name and text",
    "              of the global attributes are read from a file.",
    "",
    "PARAMETER",
    "    attname,attstring  STRING  Name and text of the global attribute (without spaces!)",
    "    attfile            STRING  File name which contains global text attributes",
    NULL
};

static char *InvertHelp[] = {
    "NAME",
    "    invertlat - Invert latitudes",
    "",
    "SYNOPSIS",
    "    invertlat  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator inverts the latitudes of all fields with a regular lon/lat grid. ",
    NULL
};

static char *InvertlevHelp[] = {
    "NAME",
    "    invertlev - Invert levels",
    "",
    "SYNOPSIS",
    "    invertlev  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator inverts the levels of all non hybrid 3D variables.",
    NULL
};

static char *MaskregionHelp[] = {
    "NAME",
    "    maskregion - Mask regions",
    "",
    "SYNOPSIS",
    "    maskregion,regions  ifile ofile",
    "",
    "DESCRIPTION",
    "    Masks different regions of fields with a regular lon/lat grid. ",
    "    The elements inside a region are untouched, the elements outside are ",
    "    set to missing value. All input fields must have the same horizontal grid.",
    "    The user has to give ASCII formatted files with different regions.",
    "    A region is defined by a polygon. Each line of a polygon description file ",
    "    contains the longitude and latitude of one point.",
    "    Each polygon description file can contain one or more polygons separated",
    "    by a line with the character \\&.",
    "",
    "PARAMETER",
    "    regions  STRING Comma separated list of ASCII formatted files with different regions",
    NULL
};

static char *MaskboxHelp[] = {
    "NAME",
    "    masklonlatbox, maskindexbox - Mask a box",
    "",
    "SYNOPSIS",
    "    masklonlatbox,lon1,lon2,lat1,lat2  ifile ofile",
    "    maskindexbox,idx1,idx2,idy1,idy2  ifile ofile",
    "",
    "DESCRIPTION",
    "    Masks a box of the rectangular understood field. The elements inside ",
    "    the box are untouched, the elements outside are set to missing value.",
    "    All input fields need to have the same horizontal grid.",
    "    Use sellonlatbox or selindexbox if only the data inside the",
    "    box are needed.",
    "",
    "OPERATORS",
    "    masklonlatbox  Mask a longitude/latitude box",
    "                   Masks a longitude/latitude box. The user has to give the ",
    "                   longitudes and latitudes of the edges of the box.",
    "    maskindexbox   Mask an index box",
    "                   Masks an index box. The user has to give the indexes of the ",
    "                   edges of the box. The index of the left edge can be greater ",
    "                   then the one of the right edge.",
    "",
    "PARAMETER",
    "    lon1  FLOAT    Western longitude",
    "    lon2  FLOAT    Eastern longitude",
    "    lat1  FLOAT    Southern or northern latitude",
    "    lat2  FLOAT    Northern or southern latitude",
    "    idx1  INTEGER  Index of first longitude",
    "    idx2  INTEGER  Index of last longitude",
    "    idy1  INTEGER  Index of first latitude",
    "    idy2  INTEGER  Index of last latitude",
    NULL
};

static char *SetboxHelp[] = {
    "NAME",
    "    setclonlatbox, setcindexbox - Set a box to constant",
    "",
    "SYNOPSIS",
    "    setclonlatbox,c,lon1,lon2,lat1,lat2  ifile ofile",
    "    setcindexbox,c,idx1,idx2,idy1,idy2  ifile ofile",
    "",
    "DESCRIPTION",
    "    Sets a box of the rectangular understood field to a constant value. ",
    "    The elements outside the box are untouched, the elements inside are ",
    "    set to the given constant. All input fields need to have the same ",
    "    horizontal grid.",
    "",
    "OPERATORS",
    "    setclonlatbox  Set a longitude/latitude box to constant",
    "                   Sets the values of a longitude/latitude box to a constant value. The ",
    "                   user has to give the longitudes and latitudes of the edges of the box.",
    "    setcindexbox   Set an index box to constant",
    "                   Sets the values of an index box to a constant value. The user has to ",
    "                   give the indexes of the edges of the box. The index of the left edge ",
    "                   can be greater than the one of the right edge.",
    "",
    "PARAMETER",
    "    c     FLOAT    Constant",
    "    lon1  FLOAT    Western longitude",
    "    lon2  FLOAT    Eastern longitude",
    "    lat1  FLOAT    Southern or northern latitude",
    "    lat2  FLOAT    Northern or southern latitude",
    "    idx1  INTEGER  Index of first longitude",
    "    idx2  INTEGER  Index of last longitude",
    "    idy1  INTEGER  Index of first latitude",
    "    idy2  INTEGER  Index of last latitude",
    NULL
};

static char *EnlargeHelp[] = {
    "NAME",
    "    enlarge - Enlarge fields",
    "",
    "SYNOPSIS",
    "    enlarge,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    Enlarge all fields of ifile to a user given grid. Normally only the last ",
    "    field element is used for the enlargement. If however the input and output",
    "    grid are regular lon/lat grids, a zonal or meridional enlargement is possible.",
    "    Zonal enlargement takes place, if the xsize of the input field is 1 and ",
    "    the ysize of both grids are the same. For meridional enlargement the ysize",
    "    have to be 1 and the xsize of both grids should have the same size.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    NULL
};

static char *SetmissHelp[] = {
    "NAME",
    "    setmissval, setctomiss, setmisstoc, setrtomiss, setvrange - Set missing value",
    "",
    "SYNOPSIS",
    "    setmissval,newmiss  ifile ofile",
    "    setctomiss,c  ifile ofile",
    "    setmisstoc,c  ifile ofile",
    "    setrtomiss,rmin,rmax  ifile ofile",
    "    setvrange,rmin,rmax  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets part of a field to missing value or missing values",
    "    to a constant value. Which part of the field is set depends on the ",
    "    chosen operator.",
    "",
    "OPERATORS",
    "    setmissval  Set a new missing value",
    "                         / newmiss   if i(t,x) EQ miss",
    "                o(t,x) = ",
    "                         \\ i(t,x)    if i(t,x) NE miss",
    "    setctomiss  Set constant to missing value",
    "                         / miss   if i(t,x) EQ c",
    "                o(t,x) = ",
    "                         \\ i(t,x) if i(t,x) NE c",
    "    setmisstoc  Set missing value to constant",
    "                         / c      if i(t,x) EQ miss",
    "                o(t,x) = ",
    "                         \\ i(t,x) if i(t,x) NE miss",
    "    setrtomiss  Set range to missing value",
    "                         / miss   if i(t,x) GE rmin AND i(t,x) LE rmax",
    "                o(t,x) = ",
    "                         \\ i(t,x) if i(t,x) LT rmin OR  i(t,x) GT rmax",
    "    setvrange   Set valid range",
    "                         / miss   if i(t,x) LT rmin OR  i(t,x) GT rmax",
    "                o(t,x) = ",
    "                         \\ i(t,x) if i(t,x) GE rmin AND i(t,x) LE rmax",
    "",
    "PARAMETER",
    "    newmiss  FLOAT  New missing value",
    "    c        FLOAT  Constant",
    "    rmin     FLOAT  Lower bound",
    "    rmax     FLOAT  Upper bound",
    NULL
};

static char *ExprHelp[] = {
    "NAME",
    "    expr, exprf - Evaluate expressions",
    "",
    "SYNOPSIS",
    "    expr,instr  ifile ofile",
    "    exprf,filename  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module arithmetically processes every time step of the input dataset.",
    "    Each individual assignment statement have to end with a semi-colon.",
    "    The basic arithmetic operations addition +, subtraction -, multiplication *,",
    "    division / and exponentiation ^ can be used.",
    "    The following intrinsic functions are available:",
    "    sqrt(x) "    "    Square Root of x",
    "    exp(x)  "    "    Exponential of x",
    "    log(x)  "    "    Natural logarithm of x",
    "    log10(x)"    "    Base 10 logarithm of x",
    "    sin(x)  "    "    Sine of x, where x is specified in radians",
    "    cos(x)  "    "    Cosine of x, where x is specified in radians",
    "    tan(x)  "    "    Tangent of x, where x is specified in radians",
    "    asin(x) "    "    Arc-sine of x, where x is specified in radians",
    "    acos(x) "    "    Arc-cosine of x, where x is specified in radians",
    "    atan(x) "    "    Arc-tangent of x, where x is specified in radians",
    "",
    "OPERATORS",
    "    expr   Evaluate expressions",
    "           The processing instructions are read from the parameter.",
    "    exprf  Evaluate expressions from script file",
    "           Contrary to expr the processing instructions are read from a file.",
    "",
    "PARAMETER",
    "    instr     STRING  Processing instructions (without spaces!)",
    "    filename  STRING  File with processing instructions",
    NULL
};

static char *MathHelp[] = {
    "NAME",
    "    abs, int, nint, pow, sqr, sqrt, exp, ln, log10, sin, cos, tan, asin, acos, ",
    "    reci - Mathematical functions",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains some standard mathematical functions.",
    "    All trigonometric functions calculate with radians.",
    "",
    "OPERATORS",
    "    abs    Absolute value",
    "           o(t,x) = abs(i(t,x))",
    "    int    Integer value",
    "           o(t,x) = int(i(t,x))",
    "    nint   Nearest integer value",
    "           o(t,x) = nint(i(t,x))",
    "    pow    Power",
    "           o(t,x) = i(t,x)^y",
    "    sqr    Square",
    "           o(t,x) = i(t,x)^2",
    "    sqrt   Square root",
    "           o(t,x) = sqrt(i(t,x))",
    "    exp    Exponential",
    "           o(t,x) = e^i(t,x)",
    "    ln     Natural logarithm",
    "           o(t,x) = ln(i(t,x))",
    "    log10  Base 10 logarithm",
    "           o(t,x) = log10(i(t,x))",
    "    sin    Sine",
    "           o(t,x) = sin(i(t,x))",
    "    cos    Cosine",
    "           o(t,x) = cos(i(t,x))",
    "    tan    Tangent",
    "           o(t,x) = tan(i(t,x))",
    "    asin   Arc sine",
    "           o(t,x) = asin(i(t,x))",
    "    acos   Arc cosine",
    "           o(t,x) = acos(i(t,x))",
    "    reci   Reciprocal value",
    "           o(t,x) = 1 / i(t,x)",
    NULL
};

static char *ArithcHelp[] = {
    "NAME",
    "    addc, subc, mulc, divc - Arithmetic with a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic with all field elements of a dataset and ",
    "    a constant. The fields in ofile inherit the meta data from ifile.",
    "",
    "OPERATORS",
    "    addc  Add a constant",
    "          o(t,x) = i(t,x) + c",
    "    subc  Subtract a constant",
    "          o(t,x) = i(t,x) - c",
    "    mulc  Multiply with a constant",
    "          o(t,x) = i(t,x) * c",
    "    divc  Divide by a constant",
    "          o(t,x) = i(t,x) / c",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
    NULL
};

static char *ArithHelp[] = {
    "NAME",
    "    add, sub, mul, div, min, max, atan2 - Arithmetic on two datasets",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of two datasets.",
    "    The number of fields in ifile1 should be the same as in ifile2.",
    "    One of the input files can contain only one time step or one field.",
    "    The fields in ofile inherit the meta data from ifile1 or ifile2.",
    "",
    "OPERATORS",
    "    add    Add two fields",
    "           o(t,x) = i_1(t,x) + i_2(t,x)",
    "    sub    Subtract two fields",
    "           o(t,x) = i_1(t,x) - i_2(t,x)",
    "    mul    Multiply two fields",
    "           o(t,x) = i_1(t,x) * i_2(t,x)",
    "    div    Divide two fields",
    "           o(t,x) = i_1(t,x) / i_2(t,x)",
    "    min    Minimum of two fields",
    "           o(t,x) = min(i_1(t,x), i_2(t,x))",
    "    max    Maximum of two fields",
    "           o(t,x) = max(i_1(t,x), i_2(t,x))",
    "    atan2  Arc tangent of two fields",
    "           The atan2 operator calculates the arc tangent of two fields. The result is",
    "           in radians, which is between -PI and PI (inclusive).",
    "           ",
    "           o(t,x) = atan2(i_1(t,x), i_2(t,x))",
    NULL
};

static char *MonarithHelp[] = {
    "NAME",
    "    monadd, monsub, monmul, mondiv - Monthly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one",
    "    time step with the same month and year. For each field in ifile1",
    "    the corresponding field of the time step in ifile2 with the",
    "    same month and year is used. The header information in ifile1",
    "    have to be the same as in ifile2. Usually ifile2 is generated",
    "    by a call of the module MONSTAT.",
    "",
    "OPERATORS",
    "    monadd  Add monthly time series",
    "            Adds a time series and a monthly time series.",
    "    monsub  Subtract monthly time series",
    "            Subtracts a time series and a monthly time series.",
    "    monmul  Multiply monthly time series",
    "            Multiplies a time series and a monthly time series.",
    "    mondiv  Divide monthly time series",
    "            Divides a time series and a monthly time series.",
    NULL
};

static char *YmonarithHelp[] = {
    "NAME",
    "    ymonadd, ymonsub, ymonmul, ymondiv - Multi-year monthly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one",
    "    time step with the same month of year. For each field in ifile1",
    "    the corresponding field of the time step in ifile2 with the",
    "    same month of year is used. The header information in ifile1",
    "    have to be the same as in ifile2. Usually ifile2 is generated",
    "    by a call of the module YMONSTAT.",
    "",
    "OPERATORS",
    "    ymonadd  Add multi-year monthly time series",
    "             Adds a time series and a multi-year monthly time series.",
    "    ymonsub  Subtract multi-year monthly time series",
    "             Subtracts a time series and a multi-year monthly time series.",
    "    ymonmul  Multiply multi-year monthly time series",
    "             Multiplies a time series and a multi-year monthly time series.",
    "    ymondiv  Divide multi-year monthly time series",
    "             Divides a time series and a multi-year monthly time series.",
    NULL
};

static char *ArithdaysHelp[] = {
    "NAME",
    "    muldpm, divdpm, muldpy, divdpy - Arithmetic with days",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module multiplies or divides each time step of a dataset with the corresponding",
    "    days per month or days per year. The result of these functions depends on the used",
    "    calendar of the input data.",
    "",
    "OPERATORS",
    "    muldpm  Multiply with days per month",
    "            o(t,x) = i(t,x) * days\\_per\\_month",
    "    divdpm  Divide by days per month",
    "            o(t,x) = i(t,x) / days\\_per\\_month",
    "    muldpy  Multiply with days per year",
    "            o(t,x) = i(t,x) * days\\_per\\_year",
    "    divdpy  Divide by days per year",
    "            o(t,x) = i(t,x) / days\\_per\\_year",
    NULL
};

static char *EnsstatHelp[] = {
    "NAME",
    "    ensmin, ensmax, enssum, ensmean, ensavg, ensvar, ensstd, enspctl - ",
    "    Statistical values over an ensemble",
    "",
    "SYNOPSIS",
    "    ensmin  ifiles ofile",
    "    ensmax  ifiles ofile",
    "    enssum  ifiles ofile",
    "    ensmean  ifiles ofile",
    "    ensavg  ifiles ofile",
    "    ensvar  ifiles ofile",
    "    ensstd  ifiles ofile",
    "    enspctl,p  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over an ensemble of input files.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance,",
    "    standard deviation, or a certain percentile over all input files is written",
    "    to ofile. The date information of a time step in ofile is",
    "    the date of the first input file.",
    "",
    "OPERATORS",
    "    ensmin   Ensemble minimum",
    "             o(t,x) = min{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensmax   Ensemble maximum",
    "             o(t,x) = max{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    enssum   Ensemble sum",
    "             o(t,x) = sum{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensmean  Ensemble mean",
    "             o(t,x) = mean{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensavg   Ensemble average",
    "             o(t,x) = avg{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensvar   Ensemble variance",
    "             o(t,x) = var{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensstd   Ensemble standard deviation",
    "             o(t,x) = std{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    enspctl  Ensemble percentiles",
    "             o(t,x) = pth percentile {i1(t,x), i2(t,x), ..., in(t,x)}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    NULL
};

static char *FldstatHelp[] = {
    "NAME",
    "    fldmin, fldmax, fldsum, fldmean, fldavg, fldvar, fldstd, fldpctl - ",
    "    Statistical values over a field",
    "",
    "SYNOPSIS",
    "    fldmin  ifile ofile",
    "    fldmax  ifile ofile",
    "    fldsum  ifile ofile",
    "    fldmean  ifile ofile",
    "    fldavg  ifile ofile",
    "    fldvar  ifile ofile",
    "    fldstd  ifile ofile",
    "    fldpctl,p  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of the input fields.",
    "    According to the chosen operator the field minimum, maximum,",
    "    sum, average, variance, standard deviation or a certain percentile",
    "    is written to ofile.",
    "",
    "OPERATORS",
    "    fldmin   Field minimum",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = min{i(t,x'), x_1<x'<=x_n}",
    "    fldmax   Field maximum",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = max{i(t,x'), x_1<x'<=x_n}",
    "    fldsum   Field sum",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = sum{i(t,x'), x_1<x'<=x_n}",
    "    fldmean  Field mean",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = mean{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldavg   Field average",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = avg{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldvar   Field variance",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = var{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldstd   Field standard deviation",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = std{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldpctl  Field percentiles",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = pth percentile {i(t,x'), x_1<x'<=x_n}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    NULL
};

static char *ZonstatHelp[] = {
    "NAME",
    "    zonmin, zonmax, zonsum, zonmean, zonavg, zonvar, zonstd, zonpctl - ",
    "    Zonal statistical values",
    "",
    "SYNOPSIS",
    "    zonmin  ifile ofile",
    "    zonmax  ifile ofile",
    "    zonsum  ifile ofile",
    "    zonmean  ifile ofile",
    "    zonavg  ifile ofile",
    "    zonvar  ifile ofile",
    "    zonstd  ifile ofile",
    "    zonpctl,p  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes zonal statistical values of the input fields.",
    "    According to the chosen operator the zonal minimum, maximum, ",
    "    sum, average, variance, standard deviation or a certain percentile",
    "    is written to ofile. All input fields need to have the same",
    "    regular lonlat grid. ",
    "",
    "OPERATORS",
    "    zonmin   Zonal minimum",
    "             For every latitude the minimum over all longitudes is computed.",
    "    zonmax   Zonal maximum",
    "             For every latitude the maximum over all longitudes is computed.",
    "    zonsum   Zonal sum",
    "             For every latitude the sum over all longitudes is computed.",
    "    zonmean  Zonal mean",
    "             For every latitude the mean over all longitudes is computed.",
    "    zonavg   Zonal average",
    "             For every latitude the average over all longitudes is computed.",
    "    zonvar   Zonal variance",
    "             For every latitude the variance over all longitudes is computed.",
    "    zonstd   Zonal standard deviation",
    "             For every latitude the standard deviation over all longitudes is computed.",
    "    zonpctl  Zonal percentiles",
    "             For every latitude the pth percentile over all longitudes is computed.",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    NULL
};

static char *MerstatHelp[] = {
    "NAME",
    "    mermin, mermax, mersum, mermean, meravg, mervar, merstd, merpctl - ",
    "    Meridional statistical values",
    "",
    "SYNOPSIS",
    "    mermin  ifile ofile",
    "    mermax  ifile ofile",
    "    mersum  ifile ofile",
    "    mermean  ifile ofile",
    "    meravg  ifile ofile",
    "    mervar  ifile ofile",
    "    merstd  ifile ofile",
    "    merpctl,p  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes meridional statistical values of the input fields.",
    "    According to the chosen operator the meridional minimum, maximum,",
    "    sum, average, variance, standard deviation or a certain percentile is",
    "    written to ofile. All input fields need to have the same regular lon/lat",
    "    grid. ",
    "",
    "OPERATORS",
    "    mermin   Meridional minimum",
    "             For every longitude the minimum over all latitudes is computed.",
    "    mermax   Meridional maximum",
    "             For every longitude the maximum over all latitudes is computed.",
    "    mersum   Meridional sum",
    "             For every longitude the sum over all latitudes is computed.",
    "    mermean  Meridional mean",
    "             For every longitude the area weighted mean over all latitudes is computed.",
    "    meravg   Meridional average",
    "             For every longitude the area weighted average over all latitudes is computed.",
    "    mervar   Meridional variance",
    "             For every longitude the variance over all latitudes is computed.",
    "    merstd   Meridional standard deviation",
    "             For every longitude the standard deviation over all latitudes is computed.",
    "    merpctl  Meridional percentiles",
    "             For every longitude the pth percentile over all latitudes is computed.",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    NULL
};

static char *GridboxstatHelp[] = {
    "NAME",
    "    gridboxmin, gridboxmax, gridboxsum, gridboxmean, gridboxavg, gridboxvar, ",
    "    gridboxstd - Statistical values over grid boxes",
    "",
    "SYNOPSIS",
    "    <operator>,nx,,ny  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over surrounding grid boxes.",
    "    According to the chosen operator the minimum, maximum, sum, average, ",
    "    variance, or standard deviation of the neighboring grid boxes is written to ofile.",
    "    All gridbox operators only works on quadrilateral curvilinear grids.",
    "",
    "OPERATORS",
    "    gridboxmin   Gridbox minimum",
    "    gridboxmax   Gridbox maximum",
    "    gridboxsum   Gridbox sum",
    "    gridboxmean  Gridbox mean",
    "    gridboxavg   Gridbox average",
    "    gridboxvar   Gridbox variance",
    "    gridboxstd   Gridbox standard deviation",
    "",
    "PARAMETER",
    "    nx  INTEGER  Number of grid boxes in x direction",
    "    ny  INTEGER  Number of grid boxes in y direction",
    NULL
};

static char *VertstatHelp[] = {
    "NAME",
    "    vertmin, vertmax, vertsum, vertmean, vertavg, vertvar, vertstd - ",
    "    Vertical statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over all levels of the input variables.",
    "    According to chosen operator the vertical minimum, maximum, sum, average, variance",
    "    or standard deviation is written to ofile.",
    "",
    "OPERATORS",
    "    vertmin   Vertical minimum",
    "              For every gridpoint the minimum over all levels is computed.",
    "    vertmax   Vertical maximum",
    "              For every gridpoint the maximum over all levels is computed.",
    "    vertsum   Vertical sum",
    "              For every gridpoint the sum over all levels is computed.",
    "    vertmean  Vertical mean",
    "              For every gridpoint the mean over all levels is computed.",
    "    vertavg   Vertical average",
    "              For every gridpoint the average over all levels is computed.",
    "    vertvar   Vertical variance",
    "              For every gridpoint the variance over all levels is computed.",
    "    vertstd   Vertical standard deviation",
    "              For every gridpoint the standard deviation over all levels is computed.",
    NULL
};

static char *TimselstatHelp[] = {
    "NAME",
    "    timselmin, timselmax, timselsum, timselmean, timselavg, timselvar, timselstd - ",
    "    Time range statistical values",
    "",
    "SYNOPSIS",
    "    <operator>,nsets[,noffset[,nskip]]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values for a selected number of time steps.",
    "    According to the chosen operator the minimum, maximum, sum, average,",
    "    variance or standard deviation of the selected time steps is written to ofile.",
    "    The date information of a time step in ofile is the date of the last ",
    "    contributing time step in ifile.",
    "",
    "OPERATORS",
    "    timselmin   Time range minimum",
    "                For every adjacent sequence t1, ...., tn of time steps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = min{i(t',x), t1 < t' <= tn}",
    "    timselmax   Time range maximum",
    "                For every adjacent sequence t1, ...., tn of time steps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = max{i(t',x), t1 < t' <= tn}",
    "    timselsum   Time range sum",
    "                For every adjacent sequence t1, ...., tn of time steps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = sum{i(t',x), t1 < t' <= tn}",
    "    timselmean  Time range mean",
    "                For every adjacent sequence t1, ...., tn of time steps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = mean{i(t',x), t1 < t' <= tn}",
    "    timselavg   Time range average",
    "                For every adjacent sequence t1, ...., tn of time steps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = avg{i(t',x), t1 < t' <= tn}",
    "    timselvar   Time range variance",
    "                For every adjacent sequence t1, ...., tn of time steps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = var{i(t',x), t1 < t' <= tn}",
    "    timselstd   Time range standard deviation",
    "                For every adjacent sequence t1, ...., tn of time steps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = std{i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    nsets    INTEGER  Number of input time steps for each output time step",
    "    noffset  INTEGER  Number of input time steps skipped before the first time step range (optional)",
    "    nskip    INTEGER  Number of input time steps skipped between time step ranges (optional)",
    NULL
};

static char *TimselpctlHelp[] = {
    "NAME",
    "    timselpctl - Time range percentile values",
    "",
    "SYNOPSIS",
    "    timselpctl,p,nsets[,noffset[,nskip]]  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentile values over a selected number of time",
    "    steps in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    timselmin and timselmax operations, respectively.",
    "    The date information of a time step in ofile is the date of the last ",
    "    contributing time step in ifile.",
    "    For every adjacent sequence t1, ...., tn of time steps of the same ",
    "    selected time range it is",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    p        INTEGER  Percentile number in {1, ..., 99}",
    "    nsets    INTEGER  Number of input time steps for each output time step",
    "    noffset  INTEGER  Number of input time steps skipped before the first time step range (optional)",
    "    nskip    INTEGER  Number of input time steps skipped between time step ranges (optional)",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *RunstatHelp[] = {
    "NAME",
    "    runmin, runmax, runsum, runmean, runavg, runvar, runstd - ",
    "    Running statistical values",
    "",
    "SYNOPSIS",
    "    <operator>,nts  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes running statistical values over a selected number",
    "    of time steps. Depending on the chosen operator the minimum, maximum,",
    "    sum, average, variance or standard deviation of a selected number of consecutive ",
    "    time steps read from ifile is written to ofile. The date information ",
    "    in ofile is the date of the middle contributing time step in ifile.",
    "",
    "OPERATORS",
    "    runmin   Running minimum",
    "             o(t+(nts-1)/2,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runmax   Running maximum",
    "             o(t+(nts-1)/2,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runsum   Running sum",
    "             o(t+(nts-1)/2,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runmean  Running mean",
    "             o(t+(nts-1)/2,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runavg   Running average",
    "             o(t+(nts-1)/2,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runvar   Running variance",
    "             o(t+(nts-1)/2,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runstd   Running standard deviation",
    "             o(t+(nts-1)/2,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "",
    "PARAMETER",
    "    nts  INTEGER  Number of time steps",
    "",
    "ENVIRONMENT",
    "    RUNSTAT_DATE",
    "        Sets the date information in ofile to the \"first\", \"last\" or \"middle\" contributing",
    "        time step in ifile.",
    NULL
};

static char *RunpctlHelp[] = {
    "NAME",
    "    runpctl - Running percentile values",
    "",
    "SYNOPSIS",
    "    runpctl,p,nts  ifile1 ofile",
    "",
    "DESCRIPTION",
    "    This module computes running percentiles over a selected number of time",
    "    steps in ifile1.",
    "    The date information in ofile is the date of the medium contributing",
    "    time step in ifile1.",
    "    ",
    "    o(t+(nts-1)/2,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "",
    "PARAMETER",
    "    p    INTEGER  Percentile number in {1, ..., 99}",
    "    nts  INTEGER  Number of time steps",
    NULL
};

static char *TimstatHelp[] = {
    "NAME",
    "    timmin, timmax, timsum, timmean, timavg, timvar, timstd - ",
    "    Statistical values over all time steps",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical  values over all time steps in ifile.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of all time steps read from ifile is written to ofile.",
    "    The date information of a time step in ofile is the date of the last ",
    "    contributing time step in ifile.",
    "",
    "OPERATORS",
    "    timmin   Time minimum",
    "             o(1,x) = min{i(t',x), t_1<t'<=t_n}",
    "    timmax   Time maximum",
    "             o(1,x) = max{i(t',x), t_1<t'<=t_n}",
    "    timsum   Time sum",
    "             o(1,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    timmean  Time mean",
    "             o(1,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    timavg   Time average",
    "             o(1,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    timvar   Time variance",
    "             o(1,x) = var{i(t',x), t_1<t'<=t_n}",
    "    timstd   Time standard deviation",
    "             o(1,x) = std{i(t',x), t_1<t'<=t_n}",
    NULL
};

static char *TimpctlHelp[] = {
    "NAME",
    "    timpctl - Percentile values over all time steps",
    "",
    "SYNOPSIS",
    "    timpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all time steps in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    timmin and timmax operations, respectively.",
    "    The date information of a time step in ofile is the date of the",
    "    last contributing time step in ifile1.",
    "    ",
    "    o(1,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *HourstatHelp[] = {
    "NAME",
    "    hourmin, hourmax, hoursum, hourmean, houravg, hourvar, hourstd - ",
    "    Hourly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over time steps of the same hour.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of time steps of the same hour is written to ofile.",
    "    The date information of a time step in ofile is the date of the last ",
    "    contributing time step in ifile.",
    "",
    "OPERATORS",
    "    hourmin   Hourly minimum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same hour it is:",
    "              ",
    "              o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    hourmax   Hourly maximum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same hour it is:",
    "              ",
    "              o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    hoursum   Hourly sum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same hour it is:",
    "              ",
    "              o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    hourmean  Hourly mean",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same hour it is:",
    "              ",
    "              o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    houravg   Hourly average",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same hour it is:",
    "              ",
    "              o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    hourvar   Hourly variance",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same hour it is:",
    "              ",
    "              o(t,x) = var{i(t',x), t_1<t'<=t_n}",
    "    hourstd   Hourly standard deviation",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same hour it is:",
    "              ",
    "              o(t,x) = std{i(t',x), t_1<t'<=t_n}",
    NULL
};

static char *HourpctlHelp[] = {
    "NAME",
    "    hourpctl - Hourly percentile values",
    "",
    "SYNOPSIS",
    "    hourpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all time steps of the same hour in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    hourmin and hourmax operations, respectively.",
    "    The date information of a time step in ofile is the date of the",
    "    last contributing time step in ifile1.",
    "    For every adjacent sequence t_1, ...,t_n of time steps of the same hour it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *DaystatHelp[] = {
    "NAME",
    "    daymin, daymax, daysum, daymean, dayavg, dayvar, daystd - ",
    "    Daily statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over time steps of the same day.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of time steps of the same day is written to ofile.",
    "    The date information of a time step in ofile is the date of the last ",
    "    contributing time step in ifile.",
    "",
    "OPERATORS",
    "    daymin   Daily minimum",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same day it is",
    "             ",
    "             o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    daymax   Daily maximum",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same day it is",
    "             ",
    "             o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    daysum   Daily sum",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same day it is",
    "             ",
    "             o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    daymean  Daily mean",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same day it is",
    "             ",
    "             o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    dayavg   Daily average",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same day it is",
    "             ",
    "             o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    dayvar   Daily variance",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same day it is",
    "             ",
    "             o(t,x) = var{i(t',x), t_1<t'<=t_n}",
    "    daystd   Daily standard deviation",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same day it is",
    "             ",
    "             o(t,x) = std{i(t',x), t_1<t'<=t_n}",
    NULL
};

static char *DaypctlHelp[] = {
    "NAME",
    "    daypctl - Daily percentile values",
    "",
    "SYNOPSIS",
    "    daypctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all time steps of the same day in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by defining the",
    "    environment variable CDO_PCTL_NBINS. The files ifile2 and",
    "    ifile3 should be the result of corresponding daymin and daymax",
    "    operations, respectively.",
    "    The date information of a time step in ofile is the date of the",
    "    last contributing time step in ifile1.",
    "    For every adjacent sequence t_1, ...,t_n of time steps of the same day it is",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *MonstatHelp[] = {
    "NAME",
    "    monmin, monmax, monsum, monmean, monavg, monvar, monstd - ",
    "    Monthly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over time steps of the same month.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of time steps of the same month is written to ofile.",
    "    The date information of a time step in ofile is the date of the last ",
    "    contributing time step in ifile.",
    "",
    "OPERATORS",
    "    monmin   Monthly minimum",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same month it is:",
    "             ",
    "             o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    monmax   Monthly maximum",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same month it is",
    "             ",
    "             o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    monsum   Monthly sum",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same month it is",
    "             ",
    "             o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    monmean  Monthly mean",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same month it is",
    "             ",
    "             o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    monavg   Monthly average",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same month it is",
    "             ",
    "             o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    monvar   Monthly variance",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same month it is",
    "             ",
    "             o(t,x) = var{i(t',x), t_1 < t' <= t_n}",
    "    monstd   Monthly standard deviation",
    "             For every adjacent sequence t_1, ...,t_n of time steps of the same month it is",
    "             ",
    "             o(t,x) = std{i(t',x), t_1 < t' <= t_n}",
    NULL
};

static char *MonpctlHelp[] = {
    "NAME",
    "    monpctl - Monthly percentile values",
    "",
    "SYNOPSIS",
    "    monpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all time steps of the same month in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    monmin and monmax operations, respectively.",
    "    The date information of a time step in ofile is the date of the",
    "    last contributing time step in ifile1.",
    "    For every adjacent sequence t_1, ...,t_n of time steps of the same month it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *YearstatHelp[] = {
    "NAME",
    "    yearmin, yearmax, yearsum, yearmean, yearavg, yearvar, yearstd - ",
    "    Yearly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over time steps of the same year.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of time steps of the same year is written to ofile.",
    "    The date information of a time step in ofile is the date of the last ",
    "    contributing time step in ifile.",
    "",
    "OPERATORS",
    "    yearmin   Yearly minimum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same year it is",
    "              ",
    "              o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    yearmax   Yearly maximum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same year it is",
    "              ",
    "              o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    yearsum   Yearly sum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same year it is",
    "              ",
    "              o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    yearmean  Yearly mean",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same year it is",
    "              ",
    "              o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    yearavg   Yearly average",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same year it is",
    "              ",
    "              o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    yearvar   Yearly variance",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same year it is",
    "              ",
    "              o(t,x) = var{i(t',x), t_1 < t' <= t_n}",
    "    yearstd   Yearly standard deviation",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same year it is",
    "              ",
    "              o(t,x) = std{i(t',x), t_1 < t' <= t_n}",
    NULL
};

static char *YearpctlHelp[] = {
    "NAME",
    "    yearpctl - Yearly percentile values",
    "",
    "SYNOPSIS",
    "    yearpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all time steps of the same year in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    yearmin and yearmax operations, respectively.",
    "    The date information of a time step in ofile is the date of the",
    "    last contributing time step in ifile1.",
    "    For every adjacent sequence t_1, ...,t_n of time steps of the same year it is",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *SeasstatHelp[] = {
    "NAME",
    "    seasmin, seasmax, seassum, seasmean, seasavg, seasvar, seasstd - ",
    "    Seasonal statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over time steps of the same season.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of time steps of the same season is written to ofile.",
    "    The date information of a time step in ofile is the date of the last ",
    "    contributing time step in ifile. Be careful about the first and the last ",
    "    output time step, they may be incorrect values if the seasons have incomplete ",
    "    time steps.",
    "",
    "OPERATORS",
    "    seasmin   Seasonal minimum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same season it is",
    "              ",
    "              o(t,x) = min{i(t',x), t1 < t' <= tn}",
    "    seasmax   Seasonal maximum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same season it is",
    "              ",
    "              o(t,x) = max{i(t',x), t1 < t' <= tn}",
    "    seassum   Seasonal sum",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same season it is",
    "              ",
    "              o(t,x) = sum{i(t',x), t1 < t' <= tn}",
    "    seasmean  Seasonal mean",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same season it is",
    "              ",
    "              o(t,x) = mean{i(t',x), t1 < t' <= tn}",
    "    seasavg   Seasonal average",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same season it is",
    "              ",
    "              o(t,x) = avg{i(t',x), t1 < t' <= tn}",
    "    seasvar   Seasonal variance",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same season it is",
    "              ",
    "              o(t,x) = var{i(t',x), t1 < t' <= tn}",
    "    seasstd   Seasonal standard deviation",
    "              For every adjacent sequence t_1, ...,t_n of time steps of the same season it is",
    "              ",
    "              o(t,x) = std{i(t',x), t1 < t' <= tn}",
    NULL
};

static char *SeaspctlHelp[] = {
    "NAME",
    "    seaspctl - Seasonal percentile values",
    "",
    "SYNOPSIS",
    "    seaspctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all time steps in ifile1 of the same season.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    seasmin and seasmax operations, respectively.",
    "    The date information of a time step in ofile is the date of the",
    "    last contributing time step in ifile1. Be careful about the first",
    "    and the last output time step, they may be incorrect values if the seasons",
    "    have incomplete time steps.",
    "    For every adjacent sequence t_1, ...,t_n of time steps of the same season it is",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *YhourstatHelp[] = {
    "NAME",
    "    yhourmin, yhourmax, yhoursum, yhourmean, yhouravg, yhourvar, yhourstd - ",
    "    Multi-year hourly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each hour and day of year.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of each hour and day of year in ifile is written to ofile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    yhourmin   Multi-year hourly minimum",
    "               o(0001,x) = min{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = min{i(t,x), day(i(t)) = 8784}",
    "    yhourmax   Multi-year hourly maximum",
    "               o(0001,x) = max{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = max{i(t,x), day(i(t)) = 8784}",
    "    yhoursum   Multi-year hourly sum",
    "               o(0001,x) = sum{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = sum{i(t,x), day(i(t)) = 8784}",
    "    yhourmean  Multi-year hourly mean",
    "               o(0001,x) = mean{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = mean{i(t,x), day(i(t)) = 8784}",
    "    yhouravg   Multi-year hourly average",
    "               o(0001,x) = avg{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = avg{i(t,x), day(i(t)) = 8784}",
    "    yhourvar   Multi-year hourly variance",
    "               o(0001,x) = var{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = var{i(t,x), day(i(t)) = 8784}",
    "    yhourstd   Multi-year hourly standard deviation",
    "               o(0001,x) = std{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = std{i(t,x), day(i(t)) = 8784}",
    NULL
};

static char *YdaystatHelp[] = {
    "NAME",
    "    ydaymin, ydaymax, ydaysum, ydaymean, ydayavg, ydayvar, ydaystd - ",
    "    Multi-year daily statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each day of year.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of each day of year in ifile is written to ofile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    ydaymin   Multi-year daily minimum",
    "              o(001,x) = min{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = min{i(t,x), day(i(t)) = 366}",
    "    ydaymax   Multi-year daily maximum",
    "              o(001,x) = max{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = max{i(t,x), day(i(t)) = 366}",
    "    ydaysum   Multi-year daily sum",
    "              o(001,x) = sum{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = sum{i(t,x), day(i(t)) = 366}",
    "    ydaymean  Multi-year daily mean",
    "              o(001,x) = mean{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = mean{i(t,x), day(i(t)) = 366}",
    "    ydayavg   Multi-year daily average",
    "              o(001,x) = avg{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = avg{i(t,x), day(i(t)) = 366}",
    "    ydayvar   Multi-year daily variance",
    "              o(001,x) = var{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = var{i(t,x), day(i(t)) = 366}",
    "    ydaystd   Multi-year daily standard deviation",
    "              o(001,x) = std{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = std{i(t,x), day(i(t)) = 366}",
    NULL
};

static char *YdaypctlHelp[] = {
    "NAME",
    "    ydaypctl - Multi-year daily percentile values",
    "",
    "SYNOPSIS",
    "    ydaypctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each day of year in ifile1 to ofile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    ydaymin and ydaymax operations, respectively.",
    "    The date information in an output field is the date of the last",
    "    contributing input field.",
    "    ",
    "    o(001,x) = pth percentile {i(t,x), day(i(t)) = 001}",
    "                     ...",
    "    o(366,x) = pth percentile {i(t,x), day(i(t)) = 366}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *YmonstatHelp[] = {
    "NAME",
    "    ymonmin, ymonmax, ymonsum, ymonmean, ymonavg, ymonvar, ymonstd - ",
    "    Multi-year monthly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each month of year.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of each month of year in ifile is written to ofile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    ymonmin   Multi-year monthly minimum",
    "              o(01,x) = min{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = min{i(t,x), month(i(t)) = 12}",
    "    ymonmax   Multi-year monthly maximum",
    "              o(01,x) = max{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = max{i(t,x), month(i(t)) = 12}",
    "    ymonsum   Multi-year monthly sum",
    "              o(01,x) = sum{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = sum{i(t,x), month(i(t)) = 12}",
    "    ymonmean  Multi-year monthly mean",
    "              o(01,x) = mean{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = mean{i(t,x), month(i(t)) = 12}",
    "    ymonavg   Multi-year monthly average",
    "              o(01,x) = avg{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = avg{i(t,x), month(i(t)) = 12}",
    "    ymonvar   Multi-year monthly variance",
    "              o(01,x) = var{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = var{i(t,x), month(i(t)) = 12}",
    "    ymonstd   Multi-year monthly standard deviation",
    "              o(01,x) = std{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = std{i(t,x), month(i(t)) = 12}",
    NULL
};

static char *YmonpctlHelp[] = {
    "NAME",
    "    ymonpctl - Multi-year monthly percentile values",
    "",
    "SYNOPSIS",
    "    ymonpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each month of year in ifile1 to ofile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    ymonmin and ymonmax operations, respectively.",
    "    The date information in an output field is the date of the last",
    "    contributing input field.",
    "    ",
    "    o(01,x) = pth percentile {i(t,x), month(i(t)) = 01}",
    "                     ...",
    "    o(12,x) = pth percentile {i(t,x), month(i(t)) = 12}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *YseasstatHelp[] = {
    "NAME",
    "    yseasmin, yseasmax, yseassum, yseasmean, yseasavg, yseasvar, yseasstd - ",
    "    Multi-year seasonal statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each season.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of each season in ifile is written to ofile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    yseasmin   Multi-year seasonal minimum",
    "               o(1,x) = min{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = min{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = min{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = min{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasmax   Multi-year seasonal maximum",
    "               o(1,x) = max{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = max{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = max{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = max{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseassum   Multi-year seasonal sum",
    "               o(1,x) = sum{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = sum{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = sum{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = sum{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasmean  Multi-year seasonal mean",
    "               o(1,x) = mean{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = mean{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = mean{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = mean{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasavg   Multi-year seasonal average",
    "               o(1,x) = avg{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = avg{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = avg{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = avg{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasvar   Multi-year seasonal variance",
    "               o(1,x) = var{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = var{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = var{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = var{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasstd   Multi-year seasonal standard deviation",
    "               o(1,x) = std{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = std{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = std{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = std{i(t,x), month(i(t)) = 09, 10, 11}",
    NULL
};

static char *YseaspctlHelp[] = {
    "NAME",
    "    yseaspctl - Multi-year seasonal percentile values",
    "",
    "SYNOPSIS",
    "    yseaspctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each season in ifile1 to ofile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    yseasmin and yseasmax operations, respectively.",
    "    The date information in an output field is the date of the last",
    "    contributing input field.",
    "    ",
    "    o(1,x) = pth percentile {i(t,x), month(i(t)) = 12, 01, 02}",
    "    o(2,x) = pth percentile {i(t,x), month(i(t)) = 03, 04, 05}",
    "    o(3,x) = pth percentile {i(t,x), month(i(t)) = 06, 07, 08}",
    "    o(4,x) = pth percentile {i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "PARAMETER",
    "    p  INTEGER  Percentile number in {1, ..., 99}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *YdrunstatHelp[] = {
    "NAME",
    "    ydrunmin, ydrunmax, ydrunsum, ydrunmean, ydrunavg, ydrunvar, ydrunstd - ",
    "    Multi-year daily running statistical values",
    "",
    "SYNOPSIS",
    "    <operator>,nts  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module writes running statistical values for each day of year",
    "    in ifile to ofile. Depending on the chosen operator, the minimum,",
    "    maximum, sum, average, variance or standard deviation of all time steps in",
    "    running windows of wich the medium time step corresponds to a certain day of",
    "    year is computed. The date information in an output field is the date of the",
    "    medium time step in the last contributing running window.",
    "    Note that the operator have to be applied to a continuous time series of daily",
    "    measurements in order to yield physically meaningful results. Also note that",
    "    the output time series begins (nts-1)/2 time steps after the first time step",
    "    of the input time series and ends (nts-1)/2 time steps before the last one.",
    "    For input data which are complete but not continuous, such as time series of",
    "    daily measurements for the same month or season within different years, the",
    "    operator yields physically meaningful results only if the input time series",
    "    does include the (nts-1)/2 days before and after each period of interest.",
    "",
    "OPERATORS",
    "    ydrunmin   Multi-year daily running minimum",
    "               o(001,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunmax   Multi-year daily running maximum",
    "               o(001,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunsum   Multi-year daily running sum",
    "               o(001,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunmean  Multi-year daily running mean",
    "               o(001,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunavg   Multi-year daily running average",
    "               o(001,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunvar   Multi-year daily running variance",
    "               o(001,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunstd   Multi-year daily running standard deviation",
    "               o(001,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 366}",
    "",
    "PARAMETER",
    "    nts  INTEGER  Number of time steps",
    NULL
};

static char *YdrunpctlHelp[] = {
    "NAME",
    "    ydrunpctl - Multi-year daily running percentile values",
    "",
    "SYNOPSIS",
    "    ydrunpctl,p,nts  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator writes running percentile values for each day of year ",
    "    in ifile1 to ofile. A certain percentile is computed for all",
    "    time steps in running windows of which the medium time step corresponds",
    "    to a certain day of year. ",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    ydrunmin and ydrunmax operations, respectively.",
    "    The date information in an output field is the date of the medium time",
    "    step in the last contributing running window.",
    "    Note that the operator have to be applied to a continuous time series of daily",
    "    measurements in order to yield physically meaningful results. Also note that",
    "    the output time series begins (nts-1)/2 time steps after the first time step",
    "    of the input time series and ends (nts-1)/2 time steps before the last.",
    "    For input data which are complete but not continuous, such as time series of",
    "    daily measurements for the same month or season within different years, the",
    "    operator only yields physically meaningful results if the input time series",
    "    does include the (nts-1)/2 days before and after each period of interest.",
    "    ",
    "    o(001,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                     ...",
    "    o(366,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "PARAMETER",
    "    p    INTEGER  Percentile number in {1, ..., 99}",
    "    nts  INTEGER  Number of time steps",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static char *FldcorHelp[] = {
    "NAME",
    "    fldcor - Correlation of grid space",
    "",
    "SYNOPSIS",
    "    fldcor  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    The correlation coefficient is a quantity that gives the quality of a least ",
    "    squares fitting to the original data. This operator correlates all gridpoints",
    "    of two fields for each timestep. With",
    "    ",
    "    S(t) = {x, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    it is",
    "    ",
    "    o(t,1) = Cor{(i_1(t,x), i_2(t,x)), x_1 < x <= x_n}",
    "    where w(x) are the area weights obtained by the input stream.",
    "    For every timestep t only those field elements x belong to the sample,",
    "    which have i_1(t,x) \\neq missval and i_2(t,x) \\neq missval.",
    NULL
};

static char *TimcorHelp[] = {
    "NAME",
    "    timcor - Correlation in time",
    "",
    "SYNOPSIS",
    "    timcor  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    The correlation coefficient is a quantity that gives the quality of a least ",
    "    squares fitting to the original data. This operator correlates each gridpoint",
    "    of two fields over all timesteps. With",
    "    ",
    "    S(x) = {t, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    it is",
    "    ",
    "    o(1,x) = Cor{(i_1(t,x), i_2(t,x)), t_1 < t <= t_n}",
    "    For every gridpoint x only those timesteps t belong to the sample,",
    "    which have i_1(t,x) \\neq missval and i_2(t,x) \\neq missval.",
    NULL
};

static char *RegresHelp[] = {
    "NAME",
    "    regres - Regression",
    "",
    "SYNOPSIS",
    "    regres  ifile ofile",
    "",
    "DESCRIPTION",
    "    The values of the input file ifile are assumed to be distributed as",
    "    N(a+b*t,S^2) with unknown a, b and S^2. This operator estimates the",
    "    parameter b. For every field element x only those time steps ",
    "    t belong to the sample S(x), which have i(t,x) NE miss.",
    NULL
};

static char *DetrendHelp[] = {
    "NAME",
    "    detrend - Detrend time series",
    "",
    "SYNOPSIS",
    "    detrend  ifile ofile",
    "",
    "DESCRIPTION",
    "    Every time series in ifile is linearly detrended. For every field element x ",
    "    only those time steps t belong to the sample S(x), which have i(t,x) NE miss.",
    NULL
};

static char *TrendHelp[] = {
    "NAME",
    "    trend - Trend of time series",
    "",
    "SYNOPSIS",
    "    trend  ifile ofile1 ofile2",
    "",
    "DESCRIPTION",
    "    The values of the input file ifile are assumed to be distributed as",
    "    N(a+b*t,S^2) with unknown a, b and S^2. This operator estimates the",
    "    parameter a and b. For every field element x only those time steps ",
    "    t belong to the sample S(x), which have i(t,x) NE miss.",
    "    Thus the estimation for a is stored in ofile1 and that for b is stored ",
    "    in ofile2. To subtract the trend from the data see operator subtrend.",
    NULL
};

static char *SubtrendHelp[] = {
    "NAME",
    "    subtrend - Subtract a trend",
    "",
    "SYNOPSIS",
    "    subtrend  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator is for subtracting a trend computed by the operator trend.",
    "    It is",
    "    ",
    "    o(t,x) = i_1(t,x) - (i_2(1,x) + i_3(1,x)*t)",
    "    where t is the time steps.",
    NULL
};

static char *RemapgridHelp[] = {
    "NAME",
    "    remapbil, remapbic, remapdis, remapnn, remapcon, remapcon2, remaplaf - ",
    "    SCRIP grid interpolation",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators to remap all input fields to a new horizontal grid.",
    "    Each operator uses a different remapping method. The interpolation is based",
    "    on an adapted SCRIP library version. For a detailed description of the remapping ",
    "    methods see SCRIP.",
    "",
    "OPERATORS",
    "    remapbil   Bilinear interpolation",
    "               Performs a bilinear interpolation on all input fields.",
    "               This interpolation method only works on quadrilateral curvilinear grids.",
    "    remapbic   Bicubic interpolation",
    "               Performs a bicubic interpolation on all input fields.",
    "               This interpolation method only works on quadrilateral curvilinear grids.",
    "    remapdis   Distance-weighted average remapping",
    "               Performs a distance-weighted average remapping of the four nearest neighbor ",
    "               values on all input fields.",
    "    remapnn    Nearest neighbor remapping",
    "               Performs a nearest neighbor remapping on all input fields.",
    "    remapcon   First order conservative remapping",
    "               Performs a first order conservative remapping on all input fields.",
    "    remapcon2  Second order conservative remapping",
    "               Performs a second order conservative remapping on all input fields.",
    "    remaplaf   Largest area fraction remapping",
    "               Performs a largest area fraction remapping on all input fields.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    NORMALIZE_OPT    ",
    "        This variable is used to choose the normalization of the conservative ",
    "        remapping. By default NORMALIZE_OPT is set to 'fracarea' and will",
    "        include the destination area fraction in the output weights; other ",
    "        options are 'none' and 'destarea' (for more information see {SCRIP}).",
    "    REMAP_EXTRAPOLATE",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for remapdis, remapnn",
    "        and for circular grids.",
    NULL
};

static char *GenweightsHelp[] = {
    "NAME",
    "    genbil, genbic, gendis, gennn, gencon, gencon2, genlaf - ",
    "    Generate SCRIP grid interpolation weights",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    Interpolation between different horizontal grids can be a very time-consuming ",
    "    process. Especially if the data are on an unstructured or a large grid. ",
    "    In this case the \\htmlref{SCRIP}{SCRIP} interpolation process can be split ",
    "    into two parts. Firstly the generation of the interpolation weights, which is ",
    "    the most time-consuming part. These interpolation weights can be reused for ",
    "    every remapping process with the operator remap. This method should be ",
    "    used only if all input fields are on the same grid and a possibly",
    "    mask (missing values) does not change. This module contains operators to ",
    "    generate SCRIP interpolation weights of the first input field.",
    "    Each operator is using a different interpolation method.",
    "",
    "OPERATORS",
    "    genbil   Generate bilinear interpolation weights",
    "             Generates bilinear interpolation weights and writes the result to a file. ",
    "             This interpolation method only works on quadrilateral curvilinear grids.",
    "    genbic   Generate bicubic interpolation weights",
    "             Generates bicubic interpolation weights and writes the result to a file.",
    "             This interpolation method only works on quadrilateral curvilinear grids.",
    "    gendis   Generate distance-weighted average remap weights",
    "             Generates distance-weighted average remapping weights of the four",
    "             nearest neighbor values and writes the result to a file.",
    "    gennn    Generate nearest neighbor remap weights",
    "             Generates nearest neighbor remapping weights and writes the result to a file.",
    "    gencon   Generate 1st order conservative remap weights",
    "             Generates first order conservative remapping weights and",
    "             writes the result to a file.",
    "    gencon2  Generate 2nd order conservative remap weights",
    "             Generates second order conservative remapping weights and",
    "             writes the result to a file.",
    "    genlaf   Generate largest area fraction remap weights",
    "             Generates largest area fraction remapping weights and",
    "             writes the result to a file.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    NORMALIZE_OPT    ",
    "        This variable is used to choose the normalization of the conservative ",
    "        interpolation. By default NORMALIZE_OPT is set to 'fracarea' and will",
    "        include the destination area fraction in the output weights; other ",
    "        options are 'none' and 'destarea' (for more information see {SCRIP}).",
    "    REMAP_EXTRAPOLATE",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for remapdis, remapnn",
    "        and for circular grids.",
    NULL
};

static char *RemapHelp[] = {
    "NAME",
    "    remap - SCRIP grid remapping",
    "",
    "SYNOPSIS",
    "    remap,grid,weights  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator remaps all input fields to a new horizontal grid. The remap type and ",
    "    the interpolation weights of one input grid are read from a netCDF file. The netCDF ",
    "    file with the weights should follow the \\htmlref{SCRIP}{SCRIP} convention. Normally these weights ",
    "    come from a previous call to module GENWEIGHTS or were created by the original",
    "    SCRIP package.",
    "",
    "PARAMETER",
    "    grid     STRING  Target grid description file or name",
    "    weights  STRING  Interpolation weights (SCRIP netCDF file)",
    "",
    "ENVIRONMENT",
    "    NORMALIZE_OPT    ",
    "        This variable is used to choose the normalization of the conservative ",
    "        interpolation. By default NORMALIZE_OPT is set to 'fracarea' and will",
    "        include the destination area fraction in the output weights; other ",
    "        options are 'none' and 'destarea' (for more information see {SCRIP}).",
    "    REMAP_EXTRAPOLATE",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for remapdis, remapnn",
    "        and for circular grids.",
    NULL
};

static char *RemapetaHelp[] = {
    "NAME",
    "    remapeta - Remap vertical hybrid level",
    "",
    "SYNOPSIS",
    "    remapeta,vct[,oro]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator interpolates between different vertical hybrid levels. ",
    "    This include the preparation of consistent data for the free atmosphere.",
    "    The procedure for the vertical interpolation is based on the HIRLAM scheme",
    "    and was adapted from INTERA.",
    "    The vertical interpolation is based on the vertical integration of the",
    "    hydrostatic equation with few adjustments. The basic tasks are the following one:",
    "    - at first integration of hydrostatic equation",
    "    - extrapolation of surface pressure",
    "    - Planetary Boundary-Layer (PBL) profile interpolation",
    "    - interpolation in free atmosphere",
    "    - merging of both profiles",
    "    - final surface pressure correction",
    "    ",
    "    The vertical interpolation corrects the surface pressure. This is simply",
    "    a cut-off or an addition of air mass. This mass correction should not",
    "    influence the geostrophic velocity field in the middle troposhere. Therefore",
    "    the total mass above a given reference level is conserved. As reference level",
    "    the geopotential height of the 500 hPa level is used. Near the surface the",
    "    correction can affect the vertical structure of the PBL. Therefore the",
    "    interpolation is done using the potential temperature. But in the free",
    "    atmosphere above a certain n (n=0.8 defining the top of the PBL) the",
    "    interpolation is done linearly. After the interpolation both profiles",
    "    are merged. With the resulting temperature/pressure correction the hydrostatic",
    "    equation is integrated again and adjusted to the reference level finding",
    "    the final surface pressure correction. A more detailed description of",
    "    the interpolation can be found in INTERA.",
    "    All input fields have to be on the same horizontal grid.",
    "",
    "PARAMETER",
    "    vct  STRING  File name of an ASCII dataset with the vertical coordinate table",
    "    oro  STRING  File name with the orography (surf. geopotential) of the target dataset (optional)",
    NULL
};

static char *IntvertHelp[] = {
    "NAME",
    "    ml2pl, ml2hl - Vertical interpolation",
    "",
    "SYNOPSIS",
    "    ml2pl,plevels  ifile ofile",
    "    ml2hl,hlevels  ifile ofile",
    "",
    "DESCRIPTION",
    "    Interpolate 3D variables on hybrid model levels to pressure or height levels.",
    "    The input file should contain the log. surface pressure or the surface pressure.",
    "    To interpolate the temperature, the orography (surface geopotential) is also needed.",
    "    The pressure, temperature, and orography are identified by their code numbers.",
    "    Supported parameter tables are: WMO standard table number 2 and ECMWF local table number 128.",
    "    Use the alias  ml2plx/ml2hlx or the environment variable EXTRAPOLATE",
    "    to extrapolate missing values. All input fields have to be on the same horizontal grid.",
    "",
    "OPERATORS",
    "    ml2pl  Model to pressure level interpolation",
    "           Interpolates 3D variables on hybrid model levels to pressure levels.",
    "    ml2hl  Model to height level interpolation",
    "           Interpolates 3D variables on hybrid model levels to height levels.",
    "           The procedure is the same as for the operator mh2pl except for",
    "           the pressure levels being calculated from the heights by:",
    "           plevel = 101325*exp(hlevel/-7000)",
    "",
    "PARAMETER",
    "    plevels  FLOAT  Pressure levels in pascal",
    "    hlevels  FLOAT  Height levels in meter (max level: 65535 m)",
    "",
    "ENVIRONMENT",
    "    EXTRAPOLATE",
    "        If set to 1 extrapolate missing values.",
    NULL
};

static char *IntlevelHelp[] = {
    "NAME",
    "    intlevel - Linear level interpolation",
    "",
    "SYNOPSIS",
    "    intlevel,levels  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator performs a linear vertical interpolation of non hybrid ",
    "    3D variables.",
    "",
    "PARAMETER",
    "    levels  FLOAT  Target levels",
    NULL
};

static char *InttimeHelp[] = {
    "NAME",
    "    inttime, intntime - Time interpolation",
    "",
    "SYNOPSIS",
    "    inttime,date,time[,inc]  ifile ofile",
    "    intntime,n  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module performs linear interpolation between time steps.",
    "",
    "OPERATORS",
    "    inttime   Interpolation between time steps",
    "              This operator creates a new dataset by linear interpolation between time steps.",
    "              The user has to define the start date/time with an optional increment.",
    "    intntime  Interpolation between time steps",
    "              This operator performs linear interpolation between time steps.",
    "              The user has to define the number of time steps from one time step",
    "              to the next.",
    "",
    "PARAMETER",
    "    date  STRING  Start date (format YYYY-MM-DD)",
    "    time  STRING  Start time (format hh:mm:ss)",
    "    inc   STRING  Optional increment (seconds, minutes, hours, days, months, years) [default: 0hour]",
    "    n     INTEGER Number of time steps from one time step to the next",
    NULL
};

static char *IntyearHelp[] = {
    "NAME",
    "    intyear - Year interpolation",
    "",
    "SYNOPSIS",
    "    intyear,years  ifile1 ifile2 oprefix",
    "",
    "DESCRIPTION",
    "    This operator performs linear interpolation between two years",
    "    time step by time step. Appends four digits with the year to ",
    "    oprefix to form the output file names.",
    "",
    "PARAMETER",
    "    years  INTEGER  Comma separated list of years",
    NULL
};

static char *SpectralHelp[] = {
    "NAME",
    "    sp2gp, sp2gpl, gp2sp, gp2spl, sp2sp - Spectral transformation",
    "",
    "SYNOPSIS",
    "    sp2gp  ifile ofile",
    "    sp2gpl  ifile ofile",
    "    gp2sp  ifile ofile",
    "    gp2spl  ifile ofile",
    "    sp2sp,trunc  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module transforms fields on Gaussian grids to spectral coefficients ",
    "    and vice versa.",
    "",
    "OPERATORS",
    "    sp2gp   Spectral to gridpoint",
    "            Convert all fields with spectral coefficients to a regular Gaussian",
    "            grid. The number of latitudes of the resulting Gaussian grid is ",
    "            calculated from the triangular truncation by:",
    "            ",
    "               nlat = NINT((trunc*3 + 1.)/2.)",
    "    sp2gpl  Spectral to gridpoint (linear)",
    "            Convert all fields with spectral coefficients to a regular Gaussian",
    "            grid. The number of latitudes of the resulting Gaussian grid",
    "            is calculated from the triangular truncation by:",
    "            ",
    "               nlat = NINT((trunc*2 + 1.)/2.)",
    "            ",
    "            Use this operator to convert ERA40 data e.g. from TL159 to N80.",
    "    gp2sp   Gridpoint to spectral",
    "            Convert all Gaussian gridpoint fields to spectral coefficients.",
    "            The triangular truncation of the resulting spherical harmonics",
    "            is calculated from the number of latitudes by:",
    "            ",
    "               trunc = (nlat*2 - 1) / 3",
    "    gp2spl  Gridpoint to spectral (linear)",
    "            Convert all Gaussian gridpoint fields to spectral coefficients.",
    "            The triangular truncation of the resulting spherical harmonics",
    "            is calculated from the number of latitudes by:",
    "            ",
    "               trunc = (nlat*2 - 1) / 2",
    "            ",
    "            Use this operator to convert ERA40 data e.g. from N80 to TL159",
    "            instead of T106.",
    "    sp2sp   Spectral to spectral",
    "            Change the triangular truncation of all spectral fields.",
    "            The operator performs downward conversion by cutting the resolution.",
    "            Upward conversions are achieved by filling in zeros.",
    "",
    "PARAMETER",
    "    trunc  INTEGER  New spectral resolution",
    "    wnums  INTEGER  Comma separated list of wave numbers",
    NULL
};

static char *WindHelp[] = {
    "NAME",
    "    dv2uv, dv2uvl, uv2dv, uv2dvl - Wind transformation",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module converts relative divergence and vorticity to U and V wind and vice versa.",
    "",
    "OPERATORS",
    "    dv2uv   Divergence and vorticity to U and V wind",
    "            Calculate U and V wind on a Gaussian grid from spherical harmonic ",
    "            coefficients of relative divergence and vorticity. The divergence and vorticity ",
    "            need to have the names sd and svo or code numbers 155 and 138.",
    "            The number of latitudes of the resulting Gaussian grid is calculated ",
    "            from the triangular truncation by:",
    "            ",
    "               nlat = NINT((trunc*3 + 1.)/2.)",
    "    dv2uvl  Divergence and vorticity to U and V wind (linear)",
    "            Calculate U and V wind on a Gaussian grid from spherical harmonic ",
    "            coefficients of relative divergence and vorticity. The divergence and vorticity ",
    "            need tohave the names sd and svo or code numbers 155 and 138.",
    "            The number of latitudes of the resulting Gaussian grid is calculated ",
    "            from the triangular truncation by:",
    "            ",
    "               nlat = NINT((trunc*2 + 1.)/2.)",
    "    uv2dv   U and V wind to divergence and vorticity",
    "            Calculate spherical harmonic coefficients of relative divergence and vorticity",
    "            from U and V wind. The U and V wind need to have the names u and v or",
    "            the code numbers 131 and 132.",
    "            The triangular truncation of the resulting spherical harmonics",
    "            is calculated from the number of latitudes by:",
    "            ",
    "               trunc = (nlat*2 - 1) / 3",
    "    uv2dvl  U and V wind to divergence and vorticity (linear)",
    "            Calculate spherical harmonic coefficients of relative divergence and vorticity",
    "            from U and V wind. The U and V wind need to have the names u and v or",
    "            the code numbers 131 and 132.",
    "            The triangular truncation of the resulting spherical harmonics",
    "            is calculated from the number of latitudes by:",
    "            ",
    "               trunc = (nlat*2 - 1) / 2",
    NULL
};

static char *InputHelp[] = {
    "NAME",
    "    input, inputsrv, inputext - Formatted input",
    "",
    "SYNOPSIS",
    "    input,grid  ofile",
    "    inputsrv  ofile",
    "    inputext  ofile",
    "",
    "DESCRIPTION",
    "    This module reads time series of one 2D variable from standard input.",
    "    All input fields need to have the same horizontal grid. The format of the ",
    "    input depends on the chosen operator.",
    "",
    "OPERATORS",
    "    input     ASCII input",
    "              Reads fields with ASCII numbers from standard input and stores them",
    "              in ofile. The numbers read are exactly that ones which are ",
    "              written out by output.",
    "    inputsrv  SERVICE ASCII input",
    "              Reads fields with ASCII numbers from standard input and stores them ",
    "              in ofile. Each field should have a header of 8 integers (SERVICE likely).",
    "              The numbers that are read are exactly that ones which are written out by outputsrv.",
    "    inputext  EXTRA ASCII input",
    "              Read fields with ASCII numbers from standard input and stores them ",
    "              in ofile. Each field should have header of 4 integers (EXTRA likely).",
    "              The numbers read are exactly that ones which are written out by outputext.",
    "",
    "PARAMETER",
    "    grid  STRING  Grid description file or name",
    NULL
};

static char *OutputHelp[] = {
    "NAME",
    "    output, outputf, outputint, outputsrv, outputext - Formatted output",
    "",
    "SYNOPSIS",
    "    output  ifiles",
    "    outputf,format,nelem  ifiles",
    "    outputint  ifiles",
    "    outputsrv  ifiles",
    "    outputext  ifiles",
    "",
    "DESCRIPTION",
    "    This module prints all values of all input datasets to standard output.",
    "    All input fields need to have the same horizontal grid. The format of the ",
    "    output depends on the chosen operator.",
    "",
    "OPERATORS",
    "    output     ASCII output",
    "               Prints all values to standard output.",
    "               Each row has 6 elements with the C-style format \"%13.6g\".",
    "    outputf    Formatted output",
    "               Prints all values to standard output.",
    "               The format and number of elements for each row have to be specified by the parameters",
    "               format and nelem.",
    "    outputint  Integer output",
    "               Prints all values rounded to the nearest integer to standard output.",
    "    outputsrv  SERVICE ASCII output",
    "               Prints all values to standard output.",
    "               Each field with a header of 8 integers (SERVICE likely).",
    "    outputext  EXTRA ASCII output",
    "               Prints all values to standard output.",
    "               Each field with a header of 4 integers (EXTRA likely).",
    "",
    "PARAMETER",
    "    format  STRING  C-style format for one element (e.g. \%13.6g)",
    "    nelem   INTEGER Number of elements for each row",
    NULL
};

static char *GridcellHelp[] = {
    "NAME",
    "    gridarea, gridweights - Grid cell quantities",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module reads the grid cell area of the first grid from the input stream.",
    "    If the grid cell area is missing it will be computed from the ",
    "    grid description. Depending on the chosen operator the grid cell area or weights",
    "    are written to the output stream.",
    "",
    "OPERATORS",
    "    gridarea     Grid cell area",
    "                 Writes the grid cell area to the output stream. If the grid cell area have to",
    "                 be computed it is scaled with the earth radius to square meters.",
    "    gridweights  Grid cell weights",
    "                 Writes the grid cell area weights to the output stream.",
    "",
    "ENVIRONMENT",
    "    PLANET_RADIUS",
    "        This variable is used to scale the computed grid cell areas to square meters. ",
    "        By default PLANET_RADIUS is set to an earth radius of 6371000 meter.",
    NULL
};

static char *GradsdesHelp[] = {
    "NAME",
    "    gradsdes1, gradsdes2 - GrADS data descriptor file",
    "",
    "SYNOPSIS",
    "    <operator>  ifile",
    "",
    "DESCRIPTION",
    "    Creates a \\htmlref{GrADS}{GrADS} data descriptor file. Supported file formats are GRIB,",
    "    SERVICE, EXTRA and IEG. For GRIB files the GrADS map file is also ",
    "    generated. For SERVICE and EXTRA files the grid have to be specified with",
    "    the CDO option '-g <grid>'. This module takes ifile in order to create ",
    "    filenames for the descriptor (ifile.ctl) and the map (ifile.gmp) file.",
    "    \"gradsdes\" is an alias for gradsdes2.",
    "",
    "OPERATORS",
    "    gradsdes1  GrADS data descriptor file (version 1 GRIB map)",
    "               Creates a GrADS data descriptor file. Generated a machine",
    "               specific version 1 GrADS map file for GRIB datasets.",
    "    gradsdes2  GrADS data descriptor file (version 2 GRIB map)",
    "               Creates a GrADS data descriptor file. Generated a machine ",
    "               independent version 2 GrADS map file for GRIB datasets.",
    "               This map file can be used only with GrADS version 1.8 or newer. ",
    NULL
};

static char *Smooth9Help[] = {
    "NAME",
    "    smooth9 - 9 point smoothing",
    "",
    "SYNOPSIS",
    "    smooth9  ifile ofile",
    "",
    "DESCRIPTION",
    "    Performs a 9 point smoothing on all fields with a quadrilateral curvilinear grid.",
    "    The result at each grid point is a weighted average of the grid point plus",
    "    the 8 surrounding points. The center point receives a weight of 1.0, the ",
    "    points at each side and above and below receive a weight of 0.5, and corner ",
    "    points receive a weight of 0.3.",
    "    All 9 points are multiplied by their weights and summed, then divided by ",
    "    the total weight to obtain the smoothed value. Any missing data points are ",
    "    not included in the sum; points beyond the grid boundary are considered to ",
    "    be missing. Thus the final result may be the result of an averaging with less ",
    "    than 9 points.",
    NULL
};

static char *SetrangeHelp[] = {
    "NAME",
    "    setrtoc, setrtoc2 - Set range to constant",
    "",
    "SYNOPSIS",
    "    setrtoc,rmin,rmax,c  ifile ofile",
    "    setrtoc2,rmin,rmax,c,c2  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets part of a field to a constant value or missing values. ",
    "    Which part of the field is set depends on the chosen operator.",
    "",
    "OPERATORS",
    "    setrtoc   Set range to constant",
    "                       / c      if i(t,x) GE rmin AND i(t,x) LE rmax",
    "              o(t,x) = ",
    "                       \\ i(t,x) if i(t,x) LT rmin AND i(t,x) GT rmax",
    "    setrtoc2  Set range to constant others to constant2",
    "                       / c      if i(t,x) GE rmin AND i(t,x) LE rmax",
    "              o(t,x) = ",
    "                       \\ c2     if i(t,x) LT rmin AND i(t,x) GT rmax",
    "",
    "PARAMETER",
    "    rmin  FLOAT  Lower bound",
    "    rmax  FLOAT  Upper bound",
    "    c     FLOAT  New value - inside range",
    "    c2    FLOAT  New value - outside range",
    NULL
};

static char *TimsortHelp[] = {
    "NAME",
    "    timsort - Timsort",
    "",
    "SYNOPSIS",
    "    timsort  ifile ofile",
    "",
    "DESCRIPTION",
    "    Sorts the elements in ascending order over all time steps for every field position.",
    "    After sorting it is:",
    "    ",
    "    o(t_1,x) <= o(t_2,x)      forall (t_1<t_2),x",
    NULL
};

static char *VargenHelp[] = {
    "NAME",
    "    const, random - Generate a field",
    "",
    "SYNOPSIS",
    "    const,const,grid  ofile",
    "    random,grid[,seed]  ofile",
    "",
    "DESCRIPTION",
    "    Generates a dataset with one field. The size of the field",
    "    is specified by the user given grid description.",
    "    According to the chosen operator all field elements",
    "    are constant or filled with random numbers.",
    "",
    "OPERATORS",
    "    const   Create a constant field",
    "            Creates a constant field. All field elements of the grid",
    "            have the same value.",
    "    random  Create a field with random numbers",
    "            Creates a field with rectangularly distrubuted random numbers in the interval [0,1].",
    "",
    "PARAMETER",
    "    const  FLOAT   Constant",
    "    seed   INTEGER The seed for a new sequence of pseudo-random numbers [default: 1]",
    "    grid   STRING  Target grid description file or name",
    NULL
};

static char *RotuvHelp[] = {
    "NAME",
    "    rotuvb - Rotation",
    "",
    "SYNOPSIS",
    "    rotuvb,u,v,...  ifile ofile",
    "",
    "DESCRIPTION",
    "    This is a special operator for datsets with wind components on a rotated grid, ",
    "    e.g. data from the regional model REMO. It performs a backward transformation of ",
    "    velocity components U and V from a rotated spherical system to a geographical system.",
    "",
    "PARAMETER",
    "    u,v,...  STRING  Pairs of zonal and meridional velocity components (use variable names or code numbers)",
    NULL
};

static char *MastrfuHelp[] = {
    "NAME",
    "    mastrfu - Mass stream function",
    "",
    "SYNOPSIS",
    "    mastrfu  ifile ofile",
    "",
    "DESCRIPTION",
    "    This is a special operator for the post processing of the atmospheric ",
    "    general circulation model \\htmlref{ECHAM}{ECHAM}. It computes the mass stream function ",
    "    (code number 272). The input dataset have to be a zonal mean of v-velocity",
    "    (code number 132) on pressure levels.",
    NULL
};

static char *HistogramHelp[] = {
    "NAME",
    "    histcount, histsum, histmean, histfreq - Histogram",
    "",
    "SYNOPSIS",
    "    <operator>,bounds  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module creates bins for a histogram of the input data.",
    "    The bins have to be adjacent and have non-overlapping intervals.",
    "    The user has to define the bounds of the bins. The first value",
    "    is the lower bound and the second value the upper bound of the",
    "    first bin. The bounds of the second bin are defined by the",
    "    second and third value, aso.",
    "    Only 2-dimensional input fields are allowed. The ouput file ",
    "    contains one vertical level for each of the bins requested.",
    "",
    "OPERATORS",
    "    histcount  Histogram count",
    "               Number of elements in the bin range.",
    "    histsum    Histogram sum",
    "               Sum of elements in the bin range.",
    "    histmean   Histogram mean",
    "               Mean of elements in the bin range.",
    "    histfreq   Histogram frequency",
    "               Frequency of elements in the bin range.",
    "",
    "PARAMETER",
    "    bounds  FLOAT  Comma separated list of the bin bounds (-inf and inf valid)",
    NULL
};

static char *SethaloHelp[] = {
    "NAME",
    "    sethalo - Set the left and right bounds of a field",
    "",
    "SYNOPSIS",
    "    sethalo,lhalo,rhalo  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator sets the left and right bounds of the rectangularly",
    "    understood fields. Positive numbers of the parameter lhalo enlarges ",
    "    the left bound by the given number of columns from the right bound. The",
    "    parameter rhalo does the similar for the right bound.",
    "    Negative numbers of the parameter lhalo/rhalo can be used to remove",
    "    the given number of columns of the left and right bounds.",
    "",
    "PARAMETER",
    "    lhalo  INTEGER  Left halo",
    "    rhalo  INTEGER  Right halo",
    NULL
};

static char *ImportamsrHelp[] = {
    "NAME",
    "    import_amsr - Import AMSR binary files",
    "",
    "SYNOPSIS",
    "    import_amsr  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded binary AMSR (Advanced Microwave Scanning Radiometer) data.",
    "    The binary data files are available from the AMSR ftp site (ftp://ftp.ssmi.com/amsre).",
    "    Each file consists of twelve (daily) or five (averaged) 0.25 x 0.25 degree ",
    "    grid (1440,720) byte maps. For daily files, six daytime maps in the following",
    "    order, Time (UTC), Sea Surface Temperature (SST), 10 meter Surface Wind Speed (WSPD),",
    "    Atmospheric Water Vapor (VAPOR), Cloud Liquid Water (CLOUD), and Rain Rate (RAIN), ",
    "    are followed by six nighttime maps in the same order. Time-Averaged files contain ",
    "    just the geophysical layers in the same order [SST, WSPD, VAPOR, CLOUD, RAIN].",
    "    More information to the data is available on the AMSR homepage http://www.remss.com/amsr.",
    NULL
};

static char *ImportcmsafHelp[] = {
    "NAME",
    "    import_cmsaf - Import CM-SAF HDF5 files",
    "",
    "SYNOPSIS",
    "    import_cmsaf  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded CM-SAF (Satellite Application Facility on Climate Monitoring)",
    "    HDF5 files. CM-SAF exploits data from polar-orbiting and geostationary satellites in order ",
    "    to provide climate monitoring products of the following parameters: ",
    "    ",
    "    Cloud parameters: cloud fraction (CFC), cloud type (CTY), cloud phase (CPH), ",
    "                      cloud top height, pressure and temperature (CTH,CTP,CTT), ",
    "                      cloud optical thickness (COT), cloud water path (CWP).",
    "    ",
    "    Surface radiation components: Surface albedo (SAL); surface incoming (SIS) ",
    "                      and net (SNS) shortwave radiation; surface downward (SDL) ",
    "                      and outgoing (SOL) longwave radiation, surface net longwave ",
    "                      radiation (SNL) and surface radiation budget (SRB).",
    "    ",
    "    Top-of-atmosphere radiation components: Incoming (TIS) and reflected (TRS) ",
    "                      solar radiative flux at top-of-atmosphere. Emitted thermal ",
    "                      radiative flux at top-of-atmosphere (TET).",
    "    ",
    "    Water vapour:     Vertically integrated water vapour (HTW), layered vertically ",
    "                      integrated water vapour and layer mean temperature and relative ",
    "                      humidity for 5 layers (HLW), temperature and mixing ratio at ",
    "                      6 pressure levels. ",
    "    ",
    "    Daily and monthly mean products can be ordered via the CM-SAF web page (www.cmsaf.eu). ",
    "    Products with higher spatial and temporal resolution, i.e. instantaneous swath-based products,",
    "    are available on request (contact.cmsaf@dwd.de). All products are distributed free-of-charge.",
    "    More information on the data is available on the CM-SAF homepage (www.cmsaf.eu).",
    "    ",
    "    Daily and monthly mean products are provided in equal-area projections. CDO reads the ",
    "    projection parameters from the metadata in the HDF5-headers in order to allow spatial ",
    "    operations like remapping. For spatial operations with instantaneous products on original ",
    "    satellite projection, additional files with arrays of latitudes and longitudes are needed.",
    "    These can be obtained from CM-SAF together with the data.",
    "    ",
    NULL
};

static char *ImportbinaryHelp[] = {
    "NAME",
    "    import_binary - Import binary data sets",
    "",
    "SYNOPSIS",
    "    import_binary  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded binary data sets via a GrADS data descriptor file.",
    "    The GrADS data descriptor file contains a complete description of the binary data as well ",
    "    as instructions on where to find the data and how to read it. The descriptor file is an ASCII ",
    "    file that can be created easily with a text editor. The general contents of a gridded data ",
    "    descriptor file are as follows:",
    "    - Filename for the binary data",
    "    - Missing or undefined data value",
    "    - Mapping between grid coordinates and world coordinates",
    "    - Description of variables in the binary data set ",
    "    ",
    "    A detailed description of the components of a GrADS data descriptor file can be found in GrADS.",
    "    Here is a list of the supported components:",
    "    BYTESWAPPED, CHSUB, DSET, ENDVARS, FILEHEADER, HEADERBYTES, OPTIONS, TDEF, TITLE, ",
    "    TRAILERBYTES, UNDEF, VARS, XDEF, XYHEADER, YDEF, ZDEF",
    NULL
};

static char *WctHelp[] = {
    "NAME",
    "    wct - Windchill temperature",
    "",
    "SYNOPSIS",
    "    wct  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 and ifile2 be time series of temperature and wind",
    "    speed records, then a corresponding time series of resulting windchill",
    "    temperatures is written to ofile. The wind chill temperature",
    "    calculation is only valid for a temperature of T <= 33 °C and a wind speed",
    "    of v >= 1.39 m/s. Whenever these conditions are not satisfied, a missing",
    "    value is written to ofile. Note that temperature and wind speed records",
    "    have to be given in units of °C and m/s, respectively.",
    NULL
};

static char *FdnsHelp[] = {
    "NAME",
    "    fdns - Frost days where no snow index per time period",
    "",
    "SYNOPSIS",
    "    fdns  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily minimum temperatures TN",
    "    and ifile2 be a corresponding series of daily surface snow",
    "    amounts. Then counted is the number of days where TN < 0 °C",
    "    and the surface snow amount is less than 1 cm. The temperature TN",
    "    have to be given in units of Kelvin.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *StrwinHelp[] = {
    "NAME",
    "    strwin - Strong wind days index per time period",
    "",
    "SYNOPSIS",
    "    strwin[,v]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily maximum horizontal wind speeds",
    "    VX, then counted is the number of days where VX > v. The horizontal wind",
    "    speed v is an optional parameter with default v = 10.5 m/s. A further",
    "    output variable is the maximum number of consecutive days with maximum wind",
    "    speed greater than or equal to v. Note that both VX and v have to be given in",
    "    units of m/s. Also note that the horizontal wind speed is defined as the",
    "    square root of the sum of squares of the zonal and meridional wind speeds.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    "",
    "PARAMETER",
    "    v  FLOAT   Horizontal wind speed threshold (m/s, default v = 10.5 m/s)",
    NULL
};

static char *StrbreHelp[] = {
    "NAME",
    "    strbre - Strong breeze days index per time period",
    "",
    "SYNOPSIS",
    "    strbre  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily maximum horizontal wind speeds",
    "    VX, then counted is the number of days where VX is greater than or equal ",
    "    to 10.5 m/s. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 10.5 m/s. Note that",
    "    VX is defined as the square root of the sum of squares of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *StrgalHelp[] = {
    "NAME",
    "    strgal - Strong gale days index per time period",
    "",
    "SYNOPSIS",
    "    strgal  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily maximum horizontal wind speeds",
    "    VX, then counted is the number of days where VX is greater than or equal ",
    "    to 20.5 m/s. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 20.5 m/s. Note that",
    "    VX is defined as the square root of the sum of square of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *HurrHelp[] = {
    "NAME",
    "    hurr - Hurricane days index per time period",
    "",
    "SYNOPSIS",
    "    hurr  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily maximum horizontal wind speeds",
    "    VX, then counted is the number of days where VX is greater than or equal ",
    "    to 32.5 m/s. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 32.5 m/s. Note that",
    "    VX is defined as the square root of the sum of squares of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaCddHelp[] = {
    "NAME",
    "    eca_cdd - Consecutive dry days index per time period",
    "",
    "SYNOPSIS",
    "    eca_cdd  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily precipitation amounts RR,",
    "    then counted is the largest number of consecutive days where",
    "    RR is less than 1 mm. A further output variable is the number of dry",
    "    periods of more than 5 days.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaCfdHelp[] = {
    "NAME",
    "    eca_cfd - Consecutive frost days index per time period",
    "",
    "SYNOPSIS",
    "    eca_cfd  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily minimum temperatures TN,",
    "    then counted is the largest number of consecutive days where",
    "    TN < 0 °C. Note that TN have to be given in units of Kelvin.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaCsuHelp[] = {
    "NAME",
    "    eca_csu - Consecutive summer days index per time period",
    "",
    "SYNOPSIS",
    "    eca_csu[,T]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily maximum temperatures TX,",
    "    then counted is the largest number of consecutive days where TX > T.",
    "    The number T is an optional parameter with default T = 25 °C.",
    "    Note that TN have to be given in units of Kelvin, whereas T have to be given",
    "    in degrees Celsius.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    "",
    "PARAMETER",
    "    T  DOUBLE   Temperature threshold ( Celsius, default: T = 25 Celsius)",
    NULL
};

static char *EcaCwdHelp[] = {
    "NAME",
    "    eca_cwd - Consecutive wet days index per time period",
    "",
    "SYNOPSIS",
    "    eca_cwd  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily precipitation amounts RR,",
    "    then counted is the largest number of consecutive days where",
    "    RR is at least 1 mm. A further output variable is the number of wet",
    "    periods of more than 5 days.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaCwdiHelp[] = {
    "NAME",
    "    eca_cwdi - Cold wave duration index wrt mean of reference period",
    "",
    "SYNOPSIS",
    "    eca_cwdi[,nday[,T]]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily minimum temperatures TN,",
    "    and let ifile2 be the mean TNnorm of daily minimum temperatures",
    "    for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TN < TNnorm - T.",
    "    The numbers nday and T are optional parameters with default nday = 6",
    "    and T = 5 °C. A further output variable is the number of cold",
    "    waves longer than or equal to nday days. Note that both TN and TNnorm",
    "    have to be given in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    "    T     FLOAT    Temperature offset ( Celsius, default: T = 5 Celsius)",
    NULL
};

static char *EcaCwfiHelp[] = {
    "NAME",
    "    eca_cwfi - Cold-spell days index wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_cwfi[,nday]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily mean temperatures TG, and ",
    "    ifile2 be the 10th percentile TGn10 of daily mean temperatures",
    "    for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TG < TGn10. The",
    "    number nday is an optional parameter with default nday = 6. A further",
    "    output variable is the number of cold-spell periods longer than or",
    "    equal to nday days. Note that both TG and TGn10 have to be given in the",
    "    same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    NULL
};

static char *EcaEtrHelp[] = {
    "NAME",
    "    eca_etr - Intra-period extreme temperature range",
    "",
    "SYNOPSIS",
    "    eca_etr  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 and ifile2 be time series of maximum and minimum",
    "    temperatures TX and TN, respectively. Then the extreme temperature",
    "    range is the difference of the maximum of TX and the minimum of TN.",
    "    Note that TX and TN have to be given in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time steps in ifile1 and ifile2.",
    NULL
};

static char *EcaFdHelp[] = {
    "NAME",
    "    eca_fd - Frost days index per time period",
    "",
    "SYNOPSIS",
    "    eca_fd  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily minimum temperatures TN,",
    "    then counted is the number of days where TN < 0 °C. Note",
    "    that TN have to be given in units of Kelvin.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaGslHelp[] = {
    "NAME",
    "    eca_gsl - Thermal Growing season length index",
    "",
    "SYNOPSIS",
    "    eca_gsl[,nday[,T[,fland]]]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily mean temperatures TG,",
    "    and ifile2 be a land-water mask.",
    "    Within a period of 12 months, the thermal growing season length is officially defined as the number of days between:",
    "    - frist occurrence of at least nday consecutive days with TG $>$ T within the first 6 months",
    "    - first occurrence of at least nday consecutive days with TG $<$ T within the last 6 months",
    "    On northern hemispere, this period corresponds with the regular year, whereas",
    "    on southern hemispere, it starts at july $1^{st}$. Please note, that this",
    "    definition may lead to weird results concerning values TG = T: In the first",
    "    half of the period, these days do not contribute to the gsl, but they do within the second half.",
    "    ",
    "    The numbers nday and T are optional parameter with default nday = 6",
    "    and T = 5 °C. The number fland is an optional parameter with",
    "    default value fland = 0.5 and denotes the fraction of a grid point that",
    "    have to be covered by land in order to be included in the calculation. A",
    "    further output variable is the start day of year of the growing season.",
    "    Note that TG have to be given in units of Kelvin, whereas T have to be given",
    "    in degrees Celsius.",
    "    ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    "",
    "PARAMETER",
    "    nday   INTEGER  Number of consecutive days (default: nday = 6)",
    "    T      DOUBLE   Temperature threshold (degree Celsius, default: T = 5 Celsius)",
    "    fland  DOUBLE   Land fraction threshold (default: fland = 0.5)",
    NULL
};

static char *EcaHdHelp[] = {
    "NAME",
    "    eca_hd - Heating degree days per time period",
    "",
    "SYNOPSIS",
    "    eca_hd[,T1[,T2]]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily mean temperatures TG, then",
    "    the heating degree days are defined as the sum of T1 - TG, where only",
    "    values TG < T2 are considered. If T1 and T2 are omitted, a temperature",
    "    of 17 °C is used for both parameters. If only T1 is given, T2 is",
    "    set to T1. Note that TG have to be given in units of kelvin, whereas T1",
    "    and T2 have to be given in degrees Celsius.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    "",
    "PARAMETER",
    "    T1  DOUBLE   Temperature limit ( Celsius, default: T1 = 17 Celsius)",
    "    T2  DOUBLE   Temperature limit ( Celsius, default: T2 = T1)",
    NULL
};

static char *EcaHwdiHelp[] = {
    "NAME",
    "    eca_hwdi - Heat wave duration index wrt mean of reference period",
    "",
    "SYNOPSIS",
    "    eca_hwdi[,nday[,T]]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily maximum temperatures TX,",
    "    and let ifile2 be the mean TXnorm of daily maximum temperatures",
    "    for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TX > TXnorm + T.",
    "    The numbers nday and T are optional parameters with default nday = 6",
    "    and T = 5 °C. A further output variable is the number of heat",
    "    waves longer than or equal to nday days. Note that both TX and TXnorm",
    "    have to be given in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    "    T     FLOAT    Temperature offset ( Celsius, default: T = 5 Celsius)",
    NULL
};

static char *EcaHwfiHelp[] = {
    "NAME",
    "    eca_hwfi - Warm spell days index wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_hwfi[,nday]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily mean temperatures TG, and ",
    "    ifile2 be the 90th percentile TGn90 of daily mean temperatures",
    "    for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TG > TGn90. The",
    "    number nday is an optional parameter with default nday = 6. A further",
    "    output variable is the number of warm-spell periods longer than or",
    "    equal to nday days. Note that both TG and TGn90 have to be given in the",
    "    same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    NULL
};

static char *EcaIdHelp[] = {
    "NAME",
    "    eca_id - Ice days index per time period",
    "",
    "SYNOPSIS",
    "    eca_id  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily maximum temperatures TX,",
    "    then counted is the number of days where TX < 0 °C. Note",
    "    that TX have to be given in units of Kelvin.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaR10mmHelp[] = {
    "NAME",
    "    eca_r10mm - Heavy precipitation days index per time period",
    "",
    "SYNOPSIS",
    "    eca_r10mm  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily precipitation amounts RR,",
    "    then counted is the number of days where RR is at least 10 mm. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaR20mmHelp[] = {
    "NAME",
    "    eca_r20mm - Very heavy precipitation days index per time period",
    "",
    "SYNOPSIS",
    "    eca_r20mm  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily precipitation amounts RR,",
    "    then counted is the number of days where RR is at least 20 mm. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaR75pHelp[] = {
    "NAME",
    "    eca_r75p - Moderate wet days wrt 75th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r75p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily precipitation amounts RR,",
    "    and ifile2 be the 75th percentile RRn75 of daily precipitation",
    "    amounts at wet days for any period used as reference. Then calculated",
    "    is the percentage of wet days with RR > RRn75. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaR75ptotHelp[] = {
    "NAME",
    "    eca_r75ptot - Precipitation percent due to R75p days",
    "",
    "SYNOPSIS",
    "    eca_r75ptot  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily precipitation amounts RR,",
    "    and ifile2 be the 75th percentile RRn75 of daily precipitation",
    "    amounts at wet days for any period used as reference. Then calculated",
    "    is the ratio of the precipitation sum at wet days with RR > RRn75",
    "    to the total precipitation sum. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaR90pHelp[] = {
    "NAME",
    "    eca_r90p - Wet days wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r90p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily precipitation amounts RR,",
    "    and ifile2 be the 90th percentile RRn90 of daily precipitation",
    "    amounts at wet days for any period used as reference. Then calculated",
    "    is the percentage of wet days with RR > RRn90. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaR90ptotHelp[] = {
    "NAME",
    "    eca_r90ptot - Precipitation percent due to R90p days",
    "",
    "SYNOPSIS",
    "    eca_r90ptot  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily precipitation amounts RR,",
    "    and ifile2 be the 90th percentile RRn90 of daily precipitation",
    "    amounts at wet days for any period used as reference. Then calculated",
    "    is the ratio of the precipitation sum at wet days with RR > RRn90",
    "    to the total precipitation sum. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaR95pHelp[] = {
    "NAME",
    "    eca_r95p - Very wet days wrt 95th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r95p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily precipitation amounts RR,",
    "    and ifile2 be the 95th percentile RRn95 of daily precipitation",
    "    amounts at wet days for any period used as reference. Then calculated",
    "    is the percentage of wet days with RR > RRn95. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaR95ptotHelp[] = {
    "NAME",
    "    eca_r95ptot - Precipitation percent due to R95p days",
    "",
    "SYNOPSIS",
    "    eca_r95ptot  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily precipitation amounts RR,",
    "    and ifile2 be the 95th percentile RRn95 of daily precipitation",
    "    amounts at wet days for any period used as reference. Then calculated",
    "    is the ratio of the precipitation sum at wet days with RR > RRn95",
    "    to the total precipitation sum. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaR99pHelp[] = {
    "NAME",
    "    eca_r99p - Extremely wet days wrt 99th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r99p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily precipitation amounts RR,",
    "    and ifile2 be the 99th percentile RRn99 of daily precipitation",
    "    amounts at wet days for any period used as reference. Then calculated",
    "    is the percentage of wet days with RR > RRn99. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaR99ptotHelp[] = {
    "NAME",
    "    eca_r99ptot - Precipitation percent due to R99p days",
    "",
    "SYNOPSIS",
    "    eca_r99ptot  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily precipitation amounts RR,",
    "    and ifile2 be the 99th percentile RRn99 of daily precipitation",
    "    amounts at wet days for any period used as reference. Then calculated",
    "    is the ratio of the precipitation sum at wet days with RR > RRn99",
    "    to the total precipitation sum. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaRr1Help[] = {
    "NAME",
    "    eca_rr1 - Wet days index per time period",
    "",
    "SYNOPSIS",
    "    eca_rr1  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily precipitation amounts RR,",
    "    then counted is the number of days where RR is at least 1 mm. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaRx1dayHelp[] = {
    "NAME",
    "    eca_rx1day - Highest one day precipitation amount per time period",
    "",
    "SYNOPSIS",
    "    eca_rx1day[,mode]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily precipitation amounts RR,",
    "    then the maximum of RR is written to ofile. If the optional",
    "    parameter mode is set to 'm', then maximum daily precipitation",
    "    amounts are determined for each month. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    "",
    "PARAMETER",
    "    mode  STRING   Operation mode (optional). If mode = 'm' then maximum daily precipitation amounts are determined for each month",
    NULL
};

static char *EcaRx5dayHelp[] = {
    "NAME",
    "    eca_rx5day - Highest five-day precipitation amount per time period",
    "",
    "SYNOPSIS",
    "    eca_rx5day[,x]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of 5-day precipitation totals RR,",
    "    then the maximum of RR is written to ofile. A further output",
    "    variable is the number of 5 day period with precipitation totals",
    "    greater than x mm, where x is an optional parameter with default",
    "    x = 50 mm.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    "",
    "PARAMETER",
    "    x  FLOAT   Precipitation threshold (mm, default: x = 50 mm)",
    NULL
};

static char *EcaSdiiHelp[] = {
    "NAME",
    "    eca_sdii - Simple daily intensity index per time period",
    "",
    "SYNOPSIS",
    "    eca_sdii  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily precipitation amounts RR,",
    "    then the mean precipitation amount at wet days (RR > 1 mm) is written",
    "    to ofile. ",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    NULL
};

static char *EcaSuHelp[] = {
    "NAME",
    "    eca_su - Summer days index per time period",
    "",
    "SYNOPSIS",
    "    eca_su[,T]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily maximum temperatures TX,",
    "    then counted is the number of days where TX > T. The number T is",
    "    an optional parameter with default T = 25 °C. Note that TX",
    "    have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    "",
    "PARAMETER",
    "    T  FLOAT   Temperature threshold (degree Celsius, default: T = 25 Celsius)",
    NULL
};

static char *EcaTg10pHelp[] = {
    "NAME",
    "    eca_tg10p - Cold days percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tg10p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily mean temperatures TG, and",
    "    ifile2 be the 10th percentile TGn10 of daily mean temperatures",
    "    for any period used as reference. Then calculated is the percentage",
    "    of time where TG < TGn10. Note that both TG and TGn10 have to be given",
    "    in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaTg90pHelp[] = {
    "NAME",
    "    eca_tg90p - Warm days percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tg90p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily mean temperatures TG, and",
    "    ifile2 be the 90th percentile TGn90 of daily mean temperatures",
    "    for any period used as reference. Then calculated is the percentage",
    "    of time where TG > TGn90. Note that both TG and TGn90 have to be given",
    "    in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaTn10pHelp[] = {
    "NAME",
    "    eca_tn10p - Cold nights percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tn10p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily minimum temperatures TN, and",
    "    ifile2 be the 10th percentile TNn10 of daily minimum temperatures",
    "    for any period used as reference. Then calculated is the percentage",
    "    of time where TN < TNn10. Note that both TN and TNn10 have to be given",
    "    in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaTn90pHelp[] = {
    "NAME",
    "    eca_tn90p - Warm nights percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tn90p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily minimum temperatures TN, and",
    "    ifile2 be the 90th percentile TNn90 of daily minimum temperatures",
    "    for any period used as reference. Then calculated is the percentage",
    "    of time where TN > TNn90. Note that both TN and TNn90 have to be given",
    "    in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaTrHelp[] = {
    "NAME",
    "    eca_tr - Tropical nights index per time period",
    "",
    "SYNOPSIS",
    "    eca_tr[,T]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of daily minimum temperatures TN,",
    "    then counted is the number of days where TN > T. The number T is",
    "    an optional parameter with default T = 20 °C. Note that TN",
    "    have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile.",
    "",
    "PARAMETER",
    "    T  FLOAT   Temperature threshold ( Celsius, default: T = 20 Celsius)",
    NULL
};

static char *EcaTx10pHelp[] = {
    "NAME",
    "    eca_tx10p - Very cold days percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tx10p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily maximum temperatures TX, and",
    "    ifile2 be the 10th percentile TNx10 of daily maximum temperatures",
    "    for any period used as reference. Then calculated is the percentage",
    "    of time where TX < TXn10. Note that both TX and TXn10 have to be given",
    "    in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};

static char *EcaTx90pHelp[] = {
    "NAME",
    "    eca_tx90p - Very warm days percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tx90p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of daily maximum temperatures TX, and",
    "    ifile2 be the 90th percentile TXn90 of daily maximum temperatures",
    "    for any period used as reference. Then calculated is the percentage",
    "    of time where TX > TXn90. Note that both TX and TXn90 have to be given",
    "    in the same units.",
    "    The date information of a time step in ofile is the date of",
    "    the last contributing time step in ifile1.",
    NULL
};
